/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.Model;
import com.adobe.xfa.font.FontService;
import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.layout.LayoutDriver;
import com.adobe.xfa.layout.LayoutHandler;
import com.adobe.xfa.service.Service;
import com.adobe.xfa.service.href.HrefService;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextResolver;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.ResId;

public class LayoutEnv
extends GFXEnv {
    private HrefService moHrefService;
    private FontService moFontService;
    private Model moModel;
    private LayoutHandler moLayoutHandler;
    private LayoutDriver moLayoutDriver;
    private TextResolver moTextResolver;
    private TextContext moTextContext;

    public LayoutEnv() {
        this(null, null, null, new LayoutDriver());
    }

    protected LayoutEnv(LayoutEnv oSource) {
    }

    public LayoutEnv(FontService oFontService, Service oImageService, HrefService oHrefService, LayoutDriver oDriver) {
        this.moLayoutDriver = oDriver;
        this.moHrefService = oHrefService;
        this.moFontService = oFontService;
        this.moLayoutHandler = null;
        this.moTextResolver = null;
        this.moTextContext = null;
        this.moTextContext = new TextContext();
        assert (null != oDriver);
        this.fontService(this.moFontService);
        this.moLayoutDriver.setLayoutEnv(this);
    }

    public void layoutHandler(LayoutHandler pHandler) {
        this.moLayoutHandler = pHandler;
    }

    public LayoutHandler layoutHandler() {
        return this.moLayoutHandler;
    }

    public HrefService getHrefService() {
        return this.moHrefService;
    }

    public void setFontService(FontService oFontService) {
        this.moFontService = oFontService;
        this.fontService(oFontService);
    }

    public FontService getFontService() {
        return this.moFontService;
    }

    public LayoutDriver setDriver(LayoutDriver oDriver) {
        LayoutDriver oOldDriver = this.moLayoutDriver;
        this.moLayoutDriver = oDriver;
        return oOldDriver;
    }

    public TextContext getTextContext() {
        return this.moTextContext;
    }

    public void setModel(Model oModel) {
        this.moModel = oModel;
    }

    public Model getModel() {
        return this.moModel;
    }

    public void setTextResolver(TextResolver pResolver) {
        assert (null != pResolver);
        this.moTextResolver = pResolver;
    }

    public TextResolver getTextResolver() {
        return this.moTextResolver;
    }

    public LayoutDriver getLayoutDriver() {
        return this.moLayoutDriver;
    }

    public int getMetaFileData(byte[] pClipData, int size, Rect oDrawArea) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "LayoutEnv#getMetaFileData");
    }

    public void setClipRect(Rect oRect) {
        this.moLayoutDriver.setClipRect(oRect);
    }

    public boolean renderText(LayoutHandler oLayoutHandler, TextDisplay oDisplay, CoordPair oOffset, boolean bWrap, boolean bTruncate, Rect oInvalidatedRect) {
        return this.renderText(oLayoutHandler, oDisplay, oOffset, bWrap, bTruncate, Angle.ZERO, oInvalidatedRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderText(LayoutHandler oLayoutHandler, TextDisplay oDisplay, CoordPair oOffset, boolean bWrap, boolean bTruncate, Angle oAngle, Rect oInvalidatedRect) {
        boolean bTextFits = false;
        if (oDisplay == null || null == this.moLayoutDriver) {
            return bTextFits;
        }
        this.moLayoutHandler = oLayoutHandler;
        GFXDriver oDriver = this.driverAttach();
        assert (oDriver == this.moLayoutDriver);
        LayoutEnv oEnv = this;
        try {
            this.moLayoutDriver.pushOffset(true, oOffset);
            this.moLayoutDriver.pushAngle(true, oAngle, false, oOffset);
            this.moLayoutHandler = null;
        }
        finally {
            oEnv.driverDetach();
            oDriver.popOffset();
            oDriver.popAngle();
        }
        return bTextFits;
    }

    @Override
    protected GFXDriver driver() {
        return this.moLayoutDriver;
    }
}

