/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.CalcParser;

final class ScopeTable {
    static final int SIZE = 128;
    private int mnNextScope;
    private int mnPrevScope;
    private int mnCurrentScope;
    private int mnActiveScopeSize;
    private int[] moActiveScope;
    private int mnFrameCounter;
    private static final int NBPI = 32;
    private static final int LNBPI = 5;

    ScopeTable() {
    }

    int create(int nSize) {
        this.mnNextScope = 0;
        this.mnPrevScope = 0;
        this.mnActiveScopeSize = nSize;
        this.moActiveScope = ScopeTable.bitAlloc(this.mnActiveScopeSize);
        return 1;
    }

    void init(CalcParser oParser) {
        if (!oParser.mbWasInSaveMode) {
            this.mnNextScope = 1;
            this.mnPrevScope = 1;
        } else if (oParser.mbSyntaxErrorSeen) {
            this.mnNextScope = this.mnPrevScope;
        } else {
            this.mnPrevScope = this.mnNextScope;
        }
        for (int i = this.mnNextScope - 1; i >= 0; --i) {
            ScopeTable.bitClr(this.moActiveScope, i);
        }
        this.mnFrameCounter = 0;
    }

    int getScope() {
        return this.mnCurrentScope;
    }

    void setScope(int scope) {
        this.mnCurrentScope = scope;
    }

    int getFrame() {
        return this.mnFrameCounter;
    }

    void setFrame(int frame) {
        this.mnFrameCounter = frame;
    }

    int enter() {
        if (this.mnNextScope == this.mnActiveScopeSize) {
            this.mnActiveScopeSize <<= 1;
            int[] oNewScope = ScopeTable.bitAlloc(this.mnActiveScopeSize);
            System.arraycopy(this.moActiveScope, 0, oNewScope, 0, (this.mnActiveScopeSize >> 1) + 32 >> 5);
            this.moActiveScope = oNewScope;
        }
        this.setActive(++this.mnNextScope);
        return this.mnCurrentScope;
    }

    int exit() {
        int nOldScope = this.mnCurrentScope;
        if (this.mnCurrentScope > 0) {
            this.clearActive(this.mnCurrentScope);
        }
        return nOldScope;
    }

    void setActive(int scope) {
        this.mnCurrentScope = scope;
        ScopeTable.bitSet(this.moActiveScope, scope - 1);
    }

    void clearActive(int scope) {
        int i;
        ScopeTable.bitClr(this.moActiveScope, scope - 1);
        for (i = scope - 2; i >= 0 && !ScopeTable.isbSet(this.moActiveScope, i); --i) {
        }
        this.mnCurrentScope = i + 1;
    }

    boolean isActive(int scope) {
        return scope > 0 && ScopeTable.isbSet(this.moActiveScope, scope - 1);
    }

    boolean isGlobal() {
        return this.mnCurrentScope == 1;
    }

    private static void bitSet(int[] a, int i) {
        int n = i >> 5;
        a[n] = a[n] | 1 << (i & 0x1F);
    }

    private static void bitClr(int[] a, int i) {
        int n = i >> 5;
        a[n] = a[n] & ~(1 << (i & 0x1F));
    }

    private static boolean isbSet(int[] a, int i) {
        return (a[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    private static int[] bitAlloc(int n) {
        return new int[n + 32 >> 5];
    }
}

