/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.binding.BindingNode;
import com.adobe.xfa.ut.Peer;
import java.util.ArrayList;
import java.util.List;

public class FormItemsDataListener
extends Obj {
    private Node mFormNode;
    private final BindingNode mBindItemsNode;
    private final List<Node> mDataNodes = new ArrayList<Node>();
    private final List<Boolean> mDataNodeTypes = new ArrayList<Boolean>();

    public FormItemsDataListener(Node formNode, Node bindingNode) {
        assert (formNode instanceof FormField);
        assert (bindingNode instanceof BindingNode);
        this.mFormNode = formNode;
        this.mBindItemsNode = (BindingNode)bindingNode;
    }

    void dispose() {
        this.clearDataPeers(null);
    }

    @Override
    public String getClassAtom() {
        return "formDataListener";
    }

    @Override
    public String getClassName() {
        return "formDataListener";
    }

    void addDataNode(Node dataNode, boolean bIsItemValue) {
        for (int i = 0; i < this.mDataNodes.size(); ++i) {
            if (this.mDataNodes.get(i) != dataNode) continue;
            this.mDataNodeTypes.set(i, bIsItemValue);
            return;
        }
        dataNode.addPeer(this);
        this.mDataNodes.add(dataNode);
        this.mDataNodeTypes.add(bIsItemValue);
    }

    Node getFormNode() {
        return this.mFormNode;
    }

    @Override
    public void updateFromPeer(Object peerNode, int eventType, String arg1, Object arg2) {
        for (int index = 0; index < this.mDataNodes.size(); ++index) {
            if (this.mDataNodes.get(index) != peerNode) continue;
            boolean bIsItemType = this.mDataNodeTypes.get(index);
            switch (eventType) {
                case 2: {
                    if (!bIsItemType) break;
                    this.clearDataPeers(this.mDataNodes.get(index));
                    ((FormField)this.mFormNode).updateItemsFromData(this.mBindItemsNode, false);
                    break;
                }
                case 4: 
                case 5: {
                    if (bIsItemType) break;
                    this.clearDataPeers(this.mDataNodes.get(index));
                    ((FormField)this.mFormNode).updateItemsFromData(this.mBindItemsNode, false);
                }
            }
            break;
        }
    }

    private void clearDataPeers(Node keepDataPeer) {
        for (int i = this.mDataNodes.size(); i > 0; --i) {
            if (keepDataPeer != null && this.mDataNodes.get(i - 1) == keepDataPeer) continue;
            this.mDataNodes.get(i - 1).removePeer(this);
        }
    }

    @Override
    public void peerRemoved(Peer pPeer) {
        for (int nIndex = 0; nIndex < this.mDataNodes.size(); ++nIndex) {
            if (this.mDataNodes.get(nIndex) != pPeer) continue;
            this.mDataNodes.remove(nIndex);
            this.mDataNodeTypes.remove(nIndex);
            break;
        }
        if (pPeer == this.mFormNode) {
            this.mFormNode = null;
        }
    }
}

