/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeValidationInfo;
import com.adobe.xfa.RichTextNodeScript;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.UnitSpan;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class RichTextNode
extends Element {
    static void updateIDAttrs(Element oDomNode, String sPrefix, List<String> oldReferenceList) {
        String sName;
        String string = sName = oDomNode instanceof Element ? oDomNode.getLocalName() : oDomNode.getName();
        if (sName == "span" && oDomNode.getNumAttrs() > 0) {
            int nSize = oDomNode.getNumAttrs();
            for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                String sIDReference;
                Attribute oAttr = oDomNode.getAttr(nIndex);
                if (!oAttr.getLocalName().equals("embed") || (sIDReference = oAttr.getAttrValue()).length() < 1 || sIDReference.charAt(0) != '#') continue;
                sIDReference = sIDReference.substring(1);
                if (oldReferenceList != null) {
                    oldReferenceList.add(sIDReference);
                }
                String sNewReference = "#" + sPrefix + ":" + sIDReference;
                oDomNode.updateAttributeInternal(oAttr.newAttribute(oAttr.getNS(), oAttr.getLocalName(), oAttr.getQName(), sNewReference, false));
            }
        }
        for (Node oChild = oDomNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (!(oChild instanceof Element)) continue;
            RichTextNode.updateIDAttrs((Element)oChild, sPrefix, oldReferenceList);
        }
    }

    public RichTextNode(Element pParent, Node prevSibling) {
        super(pParent, prevSibling, "#xHTML", null, "#xHTML", null, XFA.RICHTEXTNODETAG, "#xHTML");
        this.inhibitPrettyPrint(true);
    }

    private static boolean addValidationInfo(List<NodeValidationInfo> validationInfo, RichTextNode node, String aRichText, int nVersionIntro) {
        if (validationInfo != null) {
            NodeValidationInfo info = new NodeValidationInfo(aRichText, nVersionIntro, 63, node);
            validationInfo.add(info);
            return true;
        }
        return false;
    }

    public Element createProto(Element parent, boolean bFull) {
        RichTextNode clonedNode = (RichTextNode)this.clone(parent, true);
        AppModel parentAppModel = parent.getAppModel();
        if (parentAppModel != null && parentAppModel != this.getAppModel() && parentAppModel.bumpVersionOnRichTextLoad()) {
            parent.validateUsage(clonedNode.getVersionRequired(), 0, true);
        }
        return clonedNode;
    }

    public void updateIDValuesImpl(String sPrefix, List<String> oldReferenceList) {
        RichTextNode.updateIDAttrs(this, sPrefix, oldReferenceList);
    }

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (this.isSameClass(delta) && list != null) {
            Element parent = this.getXFAParent();
            Element deltaParent = delta.getXFAParent();
            Delta newDelta = new Delta(parent, deltaParent, this, delta, "");
            list.append(newDelta);
        }
    }

    @Override
    public Node getFirstXFAChild() {
        return null;
    }

    @Override
    public ScriptTable getScriptTable() {
        return RichTextNodeScript.getScriptTable();
    }

    public String getValue(boolean bAsFragment, boolean bSuppressPreamble, boolean bLegacyWhitespaceProcessing) {
        String sReturn = this.getValuesFromDom(this, bAsFragment, bSuppressPreamble, bLegacyWhitespaceProcessing);
        return sReturn;
    }

    public String getValuesFromDom(Node node, boolean bAsFragment, boolean bSuppressPreamble, boolean bLegacyWhitespaceProcessing) {
        StringBuilder htmlTextValue = new StringBuilder();
        if (bAsFragment) {
            ByteArrayOutputStream oFragmentStream = new ByteArrayOutputStream();
            DOMSaveOptions oOptions = new DOMSaveOptions();
            oOptions.setDisplayFormat(0);
            oOptions.setSaveTransient(true);
            oOptions.setEntityChars("\r");
            oOptions.setRangeMin('\u007f');
            oOptions.setRangeMax('\u00ff');
            oOptions.setExcludePreamble(bSuppressPreamble);
            node.getOwnerDocument().saveAs(oFragmentStream, node, oOptions);
            try {
                htmlTextValue.append(oFragmentStream.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            if (node instanceof TextNode) {
                String sNodeValue = ((TextNode)node).getValue();
                if (!bLegacyWhitespaceProcessing) {
                    boolean bSuppressLeading;
                    boolean bSuppressTrailing;
                    if (node.getXMLParent().getLocalName() == "span") {
                        bSuppressTrailing = false;
                        bSuppressLeading = false;
                    } else {
                        bSuppressLeading = node.getPreviousXMLSibling() == null;
                        bSuppressTrailing = node.getNextXMLSibling() == null;
                    }
                    int leadingWhitespace = 0;
                    for (int i = 0; i < sNodeValue.length() && Character.isWhitespace(sNodeValue.charAt(i)); ++i) {
                        ++leadingWhitespace;
                    }
                    if (leadingWhitespace == sNodeValue.length()) {
                        sNodeValue = bSuppressLeading || bSuppressTrailing ? "" : " ";
                    } else {
                        int nOriginalLength = sNodeValue.length();
                        sNodeValue = sNodeValue.substring(leadingWhitespace);
                        if (!bSuppressLeading && sNodeValue.length() < nOriginalLength) {
                            sNodeValue = " " + sNodeValue;
                        }
                        nOriginalLength = sNodeValue.length();
                        sNodeValue = sNodeValue.replaceAll("\\s+$", "");
                        if (!bSuppressTrailing && sNodeValue.length() < nOriginalLength) {
                            sNodeValue = sNodeValue + " ";
                        }
                    }
                }
                htmlTextValue.append(sNodeValue);
            }
            boolean bPara = false;
            for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                String sName;
                String string = sName = child instanceof Element ? ((Element)child).getLocalName() : null;
                if (sName == "p") {
                    if (!bPara) {
                        bPara = true;
                    } else {
                        htmlTextValue.append('\n');
                    }
                } else if (sName == "br") {
                    htmlTextValue.append('\n');
                }
                boolean bXFASpecialSpan = false;
                if (sName == "span") {
                    Element elementChild = (Element)child;
                    int nSize = elementChild.getNumAttrs();
                    for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                        Attribute attr = elementChild.getAttr(nIndex);
                        if (attr.getLocalName() != "style") continue;
                        if (attr.getAttrValue().startsWith("xfa-tab-count:")) {
                            String sNum = attr.getAttrValue().substring(14);
                            int nNum = Integer.parseInt(sNum);
                            for (int k = 0; k < nNum; ++k) {
                                htmlTextValue.append('\t');
                            }
                            bXFASpecialSpan = true;
                            break;
                        }
                        if (!attr.getAttrValue().startsWith("xfa-spacerun:yes") || bLegacyWhitespaceProcessing) continue;
                        String sSpanContent = this.getValuesFromDom(child, bAsFragment, bSuppressPreamble, bLegacyWhitespaceProcessing);
                        sSpanContent = sSpanContent.replace('\u00a0', ' ');
                        htmlTextValue.append(' ');
                        bXFASpecialSpan = true;
                        break;
                    }
                }
                if (bXFASpecialSpan) continue;
                htmlTextValue.append(this.getValuesFromDom(child, bAsFragment, bSuppressPreamble, bLegacyWhitespaceProcessing));
            }
        }
        return htmlTextValue.toString();
    }

    @Override
    protected boolean isIndexable() {
        return false;
    }

    @Override
    public boolean isValidChild(int eTag, int nError, boolean bBeforeInsert, boolean bOccurrenceErrorOnly) {
        return true;
    }

    public void setValue(String sData) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "RichTextNode#setValue");
    }

    public String toString() {
        return this.getValue(false, false, false);
    }

    boolean validateRichText(Node node, int nTargetVersion, List<NodeValidationInfo> validationInfo) {
        Attribute attr;
        int nIndex;
        boolean bRet = true;
        if (nTargetVersion >= 36) {
            return bRet;
        }
        if (!(node instanceof Element)) {
            return bRet;
        }
        Element element = (Element)node;
        String aName = element.getLocalName();
        int numAttrs = element.getNumAttrs();
        if ((aName == "span" || aName == "p") && numAttrs != 0) {
            for (nIndex = 0; nIndex < numAttrs; ++nIndex) {
                UnitSpan value;
                attr = element.getAttr(nIndex);
                if (attr.getLocalName() != "style") continue;
                String sStyleValue = attr.getAttrValue();
                if (nTargetVersion < 28 && sStyleValue.contains("xfa-tab-stops")) {
                    bRet = false;
                    if (!RichTextNode.addValidationInfo(validationInfo, this, "xfa-tab-stops", 28)) {
                        return false;
                    }
                }
                if (nTargetVersion < 28 && sStyleValue.contains("xfa-font-horizontal-scale")) {
                    bRet = false;
                    if (!RichTextNode.addValidationInfo(validationInfo, this, "xfa-font-horizontal-scale", 28)) {
                        return false;
                    }
                }
                if (nTargetVersion < 28 && sStyleValue.contains("xfa-font-vertical-scale")) {
                    bRet = false;
                    if (!RichTextNode.addValidationInfo(validationInfo, this, "xfa-font-vertical-scale", 28)) {
                        return false;
                    }
                }
                if (nTargetVersion < 28 && sStyleValue.contains("kerning-mode")) {
                    bRet = false;
                    if (!RichTextNode.addValidationInfo(validationInfo, this, "kerning-mode", 28)) {
                        return false;
                    }
                }
                if (nTargetVersion >= 28 || !sStyleValue.contains("letter-spacing")) continue;
                int nFoundAt = sStyleValue.indexOf("letter-spacing");
                String sLetterSpacingValue = sStyleValue.substring(nFoundAt + "letter-spacing".length());
                if ((nFoundAt = sLetterSpacingValue.indexOf(59)) != -1) {
                    sLetterSpacingValue = sLetterSpacingValue.substring(0, nFoundAt);
                }
                if ((value = new UnitSpan(sLetterSpacingValue)).equals(UnitSpan.ZERO)) continue;
                bRet = false;
                if (RichTextNode.addValidationInfo(validationInfo, this, "letter-spacing", 28)) continue;
                return false;
            }
        } else if (nTargetVersion < 28 && aName == "a" && element.getNumAttrs() != 0) {
            for (nIndex = 0; nIndex < numAttrs; ++nIndex) {
                attr = element.getAttr(nIndex);
                if (attr.getLocalName() != "href") continue;
                bRet = false;
                if (RichTextNode.addValidationInfo(validationInfo, this, "href", 28)) continue;
                return false;
            }
        } else if (nTargetVersion < 33) {
            if (aName.equals("ol")) {
                bRet = false;
                if (!RichTextNode.addValidationInfo(validationInfo, this, "ol", 33)) {
                    return false;
                }
            } else if (aName.equals("ul")) {
                bRet = false;
                if (!RichTextNode.addValidationInfo(validationInfo, this, "ul", 33)) {
                    return false;
                }
            } else if (aName.equals("li")) {
                bRet = false;
                if (!RichTextNode.addValidationInfo(validationInfo, this, "li", 33)) {
                    return false;
                }
            }
        }
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (this.validateRichText(child, nTargetVersion, validationInfo)) continue;
            bRet = false;
            if (validationInfo != null) continue;
            return false;
        }
        return bRet;
    }

    @Override
    public boolean validateSchema(int nTargetVersion, int nTargetAvailability, boolean bRecursive, List<NodeValidationInfo> pValidationInfo) {
        boolean bRet = super.validateSchema(nTargetVersion, nTargetAvailability, bRecursive, pValidationInfo);
        if (!this.validateRichText(this, nTargetVersion, pValidationInfo)) {
            bRet = false;
        }
        return bRet;
    }

    public int getVersionRequired() {
        int nVersion = 21;
        ArrayList<NodeValidationInfo> infos = new ArrayList<NodeValidationInfo>();
        if (!this.validateRichText(this, nVersion, infos)) {
            for (int i = 0; i < infos.size(); ++i) {
                NodeValidationInfo info = (NodeValidationInfo)infos.get(i);
                if (info.nVersionIntro <= nVersion) continue;
                nVersion = info.nVersionIntro;
            }
        }
        return nVersion;
    }

    @Override
    protected boolean compareVersions(Node oRollback, Node oContainer, Node.ChangeLogger oChangeLogger, Object oUserData) {
        boolean bMatches = super.compareVersions(oRollback, oContainer, oChangeLogger, oUserData);
        if (!bMatches && oChangeLogger == null) {
            return false;
        }
        String sCanonicalSource = "";
        String sCanonicalRollback = "";
        Canonicalize c = new Canonicalize(this, false, true);
        byte[] pBuffer = c.canonicalize(2, null);
        try {
            sCanonicalSource = new String(pBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Canonicalize cRollBack = new Canonicalize(oRollback, false, true);
        pBuffer = cRollBack.canonicalize(2, null);
        try {
            sCanonicalRollback = new String(pBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!sCanonicalSource.equals(sCanonicalRollback)) {
            bMatches = false;
            if (oChangeLogger != null) {
                this.logValueChangeHelper(oContainer, sCanonicalSource, oChangeLogger, oUserData);
            }
        }
        return bMatches;
    }

    @Override
    public void saveXML(OutputStream outFile, DOMSaveOptions options, boolean bSaveXMLScript) {
        if (options != null) {
            DOMSaveOptions oNewOptions = new DOMSaveOptions(options);
            oNewOptions.setSaveTransient(true);
            super.saveXML(outFile, oNewOptions, bSaveXMLScript);
        } else {
            super.saveXML(outFile, options, bSaveXMLScript);
        }
    }

    private abstract class VisitAttr {
        private VisitAttr() {
        }

        abstract void visitAttribute(Element var1, Attribute var2);
    }

    class UpdateVisitAttr
    extends VisitAttr {
        private final List<String> moNewIDValues;
        private final List<String> moOrigIDValues;

        UpdateVisitAttr(List<String> oOrigIDValues, List<String> oNewIDValues) {
            this.moOrigIDValues = oOrigIDValues;
            this.moNewIDValues = oNewIDValues;
        }

        @Override
        void visitAttribute(Element element, Attribute oAttr) {
            String sIDValue = oAttr.getAttrValue();
            if (sIDValue.length() > 0 && sIDValue.charAt(0) == '#') {
                sIDValue = sIDValue.substring(1);
            }
            for (int i = 0; i < this.moOrigIDValues.size(); ++i) {
                String sOrigIDValue = this.moOrigIDValues.get(i);
                String sNewIDValue = this.moNewIDValues.get(i);
                if (!sIDValue.equals(sOrigIDValue)) continue;
                sNewIDValue = "#" + sNewIDValue;
                element.setAttribute(oAttr.getNS(), oAttr.getQName(), oAttr.getLocalName(), sNewIDValue, false);
                break;
            }
        }
    }

    class FetchVisitAttr
    extends VisitAttr {
        private final List<String> moIDValues;

        FetchVisitAttr(List<String> oIDValues) {
            this.moIDValues = oIDValues;
        }

        @Override
        void visitAttribute(Element element, Attribute oAttr) {
            String sIDValue = oAttr.getAttrValue();
            if (sIDValue.length() > 0 && sIDValue.charAt(0) == '#') {
                sIDValue = sIDValue.substring(1);
                this.moIDValues.add(sIDValue);
            }
        }
    }
}

