/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormImportData;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToEmbedded;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionLaunch;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSetOCGState;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionTransition;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionURI;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionFormImportData;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionGoTo;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionGoToEmbedded;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionJavaScript;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionLaunch;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionNamed;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionSetOCGState;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionSound;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionTransition;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionURI;

public class XPDFActionFactory {
    public static XPDFAction newXPDFActionInstance(PDFAction pdfaction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subtype = pdfaction.getSubtype();
        if (ASName.k_GoTo == subtype) {
            return new XPDFActionGoTo((PDFActionGoTo)pdfaction);
        }
        if (ASName.k_GoToE == subtype) {
            return new XPDFActionGoToEmbedded((PDFActionGoToEmbedded)pdfaction);
        }
        if (ASName.k_GoToR == subtype) {
            return new XPDFActionGoToRemote((PDFActionGoToRemote)pdfaction);
        }
        if (ASName.k_Launch == subtype) {
            return new XPDFActionLaunch((PDFActionLaunch)pdfaction);
        }
        if (ASName.k_URI == subtype) {
            return new XPDFActionURI((PDFActionURI)pdfaction);
        }
        if (ASName.k_Sound == subtype) {
            return new XPDFActionSound((PDFActionSound)pdfaction);
        }
        if (ASName.k_Named == subtype) {
            return new XPDFActionNamed((PDFActionNamed)pdfaction);
        }
        if (ASName.k_SetOCGState == subtype) {
            return new XPDFActionSetOCGState((PDFActionSetOCGState)pdfaction);
        }
        if (ASName.k_Trans == subtype) {
            return new XPDFActionTransition((PDFActionTransition)pdfaction);
        }
        if (ASName.k_ImportData == subtype) {
            return new XPDFActionFormImportData((PDFActionFormImportData)pdfaction);
        }
        if (ASName.k_JavaScript == subtype) {
            return new XPDFActionJavaScript((PDFActionJavaScript)pdfaction);
        }
        return new XPDFAction(pdfaction);
    }

    public static PDFAction newSkeletonInstance(String subtype, PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (subtype == null) {
            return null;
        }
        if ("GoTo".equals(subtype)) {
            return PDFActionGoTo.newSkeletonInstance(doc);
        }
        if ("GoToE".equals(subtype)) {
            return PDFActionGoToEmbedded.newSkeletonInstance(doc);
        }
        if ("GoToR".equals(subtype)) {
            return PDFActionGoToRemote.newSkeletonInstance(doc);
        }
        if ("Launch".equals(subtype)) {
            return PDFActionLaunch.newSkeletonInstance(doc);
        }
        if ("URI".equals(subtype)) {
            return PDFActionURI.newSkeletonInstance(doc);
        }
        if ("Sound".equals(subtype)) {
            return PDFActionSound.newSkeletonInstance(doc);
        }
        if ("Named".equals(subtype)) {
            return PDFActionNamed.newSkeletonInstance(doc);
        }
        if ("SetOCGState".equals(subtype)) {
            return PDFActionSetOCGState.newSkeletonInstance(doc);
        }
        if ("Trans".equals(subtype)) {
            return PDFActionTransition.newSkeletonInstance(doc);
        }
        if ("ImportData".equals(subtype)) {
            return PDFActionFormImportData.newSkeletonInstance(doc);
        }
        if ("JavaScript".equals(subtype)) {
            return PDFActionJavaScript.newSkeletonInstance(doc);
        }
        return null;
    }
}

