/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class XMLNamespaceUsage {
    private final String uri;
    private Set<String> prefixes;
    private Set<String> elements;
    private Set<String> attributes;

    public XMLNamespaceUsage(String uri) {
        this.uri = uri;
        this.prefixes = new HashSet<String>();
        this.elements = new HashSet<String>();
        this.attributes = new HashSet<String>();
    }

    public XMLNamespaceUsage(XMLNamespaceUsage otherNamespaceUsage) {
        this(otherNamespaceUsage.uri);
        this.prefixes.addAll(otherNamespaceUsage.prefixes);
        this.elements.addAll(otherNamespaceUsage.elements);
        this.attributes.addAll(otherNamespaceUsage.attributes);
    }

    public boolean addPrefix(String prefix) {
        return this.prefixes.add(prefix);
    }

    public boolean addElement(String element) {
        return this.elements.add(element);
    }

    public boolean addAttribute(String attribute) {
        return this.attributes.add(attribute);
    }

    public Set<String> getPrefixes() {
        return Collections.unmodifiableSet(this.prefixes);
    }

    public String getURI() {
        return this.uri;
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public Set<String> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public boolean removeElements(Set<String> elements) {
        if (elements == null) {
            System.out.println("removeElements: elements set to remove is null");
            return false;
        }
        return this.removeStringsFromSet(this.elements, elements);
    }

    public boolean removeElement(String element) {
        return this.removeStringFromSet(this.elements, element);
    }

    public boolean removeAttributes(Set<String> attributes) {
        return this.removeStringsFromSet(this.attributes, attributes);
    }

    public boolean removeAttribute(String attribute) {
        return this.removeStringFromSet(this.attributes, attribute);
    }

    public void removeAttributes() {
        this.attributes.clear();
    }

    public boolean removePrefix(String prefix) {
        return this.prefixes.remove(prefix);
    }

    public boolean isEmpty() {
        return this.isEmpty(false);
    }

    public boolean isEmpty(boolean ignorePrefixes) {
        if (!this.attributes.isEmpty()) {
            return false;
        }
        if (!this.elements.isEmpty()) {
            return false;
        }
        return ignorePrefixes || this.prefixes.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append("uri = ");
        builder.append(this.uri);
        builder.append("\n\t");
        builder.append("prefixes = ");
        builder.append(this.prefixes);
        builder.append("\n\t");
        builder.append("elements = ");
        builder.append(this.elements);
        builder.append("\n\t");
        builder.append("attributes = ");
        builder.append(this.attributes);
        builder.append("\n");
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof XMLNamespaceUsage)) {
            return false;
        }
        XMLNamespaceUsage otherUsage = (XMLNamespaceUsage)other;
        return this.uri.equals(otherUsage.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    boolean removeStringsFromSet(Set<String> baseSet, Set<String> removethis) {
        int size = baseSet.size();
        for (String str : removethis) {
            this.removeStringFromSet(baseSet, str);
        }
        return size != baseSet.size();
    }

    boolean removeStringFromSet(Set<String> baseSet, String str) {
        boolean retValue = false;
        Iterator<String> iter = baseSet.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (!s.equalsIgnoreCase(str)) continue;
            retValue = true;
            iter.remove();
        }
        return retValue;
    }
}

