/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.services.javascript.App;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptSecurityException;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.HostPseudoModel;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class XFAHostPseudoModel
extends HostPseudoModel {
    private final PDFDocument pdfDoc;
    private final AppModel appModel;
    private boolean validationsEnabled = true;
    private boolean calculationsEnabled = true;

    public XFAHostPseudoModel(PDFDocument pdfDoc) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDoc = pdfDoc;
        this.appModel = this.getXFADOM(pdfDoc, null).getAppModel();
    }

    public XFAHostPseudoModel(PDFDocument pdfDoc, AppModel appModel) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDoc = pdfDoc;
        this.appModel = appModel;
    }

    public XFAHostPseudoModel(DocumentContext oDocumentContext) {
        this.pdfDoc = oDocumentContext.mpdDoc;
        this.appModel = oDocumentContext.moAppModel;
    }

    @Override
    public final boolean importDataPermsCheck() {
        DataModel dataModel = DataModel.getDataModel(this.appModel, true, true);
        if (dataModel != null) {
            if (!dataModel.checkPerms()) {
                return false;
            }
            for (Node childNode = dataModel.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                if (childNode.getClassTag() == XFA.DATAGROUPTAG && childNode.getName().equals("dataDescription") || childNode.checkDescendentPerms()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean resetDataPermsCheck(List<String> nodes) {
        FormModel formModel = FormModel.getFormModel(this.appModel, true);
        if (formModel == null) {
            return false;
        }
        int nodeSize = nodes.size();
        if (nodeSize > 0) {
            boolean permsChecked = false;
            for (int nIndex = 0; nIndex < nodeSize; ++nIndex) {
                Obj resolvedNode;
                Element aliasNode = formModel.getAliasNode();
                if (aliasNode == null) continue;
                SOMParser somParser = new SOMParser(null);
                ArrayList<SOMParser.SomResultInfo> somResultInfo = new ArrayList<SOMParser.SomResultInfo>();
                somParser.resolve(aliasNode, nodes.get(nIndex), somResultInfo);
                if (somResultInfo.isEmpty() || !((resolvedNode = ((SOMParser.SomResultInfo)somResultInfo.get((int)0)).object) instanceof Node)) continue;
                permsChecked = true;
                if (this.permsCheck((Node)resolvedNode)) continue;
                return false;
            }
            if (!permsChecked) {
                return this.permsCheck(formModel);
            }
        } else {
            return this.permsCheck(formModel);
        }
        return true;
    }

    private boolean permsCheck(Node treeNode) {
        if (treeNode instanceof FormField || treeNode instanceof FormExclGroup || treeNode instanceof FormSubform || treeNode instanceof FormModel) {
            if (!treeNode.checkAncestorPerms()) {
                return false;
            }
            for (Node childNode = treeNode.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                if (!(childNode instanceof FormField) && !(childNode instanceof FormExclGroup) && !(childNode instanceof FormSubform) || this.permsCheck(childNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "Acrobat";
    }

    @Override
    public String getAppType() {
        return this.getApp().getViewerType().toString();
    }

    @Override
    public String getVariation() {
        return this.getApp().getViewerVariation().toString();
    }

    @Override
    public String getVersion() {
        try {
            return Double.toString(this.getApp().getViewerVersion());
        }
        catch (JavaScriptException ex) {
            return "";
        }
    }

    @Override
    public String getPlatform() {
        return this.getApp().getPlatform().toString();
    }

    @Override
    public String getLanguage() {
        LcLocale oLocale = new LcLocale(LcLocale.getLocale());
        if (!oLocale.isValid()) {
            oLocale = new LcLocale("en_US");
        }
        return oLocale.getIsoName();
    }

    @Override
    public String getTitle() {
        if (this.pdfDoc != null) {
            try {
                PDFDocumentInfo docInfo = this.pdfDoc.getDocumentInfo();
                if (docInfo != null) {
                    return docInfo.getTitle();
                }
            }
            catch (PDFException e) {
                throw new ExFull(e);
            }
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (this.pdfDoc != null) {
            try {
                PDFDocumentInfo docInfo = this.pdfDoc.getDocumentInfo();
                if (docInfo != null) {
                    docInfo.setTitle(title);
                }
            }
            catch (PDFException e) {
                throw new ExFull(e);
            }
        }
    }

    @Override
    public int getNumPages() {
        if (this.pdfDoc != null) {
            try {
                return this.pdfDoc.requirePages().getNumPages();
            }
            catch (PDFException e) {
                throw new ExFull(e);
            }
        }
        return 0;
    }

    @Override
    public int getCurrentPage() {
        Object value = this.getDoc().getPageNum();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return -1;
    }

    @Override
    public void setCurrentPage(int nPage) {
        this.getDoc().setPageNum(nPage);
    }

    @Override
    public boolean getCalculationsEnabled() {
        TemplateModel oTemplateModel;
        XFAProcessingOptions xfaOptions = XFADOMService.getXFAProcessingOptions(this.pdfDoc);
        if (xfaOptions != null && !xfaOptions.acrobatJavaScriptExecutionEnabled()) {
            return this.calculationsEnabled;
        }
        DocumentContext oContext = this.getDocumentContext();
        boolean bLegacyScripting = false;
        if (oContext != null && (oTemplateModel = oContext.getTemplateModel()) != null && oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
            bLegacyScripting = true;
        }
        if (bLegacyScripting) {
            return this.getApp().getCalculate();
        }
        return this.getDoc().getCalculate();
    }

    @Override
    public void setCalculationsEnabled(boolean enabled) {
        TemplateModel oTemplateModel;
        this.calculationsEnabled = enabled;
        XFAProcessingOptions xfaOptions = XFADOMService.getXFAProcessingOptions(this.pdfDoc);
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(this.pdfDoc);
        if (xfaOptions != null && !xfaOptions.acrobatJavaScriptExecutionEnabled() && jsHandler == null) {
            return;
        }
        this.getDoc().setCalculate(enabled);
        DocumentContext oContext = this.getDocumentContext();
        boolean bLegacyScripting = false;
        if (oContext != null && (oTemplateModel = oContext.getTemplateModel()) != null && oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
            bLegacyScripting = true;
        }
        if (bLegacyScripting) {
            this.getApp().setCalculate(enabled);
        } else {
            this.getDoc().setCalculate(enabled);
        }
    }

    @Override
    public boolean getValidationsEnabled() {
        return this.validationsEnabled;
    }

    @Override
    public void setValidationsEnabled(boolean enabled) {
        this.validationsEnabled = enabled;
    }

    @Override
    public void pageDown() {
        Object value = this.getDoc().getPageNum();
        double dPage = value instanceof Number ? ((Number)value).doubleValue() : -1.0;
        this.getDoc().setPageNum(dPage += 1.0);
    }

    @Override
    public void pageUp() {
        Object value = this.getDoc().getPageNum();
        double dPage = value instanceof Number ? ((Number)value).doubleValue() : -1.0;
        this.getDoc().setPageNum(dPage -= 1.0);
    }

    @Override
    public Obj getFocus() {
        return null;
    }

    @Override
    public void setFocus(String sSOMExp) {
        DocumentContext oContext = this.getDocumentContext();
        oContext.performRendering();
        Node oNode = oContext.moAppModel.resolveNode(sSOMExp);
        this.setFocusImpl(oNode);
    }

    @Override
    public void setFocus(Node node) {
        DocumentContext oContext = this.getDocumentContext();
        oContext.performRendering();
        this.setFocusImpl(node);
    }

    private void setFocusImpl(Node oNode) {
        DocumentContext oContext = this.getDocumentContext();
        oContext.setTargetFocusSOM(oNode.getSOMExpression());
    }

    @Override
    public void exportData(String sFilename, boolean bXDP) {
        this.getDoc().exportXFAData(sFilename, bXDP, null);
    }

    @Override
    public void importData(String sFilename) {
        this.getDoc().importXFAData(sFilename);
    }

    @Override
    public void resetData(List<String> oNodes) {
        ArrayList<String> oFieldNames = new ArrayList<String>();
        FormModel oFormModel = this.getDocumentContext().getFormModel();
        if (!oNodes.isEmpty()) {
            int nSize = oNodes.size();
            for (int i = 0; i < nSize; ++i) {
                String sName;
                Obj oResolvedNode;
                Element oFormNode = oFormModel.getAliasNode();
                SOMParser oParser = new SOMParser();
                ArrayList<SOMParser.SomResultInfo> oLHSResult = new ArrayList<SOMParser.SomResultInfo>();
                oParser.resolve(oFormNode, oNodes.get(i), oLHSResult);
                if (oLHSResult.isEmpty() || !((oResolvedNode = ((SOMParser.SomResultInfo)oLHSResult.get((int)0)).object) instanceof FormField) && !(oResolvedNode instanceof FormExclGroup) && !(oResolvedNode instanceof FormSubform) || StringUtils.isEmpty(sName = ((Node)oResolvedNode).getSOMExpression(oFormNode, false))) continue;
                oFieldNames.add(sName);
            }
        }
        try {
            NativeArray array = new NativeArray(oFieldNames.toArray());
            this.getDoc().resetForm(array);
        }
        catch (IllegalAccessException ex) {
            throw new ExFull("IllegalAccessException exception encountered", 0);
        }
        catch (NoSuchFieldException ex) {
            throw new ExFull("NoSuchFieldException exception encountered", 0);
        }
        catch (JavaScriptSecurityException ex) {
            throw new ExFull("JavaScriptSecurityException exception encountered", 0);
        }
        catch (PDFException ex) {
            throw new ExFull("PDFException exception encountered", 0);
        }
        this.getDocumentContext().postResetFormData();
    }

    @Override
    public void gotoURL(String sURL, boolean bAppend) {
        bAppend = false;
        this.getDoc().getURL(sURL, bAppend);
    }

    @Override
    public int messageBox(String sMessage, String sTitle, int nIcon, int nType) {
        return this.getApp().alert(sMessage, nIcon, nType, sTitle, null, null);
    }

    @Override
    public void beep(int nBeep) {
        this.getApp().beep(nBeep);
    }

    @Override
    public void print(boolean bUI, int nStart, int nEnd, boolean bSilent, boolean bShrinkToFit, boolean bPrintAsImage, boolean bReverse, boolean bAnnotation) {
        this.getDoc().print(bUI, nStart, nEnd, bSilent, bShrinkToFit, bPrintAsImage, bReverse, bAnnotation, null);
    }

    @Override
    public String response(String sQuestion, String sTitle, String sDefault, boolean bPassword) {
        String sResponse = null;
        Object response = this.getApp().response(sQuestion, sTitle, sDefault, bPassword, null);
        if (response != null) {
            sResponse = (String)response;
        } else {
            TemplateModel oTemplate = this.getDocumentContext().getTemplateModel();
            if (oTemplate != null && oTemplate.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
                sResponse = "";
            }
        }
        return sResponse;
    }

    @Override
    public void openList(String sSOMExp) {
        Node oNode = this.getDocumentContext().moAppModel.resolveNode(sSOMExp);
        this.openList(oNode);
    }

    @Override
    public void openList(Node oNode) {
        if (!(oNode instanceof FormField)) {
            return;
        }
        UI oUI = (UI)((FormField)oNode).peekElement(XFA.UITAG, true, 0);
        Element oCurrentUI = oUI.getUIElement(false);
        if (oCurrentUI.getClassTag() != XFA.CHOICELISTTAG) {
            return;
        }
        int eOpen = oCurrentUI.getEnum(XFA.OPENTAG);
        if (eOpen != 2293761 && eOpen != 0x230000) {
            return;
        }
    }

    @Override
    public String metaData(int nOutputType) {
        return "";
    }

    private XFADOM getXFADOM(PDFDocument pdfDoc, XFAProcessingOptions xfaOptions) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return XFADOMService.getXFADOM(pdfDoc, xfaOptions, false, true);
    }

    private JavaScriptHandler getJavaScriptHandler() {
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(this.pdfDoc);
        if (jsHandler == null) {
            throw new ExFull("Unable to get the Document's JS Handler", 0);
        }
        return jsHandler;
    }

    private Doc getDoc() {
        return this.getJavaScriptHandler().getDocLevelScope();
    }

    private App getApp() {
        return (App)this.getDoc().get("app", (Scriptable)this.getDoc());
    }

    private DocumentContext getDocumentContext() {
        DocumentContext documentContext = DocumentContext.find(this.pdfDoc, false, null);
        assert (documentContext != null);
        return documentContext;
    }
}

