/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.CustomAuthHandlerInterface;
import com.adobe.internal.pdftoolkit.services.xfa.UserIdPassword;
import com.adobe.xfa.protocol.AuthenticationHandler;
import com.adobe.xfa.ut.CharacterHolder;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.StringHolder;

class ProxyAuthenticationHandler
extends AuthenticationHandler {
    private CustomAuthHandlerInterface customAuthenticationHandler = null;

    public ProxyAuthenticationHandler(CustomAuthHandlerInterface customAuthenticationHandler) {
        super(ProxyAuthenticationHandler.getHandlerType(customAuthenticationHandler));
        this.customAuthenticationHandler = customAuthenticationHandler;
    }

    private static AuthenticationHandler.HandlerType getHandlerType(CustomAuthHandlerInterface customAuthHandler) {
        if (customAuthHandler == null) {
            return null;
        }
        CustomAuthHandlerInterface.CustomAuthHandlerType customAuthHandlerType = customAuthHandler.getHandlerType();
        if (customAuthHandlerType == CustomAuthHandlerInterface.CustomAuthHandlerType.CLIENT) {
            return AuthenticationHandler.HandlerType.CLIENT;
        }
        if (customAuthHandlerType == CustomAuthHandlerInterface.CustomAuthHandlerType.SERVER) {
            return AuthenticationHandler.HandlerType.SERVER;
        }
        return null;
    }

    @Override
    public boolean checkAuthenticationStatus() {
        return false;
    }

    @Override
    public boolean checkSOAPAuthenticationStatus() {
        return false;
    }

    @Override
    public AuthenticationHandler clone() {
        return null;
    }

    @Override
    public boolean getBasicCredentials(String url, String realm, StringHolder userID, CharacterHolder password) {
        UserIdPassword userIdPassword = this.customAuthenticationHandler.getBasicCredentials(url, realm);
        if (userIdPassword == null) {
            return false;
        }
        userID.value = userIdPassword.getUserId();
        password.value = userIdPassword.getPassword();
        return true;
    }

    @Override
    public boolean getBasicSOAPCredentials(String soapAddress, String connectionName, String operationName, StringHolder userID, CharacterHolder password) {
        UserIdPassword userIdPassword = this.customAuthenticationHandler.getBasicSOAPCredentials(soapAddress, connectionName, operationName);
        if (userIdPassword == null) {
            return false;
        }
        userID.value = userIdPassword.getUserId();
        password.value = userIdPassword.getPassword();
        return true;
    }

    @Override
    public boolean getCertificateCredentials(String url, CharacterHolder certPassword, IntegerHolder certSize, ObjectHolder<byte[]> certBuffer, StringHolder hint) {
        return false;
    }

    @Override
    public boolean isCertificateAuthorityValid(String url) {
        return false;
    }
}

