/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.SamePositionCharacterComparator;
import java.util.Comparator;

class PositionBasedHorizontalCharacterSorter
implements Comparator<PDFCharacter> {
    private boolean ignoreYCoordinates;

    public PositionBasedHorizontalCharacterSorter() {
        this.ignoreYCoordinates = false;
    }

    public PositionBasedHorizontalCharacterSorter(boolean ignoreYCoordinates) {
        this.ignoreYCoordinates = ignoreYCoordinates;
    }

    @Override
    public int compare(PDFCharacter c1, PDFCharacter c2) {
        if (c1 == c2) {
            return 0;
        }
        ASCoordinate origin1 = c1.getSortCordinate() == null ? c1.getOrigin() : c1.getSortCordinate();
        ASCoordinate origin2 = c2.getSortCordinate() == null ? c2.getOrigin() : c2.getSortCordinate();
        double x1 = origin1.x();
        double y1 = origin1.y();
        double x2 = origin2.x();
        double y2 = origin2.y();
        if (this.ignoreYCoordinates) {
            y1 = y2;
        }
        if (y2 < y1) {
            return -1;
        }
        if (y1 < y2) {
            return 1;
        }
        if (x1 < x2) {
            return -1;
        }
        if (x1 > x2) {
            return 1;
        }
        try {
            return SamePositionCharacterComparator.compareTo(c1, c2);
        }
        catch (Exception e) {
            throw new PDFRuntimeException("Exception occured while comparing unicode strings.", e);
        }
    }
}

