/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class RedactionState {
    private Map<Integer, ReferencedValue> annotationAppearanceStream = new HashMap<Integer, ReferencedValue>();
    private Map<Integer, Set<Integer>> structParentMap = new HashMap<Integer, Set<Integer>>();
    private Set<String> acroFormButtonFieldSet = new HashSet<String>();
    private Set<Integer> redactedAnnotationsSet = new HashSet<Integer>();
    private Map<String, ReferencedValue> namedJavaScriptReferenceMap = new HashMap<String, ReferencedValue>();
    private Map<String, ReferencedValue> namedDestinationReferenceMap = new HashMap<String, ReferencedValue>();
    private Map<String, ReferencedValue> namedEmbeddedFilesReferenceMap = new HashMap<String, ReferencedValue>();
    private Set<String> acroFormFieldsNameSet = new HashSet<String>();

    RedactionState() {
    }

    Set<String> getAcroFormFieldsNameSet() {
        return this.acroFormFieldsNameSet;
    }

    Map<String, ReferencedValue> getNamedEmbeddedFilesReferenceMap() {
        return this.namedEmbeddedFilesReferenceMap;
    }

    Map<String, ReferencedValue> getJavaScriptReferenceMap() {
        return this.namedJavaScriptReferenceMap;
    }

    Map<String, ReferencedValue> getNamedDestinationReferenceMap() {
        return this.namedDestinationReferenceMap;
    }

    Set<Integer> getRedactedAnnotationsSet() {
        return this.redactedAnnotationsSet;
    }

    Map<Integer, Set<Integer>> getStructParent() {
        return this.structParentMap;
    }

    Set<String> getAcroFormButtonField() {
        return this.acroFormButtonFieldSet;
    }

    Map<Integer, ReferencedValue> getNamedAnnotationAppearanceMap() {
        return this.annotationAppearanceStream;
    }

    void addAnnotationToRedactionSet(PDFAnnotation annotation) {
        this.getRedactedAnnotationsSet().add(annotation.getCosObject().getObjNum());
    }

    void structParentReferenceUpdation(int pageNumber, int structParentValue) {
        Set<Integer> structParentSet = this.getStructParent().get(pageNumber);
        if (structParentSet == null) {
            structParentSet = new HashSet<Integer>();
            this.getStructParent().put(pageNumber, structParentSet);
        }
        structParentSet.add(structParentValue);
    }

    ReferencedValue getReferencedValue(Object key, VariableType type) {
        ReferencedValue value = null;
        switch (type) {
            case DESTS: {
                value = this.getNamedDestinationReferenceMap().get(key);
                break;
            }
            case EMBEDDEDFILES: {
                value = this.getNamedEmbeddedFilesReferenceMap().get(key);
                break;
            }
            case JS: {
                value = this.getJavaScriptReferenceMap().get(key);
                break;
            }
            case AP: {
                value = this.getNamedAnnotationAppearanceMap().get(key);
            }
        }
        return value;
    }

    void setReferenceValue(ReferencedValue value, Object key, VariableType type) {
        switch (type) {
            case DESTS: {
                if (value != null) {
                    this.getNamedDestinationReferenceMap().put((String)key, value);
                    break;
                }
                this.getNamedDestinationReferenceMap().put((String)key, new ReferencedValue());
                break;
            }
            case EMBEDDEDFILES: {
                if (value != null) {
                    this.getNamedEmbeddedFilesReferenceMap().put((String)key, value);
                    break;
                }
                this.getNamedEmbeddedFilesReferenceMap().put((String)key, new ReferencedValue());
                break;
            }
            case JS: {
                if (value != null) {
                    this.getJavaScriptReferenceMap().put((String)key, value);
                    break;
                }
                this.getJavaScriptReferenceMap().put((String)key, new ReferencedValue());
                break;
            }
            case AP: {
                if (value != null) {
                    this.getNamedAnnotationAppearanceMap().put((Integer)key, value);
                    break;
                }
                this.getNamedAnnotationAppearanceMap().put((Integer)key, new ReferencedValue());
            }
        }
    }

    public static enum VariableType {
        AP,
        JS,
        DESTS,
        EMBEDDEDFILES;

    }

    public static class ReferencedValue {
        int referenceCount = 1;

        boolean isReferenced() {
            return this.referenceCount > 0;
        }

        void addReference() {
            ++this.referenceCount;
        }

        void removeReference() {
            --this.referenceCount;
        }
    }
}

