/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.portfolio;

import com.adobe.internal.io.ByteArrayByteReader;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigatorStringsTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionResourcesTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.services.portfolio.Portfolio;
import com.adobe.internal.pdftoolkit.xpdf.PDF2XMLReader;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFNavigatorContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.collection.XPDFCollectionNavigator;
import com.adobe.internal.ucf.UCFContainer;
import com.adobe.internal.ucf.UCFFile;
import com.adobe.internal.ucf.UCFInvalidDocumentException;
import com.adobe.internal.ucf.UCFInvalidParameterException;
import com.adobe.internal.ucf.UCFInvalidStateException;
import com.adobe.internal.ucf.UCFOpenOptions;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PortfolioWriter
extends Portfolio {
    static final String navigatorIndentAmount = "4";
    static final String localesFileName = "locales.xml";
    static final String stringsDirName = "strings";
    static final String stringsFileName = "strings.asfx";

    private PortfolioWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportNavigator(PDFPortableCollection portfolio, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFInvalidXMLException {
        if (portfolio == null) {
            throw new PDFInvalidParameterException("No input portfolio was provided.");
        }
        if (byteWriter == null) {
            throw new PDFInvalidParameterException("No output ByteWriter was provided.");
        }
        try {
            PDFCollectionNavigator navigator = portfolio.getNavigator();
            if (navigator != null) {
                PDFCollectionResourcesTree navRes = navigator.getResources();
                HashSet resourcesAdded = new HashSet();
                boolean iconFileAdded = false;
                boolean localesFileAdded = false;
                try (UCFContainer ucf = new UCFContainer(new UCFOpenOptions(), "application/vnd.adobe.pdf-navigator");){
                    PortfolioWriter.addSWFToUCF(navigator, navRes, ucf, resourcesAdded);
                    iconFileAdded = PortfolioWriter.addIconToUCF(navigator, navRes, ucf, resourcesAdded);
                    PortfolioWriter.addStringsToUCF(navigator, ucf);
                    localesFileAdded = PortfolioWriter.addLocaleToUCF(navigator, ucf);
                    PortfolioWriter.addOtherResourcesToUCF(navigator, navRes, ucf, resourcesAdded);
                    PortfolioWriter.addNavigatorToUCF(navigator, portfolio, iconFileAdded, localesFileAdded, ucf);
                    ucf.save(byteWriter);
                }
                return true;
            }
            return false;
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException("An error was encountered whiel trying to create the navigator UCF container.", e);
        }
        catch (UCFInvalidParameterException e) {
            throw new PDFInvalidParameterException("An error was encountered while trying to create the navigator UCF container.", e);
        }
        catch (UCFInvalidStateException e) {
            throw new PDFInvalidParameterException("An error was encountered while trying to create the navigator UCF container.", e);
        }
        catch (UCFInvalidDocumentException e) {
            throw new PDFInvalidParameterException("An error was encountered while trying to create the navigator UCF container.", e);
        }
        catch (IOException e) {
            throw new PDFIOException("An error was encountered while trying to create the navigator UCF Container.", e);
        }
    }

    private static void addSWFToUCF(PDFCollectionNavigator navigator, PDFCollectionResourcesTree navRes, UCFContainer ucf, Set resourcesAdded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, UCFInvalidStateException, UCFInvalidParameterException {
        String swfName = navigator.getSWF();
        if (navRes == null) {
            throw new PDFInvalidDocumentException("The SWF cannot be found because the navigator's resource name tree is missing.");
        }
        PDFStream swfStm = (PDFStream)navRes.getEntry(new ASString(swfName));
        if (swfStm == null) {
            throw new PDFInvalidDocumentException("The SWF stream was not found in the navigator's resource name tree.");
        }
        long swfSize = swfStm.getLength();
        ByteWriter bw = navigator.getStreamManager().getByteWriter(ByteWriterFactory.Fixed.GROWABLE, swfSize);
        swfStm.getStreamData(bw);
        UCFFile swfFile = new UCFFile(ucf, swfName);
        swfFile.setDataUncompressed((ByteReader)bw);
        ucf.addFile(swfFile);
        resourcesAdded.add(swfName);
    }

    private static boolean addIconToUCF(PDFCollectionNavigator navigator, PDFCollectionResourcesTree navRes, UCFContainer ucf, Set resourcesAdded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, UCFInvalidStateException, UCFInvalidParameterException {
        PDFStream iconStm;
        String iconName = navigator.getIcon();
        if (iconName != null && navRes != null && (iconStm = (PDFStream)navRes.getEntry(new ASString(iconName))) != null) {
            long iconSize = iconStm.getLength();
            ByteWriter bw = navigator.getStreamManager().getByteWriter(ByteWriterFactory.Fixed.GROWABLE, iconSize);
            iconStm.getStreamData(bw);
            UCFFile iconFile = new UCFFile(ucf, iconName);
            iconFile.setDataUncompressed((ByteReader)bw);
            ucf.addFile(iconFile);
            resourcesAdded.add(iconName);
            return true;
        }
        return false;
    }

    private static void addStringsToUCF(PDFCollectionNavigator navigator, UCFContainer ucf) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidXMLException, PDFConfigurationException, UCFInvalidStateException, UCFInvalidParameterException {
        PDFCollectionNavigatorStringsTree strings = navigator.getStrings();
        if (strings != null) {
            ByteArrayOutputStream stringsOutStm = new ByteArrayOutputStream();
            PortfolioWriter.serialize(new PDF2XMLStringsReader(navigator), stringsOutStm);
            ByteArrayByteReader stringsReader = new ByteArrayByteReader(stringsOutStm.toByteArray());
            Locale locale = navigator.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            UCFFile stringsXMLFile = new UCFFile(ucf, "strings/" + locale.toString() + "/" + stringsFileName);
            stringsXMLFile.setDataCompressed((ByteReader)stringsReader);
            ucf.addFile(stringsXMLFile);
        }
    }

    private static boolean addLocaleToUCF(PDFCollectionNavigator navigator, UCFContainer ucf) throws PDFConfigurationException, PDFInvalidXMLException, IOException, UCFInvalidParameterException, UCFInvalidStateException {
        if (navigator.hasLocale()) {
            ByteArrayOutputStream localesOutStm = new ByteArrayOutputStream();
            PortfolioWriter.serialize(new PDF2XMLLocaleReader(navigator), localesOutStm);
            ByteArrayByteReader localesReader = new ByteArrayByteReader(localesOutStm.toByteArray());
            UCFFile localesXMLFile = new UCFFile(ucf, localesFileName);
            localesXMLFile.setDataCompressed((ByteReader)localesReader);
            ucf.addFile(localesXMLFile);
            return true;
        }
        return false;
    }

    private static void addOtherResourcesToUCF(PDFCollectionNavigator navigator, PDFCollectionResourcesTree navRes, UCFContainer ucf, Set resourcesAdded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, UCFInvalidParameterException, UCFInvalidStateException, IOException {
        if (navRes != null) {
            Iterator iter = navRes.keyIterator();
            while (iter.hasNext()) {
                PDFStream resStm;
                ASString key = (ASString)iter.next();
                String resName = key.asString();
                if (resourcesAdded.contains(resName) || (resStm = (PDFStream)navRes.getEntry(key)) == null) continue;
                long resSize = resStm.getLength();
                boolean compressed = resStm.hasInputFilters();
                ByteWriter bw = navigator.getStreamManager().getByteWriter(ByteWriterFactory.Fixed.GROWABLE, compressed ? 2L * resSize : resSize);
                resStm.getStreamData(bw);
                UCFFile resFile = new UCFFile(ucf, resName);
                if (compressed) {
                    resFile.setDataCompressed((ByteReader)bw);
                } else {
                    resFile.setDataUncompressed((ByteReader)bw);
                }
                ucf.addFile(resFile);
            }
        }
    }

    private static void addNavigatorToUCF(PDFCollectionNavigator navigator, PDFPortableCollection portfolio, boolean iconFileAdded, boolean localesFileAdded, UCFContainer ucf) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException, PDFUnableToCompleteOperationException, UCFInvalidParameterException, UCFInvalidStateException, IOException {
        ByteArrayOutputStream navOutStm = new ByteArrayOutputStream();
        PortfolioWriter.serialize(new PDF2XMLNavigatorReader(navigator, portfolio, navigator.getSWF(), navigator.getID(), navigator.getVersion(), navigator.getLoadType().getLoadType().asString(), navigator.getAPIVersion(), iconFileAdded, localesFileAdded), navOutStm);
        ByteArrayByteReader navBuffer = new ByteArrayByteReader(navOutStm.toByteArray());
        UCFFile navXMLFile = new UCFFile(ucf, "navigator.xml");
        navXMLFile.setDataCompressed((ByteReader)navBuffer);
        ucf.addFile(navXMLFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serialize(XMLReader reader, OutputStream outStm) throws PDFConfigurationException, PDFInvalidXMLException {
        BufferedWriter writer = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", Integer.valueOf(navigatorIndentAmount));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", navigatorIndentAmount);
            try {
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            writer = new BufferedWriter(new OutputStreamWriter(outStm, "UTF-8"));
            t.transform(new SAXSource(reader, new InputSource()), new StreamResult(writer));
        }
        catch (TransformerConfigurationException e) {
            throw new PDFConfigurationException("Transformer configuration error", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new PDFConfigurationException("TransformerFactory configuration error", e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("Transformer error", e);
        }
        catch (FactoryConfigurationError e) {
            throw new PDFConfigurationException("Factory configuration error", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create the OutputStreamWriter with UTF-8 encoding", e);
        }
        finally {
            if (writer != null) {
                try {
                    try {
                        writer.flush();
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing writer", e);
                }
            }
        }
    }

    static class PDF2XMLStringsReader
    extends PDF2XMLReader {
        private static final String namespace = "http://ns.adobe.com/asf";
        private static final String schemaVersion = "1.0";
        private final PDFCollectionNavigator mNavigator;

        public PDF2XMLStringsReader(PDFCollectionNavigator navigator) {
            this.mNavigator = navigator;
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            if (this.ch == null) {
                throw new SAXException("No content handler");
            }
            try {
                this.ch.startDocument();
                AttributesImpl atts = new AttributesImpl();
                if (this.namespacePrefixes) {
                    atts.addAttribute("", "", "xmlns", "CDATA", namespace);
                    atts.addAttribute("", "", "version", "CDATA", schemaVersion);
                    if (this.mNavigator.hasLocale()) {
                        atts.addAttribute("", "locale", "locale", "CDATA", this.mNavigator.getLocale().toString());
                    }
                }
                this.ch.startElement("asf", atts);
                atts.clear();
                PDFCollectionNavigatorStringsTree strings = this.mNavigator.getStrings();
                Iterator<PDFTree.Entry> iter = strings.iterator();
                while (iter.hasNext()) {
                    PDFTree.Entry entry = iter.next();
                    ASString key = (ASString)entry.getKey();
                    atts.addAttribute("", "name", "name", "CDATA", key.asString());
                    this.ch.startElement("str", atts);
                    atts.clear();
                    PDFText value = (PDFText)entry.getValue();
                    this.ch.startElement("val");
                    this.ch.characters(value.stringValue());
                    this.ch.endElement("val");
                    this.ch.endElement("str");
                }
                this.ch.endElement("asf");
                this.ch.endDocument();
            }
            catch (PDFException e) {
                throw new SAXException("A PDFException occurred while generating the strings.asfx XML file.", e);
            }
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.ch = new XPDFContentHandler(handler, namespace, schemaVersion);
        }
    }

    static class PDF2XMLLocaleReader
    extends PDF2XMLReader {
        private static final String namespace = "http://ns.adobe.com/pdf/navigator/locales/2007";
        private final PDFCollectionNavigator mNavigator;

        public PDF2XMLLocaleReader(PDFCollectionNavigator navigator) {
            this.mNavigator = navigator;
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            if (this.ch == null) {
                throw new SAXException("No content handler");
            }
            this.ch.startDocument();
            this.ch.startRootElement("locales", this.namespacePrefixes);
            try {
                Locale locale = this.mNavigator.getLocale();
                if (locale != null) {
                    AttributesImpl atts = new AttributesImpl();
                    String localeStr = locale.toString();
                    atts.addAttribute("", "id", "id", "CDATA", localeStr);
                    atts.addAttribute("", PortfolioWriter.stringsDirName, PortfolioWriter.stringsDirName, "CDATA", "strings/" + localeStr + "/strings.asfx");
                    this.ch.startElement("locale", atts);
                    this.ch.endElement("locale");
                    atts.clear();
                }
            }
            catch (PDFException e) {
                throw new SAXException("A PDFException occurred while generating the locales XML file.", e);
            }
            this.ch.endElement("locales");
            this.ch.endDocument();
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.ch = new XPDFContentHandler(handler, namespace);
        }
    }

    static class PDF2XMLNavigatorReader
    extends PDF2XMLReader {
        private static final String namespace = "http://ns.adobe.com/pdf/navigator/2007";
        private final PDFCollectionNavigator mNavigator;
        private final PDFPortableCollection mPortfolio;
        private final String mSWF;
        private final String mID;
        private final String mVersion;
        private final String mLoadType;
        private final String mAPIVersion;
        private final boolean mIconFileAdded;
        private final boolean mLocalesFileAdded;

        public PDF2XMLNavigatorReader(PDFCollectionNavigator navigator, PDFPortableCollection portfolio, String swf, String id, String version, String loadType, String apiVersion, boolean iconFileAdded, boolean localesFileAdded) {
            this.mNavigator = navigator;
            this.mPortfolio = portfolio;
            this.mSWF = swf;
            this.mID = id;
            this.mVersion = version;
            this.mLoadType = loadType;
            this.mAPIVersion = apiVersion;
            this.mIconFileAdded = iconFileAdded;
            this.mLocalesFileAdded = localesFileAdded;
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            if (this.ch == null) {
                throw new SAXException("No content handler");
            }
            this.ch.startDocument();
            this.ch.startRootElement("navigator", this.namespacePrefixes);
            try {
                new XPDFCollectionNavigator(this.mNavigator).toXPDF(this.ch, "navigator");
            }
            catch (PDFException e) {
                throw new SAXException("A PDFException occurred while generating the navigator XML.", e);
            }
            this.ch.endElement("navigator");
            this.ch.endDocument();
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.ch = new XPDFNavigatorContentHandler(handler, namespace, this.mSWF, this.mID, this.mVersion, this.mLoadType, this.mAPIVersion, this.mIconFileAdded, this.mLocalesFileAdded, PortfolioWriter.localesFileName, this.mPortfolio);
        }
    }
}

