/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.error;

import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractXMPErrorCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PDFA2XMPErrorCollector {
    private Map<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>> errorMap = new HashMap<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>>();
    private PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> errorSet = new PDFA2ErrorSet();

    public void addErrorCode(String uri, PDFA2AbstractXMPErrorCode ec) {
        PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> set = this.errorMap.get(uri);
        if (set == null) {
            set = new PDFA2ErrorSet();
        }
        set.addErrorCode(ec);
        this.errorMap.put(uri, set);
    }

    public void removeErrorCode(String uri) {
        this.errorMap.remove(uri);
    }

    public void addErrorCodeConditional(String uri, PDFA2AbstractXMPErrorCode ec, PDFA2AbstractXMPErrorCode ecNotPresent) {
        if (!this.hasErrorCode(uri, ecNotPresent)) {
            this.addErrorCode(uri, ec);
        }
    }

    public void addErrorCode(PDFA2AbstractXMPErrorCode ec) {
        this.errorSet.addErrorCode(ec);
    }

    private boolean hasErrorCode(String uri, PDFA2AbstractXMPErrorCode ec) {
        PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> set = this.errorMap.get(uri);
        if (set == null) {
            return false;
        }
        return set.errorCodeSet(ec.getClass());
    }

    public boolean hasErrors() {
        return !this.errorMap.isEmpty() || this.errorSet.hasErrors();
    }

    public PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> getErrorCodes() {
        PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> errorSet = new PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>();
        Set<Map.Entry<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>>> set = this.errorMap.entrySet();
        for (Map.Entry<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>> entry : set) {
            errorSet.mergeErrorSet(entry.getValue());
        }
        errorSet.mergeErrorSet(this.errorSet);
        return errorSet;
    }

    public Map<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>> getErrorMap() {
        return this.errorMap;
    }

    public PDFA2ErrorSet<PDFA2AbstractXMPErrorCode> getErrorSet() {
        return this.errorSet;
    }

    public void mergeErrorCodes(PDFA2XMPErrorCollector xmpec) {
        this.errorMap.putAll(xmpec.errorMap);
        this.errorSet.mergeErrorSet(xmpec.errorSet);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        Set<Map.Entry<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>>> set = this.errorMap.entrySet();
        for (Map.Entry<String, PDFA2ErrorSet<PDFA2AbstractXMPErrorCode>> entry : set) {
            str.append(entry.getKey()).append("  :  ").append(entry.getValue()).append("\n");
        }
        str.append(this.errorSet.toString()).append("\n");
        return str.toString();
    }
}

