/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPAgentName;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPBoolean;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPCFAPattern;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPClosedChoice;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPDate;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPDeviceSettings;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPDimensions;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPFlash;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPGPSCoordinate;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPInteger;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPJob;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPLangAlt;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPLocale;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPMIMEType;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPOECFSFR;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPOpenChoice;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPProperName;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPRational;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPReal;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPRenditionClass;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPResourceEvent;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPResourceRef;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSeqInteger;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPText;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPThumbnail;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPURI;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPURL;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPValueType;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPVersion;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPXPath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMPBasicTypeValidator {
    private static final HashMap<String, XMPValueType> BASIC_XMP_PROPERTY_MAP;
    private static final String VALUE = "value";
    private static final String RDF = "rdf";
    private static final String OPEN_CHOICE = "open choice of ";
    private static final String CLOSED_CHOICE = "closed choice of ";
    private static final String SEQ = "seq ";
    private static final String ALT = "alt ";
    private static final String BAG = "bag ";

    public static String getBaseValueType(String valueType) {
        if (valueType == null) {
            return null;
        }
        String basicTypeLowerCase = valueType.toLowerCase();
        if (basicTypeLowerCase.startsWith(OPEN_CHOICE)) {
            valueType = valueType.substring(OPEN_CHOICE.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(CLOSED_CHOICE)) {
            valueType = valueType.substring(CLOSED_CHOICE.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(BAG)) {
            valueType = valueType.substring(BAG.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(ALT)) {
            valueType = valueType.substring(ALT.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(SEQ)) {
            valueType = valueType.substring(SEQ.length(), valueType.length());
        }
        return valueType;
    }

    public static boolean isValueTypeBasicXMPProperty(String valueType) {
        return BASIC_XMP_PROPERTY_MAP.containsKey(XMPBasicTypeValidator.getBaseValueType(valueType));
    }

    static boolean isPropertyUsageValid(String basicDataName, MetadataUsageTreeNode metadataTree, Map<String, PDFAXMPSchema> referenceSchemas, boolean closedChoice, PDFAXMPSchema.PDFAXMPProperty prop, PDFAXMPSchema xmpSchema) {
        try {
            XMPValueType valueType = null;
            String basicTypeLowerCase = basicDataName.toLowerCase();
            if (basicTypeLowerCase.startsWith(CLOSED_CHOICE)) {
                basicDataName = basicDataName.substring(CLOSED_CHOICE.length(), basicDataName.length());
                closedChoice = true;
            }
            if (basicDataName == null || basicDataName.length() == 0) {
                basicDataName = "Text";
            }
            basicDataName = XMPBasicTypeValidator.getBaseValueType(basicDataName);
            if (metadataTree.isNodeArray()) {
                for (MetadataUsageTreeNode node : metadataTree.getNodes()) {
                    if (XMPBasicTypeValidator.isPropertyUsageValid(basicDataName, node, referenceSchemas, closedChoice, prop, xmpSchema)) continue;
                    return false;
                }
            } else {
                valueType = BASIC_XMP_PROPERTY_MAP.get(basicDataName);
                if (valueType == null) {
                    return XMPBasicTypeValidator.validateExtensionSchemaProperty(metadataTree, referenceSchemas, prop, xmpSchema);
                }
                List<MetadataUsageTreeNode> nodes = metadataTree.getNodes();
                if (nodes == null || nodes.size() > 2) {
                    return valueType.isValid(metadataTree, closedChoice);
                }
                boolean rdfValueFound = false;
                boolean isValueTypeReal = false;
                if (nodes.size() <= 2) {
                    for (MetadataUsageTreeNode node : nodes) {
                        if (!node.getName().equals(VALUE) || !node.getPrefix().equals(RDF)) continue;
                        rdfValueFound = true;
                        if (!"Real".equals(basicDataName)) continue;
                        isValueTypeReal = true;
                    }
                }
                if (!rdfValueFound) {
                    return valueType.isValid(metadataTree);
                }
                for (MetadataUsageTreeNode node : nodes) {
                    if (node.getName().equals(VALUE) && node.getPrefix().equals(RDF)) {
                        if (XMPBasicTypeValidator.isPropertyUsageValid(basicDataName, node, referenceSchemas, closedChoice, prop, xmpSchema)) continue;
                        return false;
                    }
                    if (isValueTypeReal && node.getName().equals("binRep") && node.getPrefix().equals("vQual")) {
                        return XMPBasicTypeValidator.isPropertyUsageValid("Text", node, referenceSchemas, closedChoice, prop, xmpSchema);
                    }
                    String type = prop.getType();
                    if (XMPBasicTypeValidator.isPropertyUsageValid(type, node, referenceSchemas, closedChoice, prop, xmpSchema)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean validateExtensionSchemaProperty(MetadataUsageTreeNode propertyTree, Map<String, PDFAXMPSchema> referenceSchemas, PDFAXMPSchema.PDFAXMPProperty prop, PDFAXMPSchema xmpSchema) {
        String refererenceType = prop.getType();
        PDFAXMPSchema.PDFAXMPType pdfaXMPType = xmpSchema.getType(XMPBasicTypeValidator.getBaseValueType(refererenceType));
        if (pdfaXMPType == null) {
            return false;
        }
        if (propertyTree.getNodes() == null) {
            return false;
        }
        for (MetadataUsageTreeNode node : propertyTree.getNodes()) {
            PDFAXMPSchema.PDFAXMPField field = pdfaXMPType.getFields().get(node.getName());
            if (field != null) {
                if (XMPBasicTypeValidator.isPropertyUsageValid(field.getvalueType(), node, referenceSchemas, false, prop, xmpSchema)) continue;
                return false;
            }
            Set<PDFAXMPSchema.PDFAXMPType> types = xmpSchema.getTypeByURI(node.getNameSpaceURI());
            Iterator<PDFAXMPSchema.PDFAXMPType> iter = types.iterator();
            boolean validated = false;
            while (iter.hasNext()) {
                PDFAXMPSchema.PDFAXMPType t = iter.next();
                PDFAXMPSchema.PDFAXMPField f = t.getFields().get(node.getName());
                if (f == null) continue;
                if (!XMPBasicTypeValidator.isPropertyUsageValid(f.getvalueType(), node, referenceSchemas, false, prop, xmpSchema)) {
                    return false;
                }
                validated = true;
                break;
            }
            if (validated) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, XMPValueType> temp = new HashMap<String, XMPValueType>();
        temp.put("Boolean", XMPBoolean.getInstance());
        temp.put("Date", XMPDate.getInstance());
        temp.put("open Choice", XMPOpenChoice.getInstance());
        temp.put("closed Choice", new XMPClosedChoice(new String[]{""}));
        temp.put("Closed Choice", new XMPClosedChoice(new String[]{""}));
        temp.put("Dimensions", XMPDimensions.getInstance());
        temp.put("Integer", XMPInteger.getInstance());
        temp.put("seq Integer", XMPSeqInteger.getInstance());
        temp.put("Lang Alt", XMPLangAlt.getInstance());
        temp.put("Locale", XMPLocale.getInstance());
        temp.put("MIMEType", XMPMIMEType.getInstance());
        temp.put("ProperName", XMPProperName.getInstance());
        temp.put("Real", XMPReal.getInstance());
        temp.put("Text", XMPText.getInstance());
        temp.put("Thumbnail", XMPThumbnail.getInstance());
        temp.put("URI", XMPURI.getInstance());
        temp.put("URL", XMPURL.getInstance());
        temp.put("XPath", XMPXPath.getInstance());
        temp.put("AgentName", XMPAgentName.getInstance());
        temp.put("RenditionClass", XMPRenditionClass.getInstance());
        temp.put("ResourceEvent", XMPResourceEvent.getInstance());
        temp.put("ResourceRef", XMPResourceRef.getInstance());
        temp.put("Version", XMPVersion.getInstance());
        temp.put("Job", XMPJob.getInstance());
        temp.put("Flash", XMPFlash.getInstance());
        temp.put("CFAPattern", XMPCFAPattern.getInstance());
        temp.put("DeviceSettings", XMPDeviceSettings.getInstance());
        temp.put("GPSCoordinate", XMPGPSCoordinate.getInstance());
        temp.put("OECF/SFR", XMPOECFSFR.getInstance());
        temp.put("Rational", XMPRational.getInstance());
        BASIC_XMP_PROPERTY_MAP = temp;
    }
}

