/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfParser;

import com.adobe.internal.pdftoolkit.color.ApplyFunctionInterface;
import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.LineCap;
import com.adobe.internal.pdftoolkit.graphicsDOM.LineJoint;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.AxialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.CoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.FunctionBasedShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.RadialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceLab;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFColorSpaceWithTintTransform;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingAxial;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingCoons;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingRadial;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ParserUtils {
    private static double smallCurveThreshold = 2.0;
    private static final int MAXTABLESIZE = 256;
    private static final int MINTABLESIZE = 64;

    static LineCap mapLineCap(PDFLineCap pdfLineCap) {
        switch (pdfLineCap) {
            case BUTT_CAP: {
                return LineCap.NONE;
            }
            case ROUND_CAP: {
                return LineCap.ROUND;
            }
            case PROJECTING_SQUARE_CAP: {
                return LineCap.SQUARE;
            }
        }
        return LineCap.NONE;
    }

    static LineJoint mapLineJoints(PDFLineJoin pdfLineJoin) {
        switch (pdfLineJoin) {
            case MITER_JOIN: {
                return LineJoint.MITER;
            }
            case ROUND_JOIN: {
                return LineJoint.ROUND;
            }
            case BEVEL_JOIN: {
                return LineJoint.BEVEL;
            }
        }
        return LineJoint.ROUND;
    }

    static GraphicsState.RenderingIntent mapRenderingIntent(PDFRenderingIntent pdfRenderingIntent) {
        if (pdfRenderingIntent == PDFRenderingIntent.ABSOLUTE_COLORIMETRIC) {
            return GraphicsState.RenderingIntent.ABSOLUTE_COLORIMETRIC;
        }
        if (pdfRenderingIntent == PDFRenderingIntent.PERCEPTUAL) {
            return GraphicsState.RenderingIntent.PERCEPTUAL;
        }
        if (pdfRenderingIntent == PDFRenderingIntent.RELATIVE_COLORIMETRIC) {
            return GraphicsState.RenderingIntent.RELATIVE_COLORIMETRIC;
        }
        if (pdfRenderingIntent == PDFRenderingIntent.SATURATION) {
            return GraphicsState.RenderingIntent.SATURATION;
        }
        return GraphicsState.RenderingIntent.RELATIVE_COLORIMETRIC;
    }

    public static GeneralPath optimizePath(GeneralPath originalPath) {
        GeneralPath modifiedPath = new GeneralPath();
        double[] coords = new double[6];
        Point point = new Point();
        MaxCoordinates maxCoordinates = new MaxCoordinates();
        PathIterator pi = originalPath.getPathIterator(null);
        while (!pi.isDone()) {
            Point2D currentPoint = modifiedPath.getCurrentPoint();
            if (currentPoint != null) {
                point.x = (int)currentPoint.getX();
                point.y = (int)currentPoint.getY();
            }
            switch (pi.currentSegment(coords)) {
                case 0: {
                    modifiedPath.moveTo(coords[0], coords[1]);
                    maxCoordinates.xMax = coords[0];
                    maxCoordinates.yMax = coords[1];
                    break;
                }
                case 1: {
                    modifiedPath.lineTo(coords[0], coords[1]);
                    break;
                }
                case 3: {
                    if (ParserUtils.isSmallCurve(coords, maxCoordinates)) {
                        if (ParserUtils.isSignificantlySmallCurve(point, maxCoordinates.xMax, maxCoordinates.yMax)) break;
                        modifiedPath.lineTo(coords[4], coords[5]);
                        break;
                    }
                    modifiedPath.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 2: {
                    if (ParserUtils.isSmallCurve(coords, maxCoordinates)) {
                        if (ParserUtils.isSignificantlySmallCurve(point, maxCoordinates.xMax, maxCoordinates.yMax)) break;
                        modifiedPath.lineTo(coords[2], coords[3]);
                        break;
                    }
                    modifiedPath.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 4: {
                    modifiedPath.closePath();
                }
            }
            pi.next();
        }
        return modifiedPath;
    }

    private static boolean isSignificantlySmallCurve(Point point, double xMax, double yMax) {
        return Math.abs((int)xMax) - point.x < 1 && Math.abs((int)yMax - point.y) < 1;
    }

    private static boolean isSmallCurve(double[] coords, MaxCoordinates max) {
        double xMin = coords[0];
        double yMin = coords[1];
        max.xMax = coords[0];
        max.yMax = coords[1];
        for (int i = 2; i < coords.length; i += 2) {
            xMin = xMin < coords[i] ? xMin : coords[i];
            max.xMax = max.xMax > coords[i] ? max.xMax : coords[i];
            yMin = yMin < coords[i + 1] ? yMin : coords[i + 1];
            max.yMax = max.yMax > coords[i + 1] ? max.yMax : coords[i + 1];
        }
        return max.xMax - xMin < smallCurveThreshold && max.yMax - yMin < smallCurveThreshold;
    }

    public static ColorSpaceCache createPDFColorSpaceForInlineImage(ASDictionary imageDict, PDFResources resources, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, boolean isImageMask, double[] decode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        ASArray csArray;
        if (isImageMask) {
            return loadedColorSpaces != null ? (ColorSpaceCache)loadedColorSpaces.get(GraphicsUtils.DeviceGray) : ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceGray.newInstance(resources.getPDFDocument()), null, null, decode);
        }
        ASObject cs = imageDict.get(ASName.k_ColorSpace);
        if (cs == null) {
            cs = imageDict.get(ASName.k_CS);
        }
        if (cs instanceof ASName) {
            ASName csName = (ASName)cs;
            ColorSpaceCache deviceCS = ParserUtils.resolveInlineImageDeviceCS(csName, loadedColorSpaces, resources.getPDFDocument(), decode);
            return deviceCS != null ? deviceCS : ColorSpaceCacheImpl.newInstance(resources.getColorSpace(csName), loadedColorSpaces, csName, decode);
        }
        if (cs instanceof ASArray && ((csArray = (ASArray)cs).get(0) == ASName.k_Indexed || csArray.get(0) == ASName.k_I) && csArray.size() == 4) {
            PDFColorSpaceIndexed csIndexed = PDFColorSpaceIndexed.newInstance(resources.getPDFDocument());
            csIndexed.setBaseColorSpace((PDFColorSpace)ParserUtils.resolveInlineImageDeviceCS(csArray.getName(1), loadedColorSpaces, resources.getPDFDocument(), decode).getUnderlyingColorspace());
            csIndexed.setHighValue(csArray.getNumber(2).intValue());
            csIndexed.setLookupData(csArray.getString(3).getBytes());
            return ColorSpaceCacheImpl.newInstance(csIndexed, loadedColorSpaces, null, decode);
        }
        return null;
    }

    private static ColorSpaceCache resolveInlineImageDeviceCS(ASName csName, Map<String, ColorSpaceCacheImpl> deviceColorSpaces, PDFDocument pdfDoc, double[] decode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (deviceColorSpaces != null && deviceColorSpaces.containsKey(csName.asString())) {
            return deviceColorSpaces.get(csName.asString());
        }
        if (csName == ASName.k_RGB || csName == ASName.k_DeviceRGB) {
            return deviceColorSpaces != null ? (ColorSpaceCache)deviceColorSpaces.get(GraphicsUtils.DeviceRGB) : ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceRGB.newInstance(pdfDoc), null, null, decode);
        }
        if (csName == ASName.k_G || csName == ASName.k_DeviceGray) {
            return deviceColorSpaces != null ? (ColorSpaceCache)deviceColorSpaces.get(GraphicsUtils.DeviceGray) : ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceGray.newInstance(pdfDoc), null, null, decode);
        }
        if (csName == ASName.k_CMYK || csName == ASName.k_DeviceCMYK) {
            return deviceColorSpaces != null ? (ColorSpaceCache)deviceColorSpaces.get(GraphicsUtils.DeviceCMYK) : ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceCMYK.newInstance(pdfDoc), null, null, decode);
        }
        return null;
    }

    static GeneralPath getClipPathForTilingPatternCell(ASMatrix patternMatrix, PDFRectangle bBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        GeneralPath clipPath = new GeneralPath();
        bBox = bBox.normalized(bBox.getPDFDocument());
        ASCoordinate coord = new ASCoordinate(bBox.left(), bBox.bottom()).transform(patternMatrix);
        clipPath.moveTo((float)coord.x(), (float)coord.y());
        coord = new ASCoordinate(bBox.left(), bBox.top()).transform(patternMatrix);
        clipPath.lineTo((float)coord.x(), (float)coord.y());
        coord = new ASCoordinate(bBox.right(), bBox.top()).transform(patternMatrix);
        clipPath.lineTo((float)coord.x(), (float)coord.y());
        coord = new ASCoordinate(bBox.right(), bBox.bottom()).transform(patternMatrix);
        clipPath.lineTo((float)coord.x(), (float)coord.y());
        clipPath.closePath();
        return clipPath;
    }

    static void preProcessAxialShading(PDFShadingAxial axialShading, AxialShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj, PDFRectangle rectangle, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, double[] matrix, ASMatrix ctm, boolean turnOffColorComputation) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        boolean isExtendBefore = false;
        boolean isExtendAfter = false;
        double[][] colorValues = null;
        CosArray cords = axialShading.getCoords();
        CosArray domain = axialShading.getDomain();
        CosArray extend = axialShading.getExtend();
        if (extend != null) {
            isExtendBefore = extend.getBoolean(0);
            isExtendAfter = extend.getBoolean(1);
        }
        ArrayList<Boolean> extendvalue = new ArrayList<Boolean>(2);
        extendvalue.add(isExtendBefore);
        extendvalue.add(isExtendAfter);
        shadingObj.setExtend(extendvalue);
        AffineTransform transformedCTM = new AffineTransform(ctm.getValues());
        try {
            transformedCTM.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("Not able to calculate the ctm inverse");
        }
        shadingObj.setCoordinates(cords.getArrayDouble());
        shadingObj.setMatrix(matrix);
        shadingObj.setTransform(transformedCTM);
        if (!turnOffColorComputation) {
            ColorModel colormodel;
            PDFColorSpace pdfcolorspace = axialShading.getColorSpace();
            ColorSpaceCacheImpl cachedCS = ColorSpaceCacheImpl.newInstance(pdfcolorspace, loadedColorSpaces, null);
            int noc = cachedCS.getNumberOfComponents();
            if (cachedCS.getUnderlyingColorspace() instanceof PDFColorSpaceWithTintTransform || cachedCS.getUnderlyingColorspace() instanceof PDFColorSpacePattern || cachedCS.getUnderlyingColorspace() instanceof PDFColorSpaceCalRGB || cachedCS.getUnderlyingColorspace() instanceof PDFColorSpaceCalGray || cachedCS.getUnderlyingColorspace() instanceof PDFColorSpaceLab) {
                ColorSpace cs1 = ColorSpace.getInstance(1000);
                colormodel = new ComponentColorModel(cs1, true, false, 3, 0);
            } else {
                colormodel = cachedCS.getUnderlyingColorspace().createColorModel(8, 0);
            }
            shadingObj.setColormodel(colormodel);
            PDFFunctionsArray functionsArray = axialShading.getFunction();
            if (functionsArray != null && !functionsArray.isEmpty()) {
                colorValues = ParserUtils.applyFunction(shadingObj, functionsArray, domain != null ? domain.getArrayDouble() : null, noc, isExtendBefore, isExtendAfter, ctm, rectangle);
            }
            Color[] colors = null;
            if (colorValues != null && colorValues.length > 0) {
                colors = new Color[colorValues.length];
                colors[0] = cachedCS.getUnderlyingColorspace().getName() == ASName.k_DeviceCMYK ? ColorManager.convertDeviceCMYKtoRGB(colorValues[0]) : ParserUtils.getColor(cachedCS.toRGB(colorValues[0]));
            }
            for (int j = 1; j < colorValues.length; ++j) {
                int k = 0;
                for (k = 0; k < noc && (float)colorValues[j - 1][k] == (float)colorValues[j][k]; ++k) {
                }
                if (k < noc) {
                    if (cachedCS.getUnderlyingColorspace().getName() == ASName.k_DeviceCMYK) {
                        colors[j] = ColorManager.convertDeviceCMYKtoRGB(colorValues[j]);
                        continue;
                    }
                    colors[j] = ParserUtils.getColor(cachedCS.toRGB(colorValues[j]));
                    continue;
                }
                if (k != noc) continue;
                colors[j] = new Color(colors[j - 1].getRed(), colors[j - 1].getGreen(), colors[j - 1].getBlue());
            }
            shadingObj.setColorValues(colors);
        }
    }

    private static Color getColor(double[] pixelColor) {
        float red = (float)(pixelColor[0] > 1.0 ? 1.0 : (pixelColor[0] < 0.0 ? 0.0 : pixelColor[0]));
        float green = (float)(pixelColor[1] > 1.0 ? 1.0 : (pixelColor[1] < 0.0 ? 0.0 : pixelColor[1]));
        float blue = (float)(pixelColor[2] > 1.0 ? 1.0 : (pixelColor[2] < 0.0 ? 0.0 : pixelColor[2]));
        return new Color(red, green, blue);
    }

    private static double[][] applyFunction(AxialShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj, PDFFunctionsArray functionsArray, double[] domain, int noc, boolean isExtendBefore, boolean isExtendAfter, ASMatrix ctm, PDFRectangle rectangle) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int tableSize;
        double[][] colors = null;
        boolean isSingleFunction = false;
        int size = functionsArray.size();
        PDFFunction function = null;
        if (size == 1) {
            function = (PDFFunction)functionsArray.get(0);
            isSingleFunction = true;
        }
        double domainDiff = 0.0;
        if (null == domain) {
            domain = new double[]{0.0, 1.0};
        }
        domainDiff = domain[1] - domain[0];
        if (isSingleFunction && function.hasFunctionType() && function.getFunctionType() == 3) {
            double totInterval;
            double[] dArray;
            double minInterval = 0.0;
            if (((PDFFunctionType3)function).hasBounds()) {
                dArray = ((PDFFunctionType3)function).getBounds().getArrayDouble();
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = domain[0];
                dArray = dArray2;
                dArray2[1] = domain[1];
            }
            double[] stitchBounds = dArray;
            minInterval = totInterval = Math.abs(domain[1] - domain[0]);
            for (int i = 0; i < stitchBounds.length; ++i) {
                double intervalStart = i == 0 ? domain[0] : stitchBounds[i - 1];
                double intervalEnd = i == stitchBounds.length - 1 ? domain[1] : stitchBounds[i];
                double interval = intervalStart - intervalEnd;
                if (i != 0 && !(interval < minInterval)) continue;
                minInterval = interval;
            }
            tableSize = minInterval * 16.0 < totInterval ? 256 : (totInterval == 0.0 ? 64 : (int)Math.floor(256.0 * totInterval / minInterval));
        } else {
            tableSize = 64;
        }
        if (tableSize > 256) {
            tableSize = 256;
        }
        colors = new double[tableSize][noc];
        double stepSize = domainDiff / (double)(tableSize - 1);
        if (isSingleFunction && function.hasFunctionType() && function.getFunctionType() == 3) {
            ParserUtils.processStitchFunction((PDFFunctionType3)function, stepSize, tableSize, colors);
        } else {
            double input = 0.0;
            for (int i = 0; i < tableSize; ++i) {
                input = Math.min(Math.max(input, domain[0]), domain[1]);
                colors[i] = isSingleFunction ? function.apply(new double[]{input}) : ParserUtils.getFunctionColors(functionsArray, new double[]{input}, noc);
                input += stepSize;
            }
        }
        return colors;
    }

    private static void processStitchFunction(PDFFunctionType3 function, double stepSize, int tableSize, double[][] colors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int intervalLength;
        double[] dArray;
        double[] dArray2;
        int boundsLength = function.getFunctions().size();
        int firstInterval = 0;
        int lastInterval = boundsLength - 1;
        boolean positiveStep = false;
        int colorIndex = 0;
        if (function.hasDomain()) {
            dArray2 = function.getFunctionDomain().getCosArray().getArrayDouble();
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray2 = dArray3;
            dArray3[1] = 1.0;
        }
        double[] domain = dArray2;
        if (function.hasBounds()) {
            dArray = function.getBounds().getArrayDouble();
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = domain[0];
            dArray = dArray4;
            dArray4[1] = domain[1];
        }
        double[] bounds = dArray;
        double[] encode = function.getEncode().getArrayDouble();
        Iterator itr = function.getFunctions().iterator();
        ApplyFunctionInterface[] interfaceArray = new ApplyFunctionInterface[function.getFunctions().size()];
        int index = 0;
        while (itr.hasNext()) {
            interfaceArray[index++] = (ApplyFunctionInterface)itr.next();
        }
        ApplyFunctionInterface functioncal = null;
        if (stepSize > 0.0) {
            positiveStep = true;
        }
        if (!positiveStep) {
            firstInterval = boundsLength - 1;
            lastInterval = 0;
        }
        double offset = domain[0];
        for (int count = tableSize; count > 0; count -= intervalLength) {
            double[] dArray5;
            int interval;
            if (count == tableSize) {
                interval = firstInterval;
            } else if (count == 1) {
                interval = lastInterval;
            } else {
                for (interval = 0; interval < boundsLength - 1 && offset >= bounds[interval]; ++interval) {
                }
            }
            double intervalEnd = interval < boundsLength - 1 ? bounds[interval] : domain[1];
            double intervalStart = interval == 0 ? domain[0] : bounds[interval - 1];
            intervalLength = positiveStep ? (int)(1.0 + Math.floor((intervalEnd - offset) / stepSize)) : (int)(1.0 + Math.floor((intervalStart - offset) / stepSize));
            if (intervalLength <= 0) {
                intervalLength = 1;
            }
            if (intervalLength >= count) {
                intervalLength = interval != lastInterval ? count - 1 : count;
            }
            double subIntervalSize = encode[2 * interval + 1] - encode[2 * interval];
            double intervalSize = intervalEnd - intervalStart;
            double encodedOffset = offset <= intervalStart ? encode[2 * interval] : (offset >= intervalEnd ? encode[2 * interval + 1] : encode[2 * interval] + (offset - intervalStart) / intervalSize * subIntervalSize);
            double subStepSize = 0.0;
            if (intervalLength > 1) {
                subStepSize = stepSize * subIntervalSize / intervalSize;
            }
            functioncal = interfaceArray[interval];
            double input = encodedOffset;
            if (((PDFFunction)function.getFunctions().get(interval)).hasDomain()) {
                dArray5 = ((PDFFunction)function.getFunctions().get(interval)).getFunctionDomain().getCosArray().getArrayDouble();
            } else {
                double[] dArray6 = new double[2];
                dArray6[0] = 0.0;
                dArray5 = dArray6;
                dArray6[1] = 1.0;
            }
            double[] funcaldomain = dArray5;
            for (int index1 = 0; index1 < intervalLength; ++index1) {
                input = Math.min(Math.max(input, funcaldomain[0]), funcaldomain[1]);
                colors[colorIndex] = functioncal.apply(new double[]{input});
                input += subStepSize;
                ++colorIndex;
            }
            offset += stepSize * (double)intervalLength;
        }
    }

    private static double[] getFunctionColors(PDFFunctionsArray functionsArray, double[] inputData, int size) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int i = 0;
        double[] outputValues = new double[size];
        for (PDFFunction function : functionsArray) {
            outputValues[i++] = function.apply(inputData)[0];
        }
        return outputValues;
    }

    static void preProcessFunctionBasedShading(PDFShadingFunction shadingFunction, FunctionBasedShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray domain = shadingFunction.getDomain();
        ASMatrix matrix = shadingFunction.getMatrix();
        PDFFunctionsArray functions = shadingFunction.getFunction();
        int xMin = 0;
        int xMax = 1;
        int yMin = 0;
        int yMax = 1;
        if (domain != null) {
            xMin = domain.getInt(0);
            xMax = domain.getInt(1);
            yMin = domain.getInt(2);
            yMax = domain.getInt(3);
        }
        int width = xMax - xMin + 1;
        int height = yMax - yMin + 1;
        Color[] colors = new Color[width * height];
        double[] input = new double[2];
        int k = 0;
        int l = 0;
        int i = yMin;
        while (i <= yMax) {
            k = 0;
            int j = xMin;
            while (j <= xMax) {
                input[0] = j;
                input[1] = i;
                if (functions.size() == 1) {
                    double[] output = ((PDFFunction)functions.get(0)).apply(input);
                    colors[l * width + k] = new Color((float)output[0], (float)output[1], (float)output[2]);
                } else {
                    colors[l * width + k] = new Color((float)((PDFFunction)functions.get(0)).apply(input)[0], (float)((PDFFunction)functions.get(1)).apply(input)[0], (float)((PDFFunction)functions.get(2)).apply(input)[0]);
                }
                ++j;
                ++k;
            }
            ++i;
            ++l;
        }
        shadingObj.setMatrix(matrix.getValues());
        shadingObj.setColorValues(colors);
        shadingObj.setDomain(domain.getArrayDouble());
    }

    static void preProcessRadialShading(PDFShadingRadial shadingRadial, RadialShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj, double[] matrix, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, Area area, boolean turnOffColourComputation) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray extend = shadingRadial.getExtend();
        shadingObj.setCurrentShadingPath(new GeneralPath(area));
        boolean isExtendBefore = false;
        boolean isExtendAfter = false;
        if (extend != null) {
            isExtendBefore = extend.getBoolean(0);
            isExtendAfter = extend.getBoolean(1);
        }
        shadingObj.setIsExtendBefore(isExtendBefore);
        shadingObj.setIsExtendAfter(isExtendAfter);
        CosArray coords = shadingRadial.getCoords();
        CosArray domain = shadingRadial.getDomain();
        shadingObj.setCoordinates(coords.getArrayDouble());
        double t0 = 0.0;
        double t1 = 1.0;
        if (domain != null) {
            t0 = domain.getDouble(0);
            t1 = domain.getDouble(1);
        }
        shadingObj.setDomain(new double[]{t0, t1});
        PDFColorSpace pdfcolorspace = shadingRadial.getColorSpace();
        PDFFunctionsArray functions = shadingRadial.getFunction();
        int pathHeight = (int)area.getBounds2D().getHeight();
        ParserUtils.calculateRadialShading(coords, t0, t1, extend, functions, pdfcolorspace, shadingObj, matrix, loadedColorSpaces, pathHeight, domain, turnOffColourComputation);
    }

    private static void calculateRadialShading(CosArray coords, double t0, double t1, CosArray extend, PDFFunctionsArray functions, PDFColorSpace pdfcolorspace, RadialShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj, double[] matrix, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, int pathHeight, CosArray domain, boolean turnOffColorComputation) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        double x0 = coords.getDouble(0);
        double y0 = coords.getDouble(1);
        double r0 = coords.getDouble(2);
        double x1 = coords.getDouble(3);
        double y1 = coords.getDouble(4);
        double r1 = coords.getDouble(5);
        double distance = Math.abs(Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0)));
        boolean isSingleCircle = false;
        shadingObj.setMatrix(matrix);
        ColorSpaceCacheImpl cachedCS = ColorSpaceCacheImpl.newInstance(pdfcolorspace, loadedColorSpaces, null);
        double[] background = shadingObj.getBackground();
        if (background != null) {
            background = cachedCS.toRGB(background);
            shadingObj.setBackground(background);
        }
        if (distance != 0.0) {
            shadingObj.setIsCircle(false);
        } else {
            distance = r1 > r0 ? Math.abs(r1 - r0) : Math.abs(r0 - r1);
            shadingObj.setIsCircle(true);
            if (distance == 0.0) {
                isSingleCircle = true;
                shadingObj.setIsSingleCircle(true);
                distance = 1.0;
            }
        }
        int size = GraphicsUtils.rint(distance) + 1;
        if (shadingObj.getIsExtendBefore() || shadingObj.getIsExtendAfter()) {
            size = pathHeight;
            isSingleCircle = false;
        }
        if (!turnOffColorComputation) {
            Color[] colors = new Color[size];
            float[] fractions = new float[size];
            double[][] circleInfo = new double[size][3];
            if (functions != null && !functions.isEmpty()) {
                PDFFunction function = null;
                if (functions.size() == 1) {
                    function = (PDFFunction)functions.get(0);
                }
                int j = 0;
                double[] inputData = new double[1];
                if (isSingleCircle) {
                    inputData[0] = t1;
                    circleInfo[0][0] = x1;
                    circleInfo[0][1] = y1;
                    circleInfo[0][2] = r1;
                    double[] pixelColorComponents = function.apply(inputData);
                    colors[0] = ParserUtils.getColor(cachedCS.toRGB(pixelColorComponents));
                } else {
                    double difference = 1.0 / (double)size;
                    for (double i = 0.0; i < 1.0 && j < size - 1; i += difference) {
                        inputData[0] = t0 + i * (t1 - t0);
                        circleInfo[j][0] = x0 + i * (x1 - x0);
                        circleInfo[j][1] = y0 + i * (y1 - y0);
                        circleInfo[j][2] = r0 + i * (r1 - r0);
                        double[] pixelColorComponents = function.apply(inputData);
                        pixelColorComponents[0] = Math.abs(pixelColorComponents[0]);
                        colors[j++] = ParserUtils.getColor(cachedCS.toRGB(pixelColorComponents));
                        fractions[j] = (float)((double)fractions[j - 1] + difference);
                    }
                }
            }
            shadingObj.setFractions(fractions);
            shadingObj.setColors(colors);
            shadingObj.setCircleInfo(circleInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preProcessCoonsPatchMeshesShading(PDFShadingCoons pdfShadingCoons, CoonsPatchMeshesShading<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj, double[] matrix, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, int pathHeight) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int kAGMCsMaxComponents = 32;
        int bitsPerCoordinate = pdfShadingCoons.getBitsPerCoordinate();
        int bitsPerComponent = pdfShadingCoons.getBitsPerComponent();
        int bitsPerFlag = pdfShadingCoons.getBitsPerFlag();
        CosArray decodeArray = pdfShadingCoons.getDecode();
        PDFFunctionsArray functionArray = null;
        if (pdfShadingCoons.hasFunction()) {
            functionArray = pdfShadingCoons.getFunction();
        }
        PDFColorSpace pdfColorSpace = pdfShadingCoons.getColorSpace();
        int nColors = pdfColorSpace.getNumberOfComponents();
        int coordDecodeLength = functionArray != null && functionArray.size() > 0 ? 1 : nColors;
        Point2D[] coordDecode = new Point2D.Double[2];
        Point2D[] colorDecode = new Point2D.Double[kAGMCsMaxComponents];
        if (decodeArray != null && !decodeArray.isEmpty()) {
            int j = 0;
            for (int i = 0; i < 2; ++i) {
                coordDecode[i] = new Point2D.Double();
                double x = decodeArray.getDouble(j++);
                double y = decodeArray.getDouble(j++);
                ((Point2D)coordDecode[i]).setLocation(x, y);
            }
            int size = decodeArray.size();
            int j2 = 4;
            for (int i = 0; i < coordDecodeLength && i < size / 2 - 2; ++i) {
                colorDecode[i] = new Point2D.Double();
                double x = decodeArray.getDouble(j2++);
                double y = decodeArray.getDouble(j2++);
                colorDecode[i].setLocation(x, y);
            }
        }
        int nCompLocal = functionArray != null && !functionArray.isEmpty() ? 1 : nColors;
        ByteArrayOutputStream outStm = new ByteArrayOutputStream();
        pdfShadingCoons.getStreamData(outStm);
        shadingObj.setBitsPerComponent(bitsPerComponent);
        shadingObj.setBitsPerCoordinate(bitsPerCoordinate);
        shadingObj.setBitsPerFlag(bitsPerFlag);
        shadingObj.setNCompLocal(nCompLocal);
        shadingObj.setColorDecode(colorDecode);
        shadingObj.setCoordDecode(coordDecode);
        shadingObj.setMatrix(matrix);
        shadingObj.setColorSpace(ColorSpaceCacheImpl.newInstance(pdfColorSpace, loadedColorSpaces, null));
        try {
            shadingObj.setCoonsShadingStream(outStm.toByteArray());
        }
        finally {
            try {
                outStm.flush();
                outStm.close();
            }
            catch (IOException iOException) {}
        }
    }

    static class MaxCoordinates {
        private double xMax;
        private double yMax;

        MaxCoordinates() {
        }
    }
}

