/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.impl.FieldAndAnnotationImpl;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMStructure;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMNamedDestinations;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PMMAcroForms {
    private static final ASName[] specialFieldKeys = new ASName[]{ASName.k_Parent, ASName.k_Kids, ASName.k_AA};
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;
    private PMMPages pagesHandler;
    private HashSet<PDFFieldNode> visitedSet = null;

    public PMMAcroForms(PDFDocument doc, CosCloneMgr clonehandler, PMMPages pages) {
        this.inDoc = doc;
        this.cloneHandler = clonehandler;
        this.pagesHandler = pages;
    }

    private PDFFieldNode walkAcroForms(PDFFieldNode curParent, PDFFieldNode startField, AcroFormOperation action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (startField == null) {
            return null;
        }
        PDFFieldNode clonedField = action.firstAction(curParent, startField);
        if (clonedField == null) {
            return null;
        }
        PDFFieldNode found = startField;
        PDFFieldList kids = startField.getChildren();
        if (kids == null) {
            return action.lastAction(curParent, startField);
        }
        Object[] childrenFields = kids.toArray();
        for (int kidsInd = 0; kidsInd < childrenFields.length; ++kidsInd) {
            PDFFieldNode curField = (PDFFieldNode)childrenFields[kidsInd];
            if (curField == null) continue;
            if (null == this.visitedSet) {
                this.visitedSet = new HashSet();
            }
            if (this.visitedSet.contains(curField)) {
                if ((curField = action.lastAction(startField, curField)) != null) continue;
                return null;
            }
            this.visitedSet.add(curField);
            PDFFieldNode childField = this.walkAcroForms(clonedField, curField, action);
            if (childField == null) {
                found = null;
                continue;
            }
            if (action.conditionAction(startField, curField)) {
                if ((curField = action.lastAction(startField, curField)) != null) continue;
                return null;
            }
            found = null;
        }
        return found;
    }

    void deleteAcroForm(List<PDFPage> pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.deleteAcroForm(this.populateWidgetsFromPages(pages));
    }

    void deleteAcroForm(PDFFieldList fields, boolean exclidingList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.deleteAcroForm(this.populateWidgetsFromPages(fields, exclidingList));
    }

    Map<PDFFieldNode, PDFFieldNode> appendAcroForms(PDFDocument srcDoc, Map<PDFPage, PDFPage> clonedPages, Map<PDFAnnotation, PDFAnnotation> clonedAnnots, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFInteractiveForm acroForm = srcDoc.getInteractiveForm();
        if (acroForm == null) {
            return null;
        }
        ExtractAcroForm extractAction = new ExtractAcroForm(srcDoc, clonedPages, clonedAnnots, curDests, allDests, allActions, allAdditionalActions);
        this.walkAcroForms(null, acroForm, extractAction);
        PDFInteractiveForm extractedForm = extractAction.getTargetForm();
        if (extractedForm != null) {
            MergeAcroForm mergeAction = new MergeAcroForm(extractedForm);
            this.walkAcroForms(null, extractedForm, mergeAction);
            PDFInteractiveForm targetForm = mergeAction.getTargetForm();
            if (targetForm != null) {
                this.inDoc.setInteractiveForm(targetForm);
                this.mergeCalculationOrder(targetForm, acroForm, extractAction.allFields);
            }
        }
        return extractAction.allFields;
    }

    Map<PDFFieldNode, PDFFieldNode> extractAcroForms(PDFDocument srcDoc, Map<PDFPage, PDFPage> clonedPages, Map<PDFAnnotation, PDFAnnotation> clonedAnnots, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm acroForm = srcDoc.getInteractiveForm();
        if (acroForm == null) {
            return null;
        }
        ExtractAcroForm extractAction = new ExtractAcroForm(srcDoc, clonedPages, clonedAnnots, curDests, allDests, allActions, allAdditionalActions);
        this.walkAcroForms(null, acroForm, extractAction);
        PDFInteractiveForm targetForm = extractAction.getTargetForm();
        if (targetForm != null) {
            this.mergeCalculationOrder(targetForm, acroForm, extractAction.allFields);
            this.inDoc.setInteractiveForm(targetForm);
        }
        return extractAction.allFields;
    }

    static PDFInteractiveForm startAcroForm(PDFDocument fromDoc, PDFDocument toDoc, CosCloneMgr cloneHandler, PDFFieldNode firstField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PMMAcroForms.startAcroForm(fromDoc.getInteractiveForm(), toDoc, cloneHandler, firstField);
    }

    private static PDFInteractiveForm startAcroForm(PDFInteractiveForm srcAcroForm, PDFDocument toDoc, CosCloneMgr cloneHandler, PDFFieldNode firstField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcAcroForm == null) {
            return null;
        }
        PDFFieldList kids = PDFFieldList.newInstance(toDoc);
        if (firstField != null) {
            kids.add(firstField);
        }
        PDFInteractiveForm acroForm = PDFInteractiveForm.newInstance(toDoc, kids);
        if (srcAcroForm != null) {
            if (srcAcroForm.dictionaryContains(ASName.k_NeedAppearances) && srcAcroForm.getDictionaryBooleanValue(ASName.k_NeedAppearances)) {
                acroForm.setDictionaryBooleanValue(ASName.k_NeedAppearances, true);
            }
            if (srcAcroForm.dictionaryContains(ASName.k_DR)) {
                acroForm.setDictionaryValue(ASName.k_DR, cloneHandler.clone(srcAcroForm.getDictionaryDictionaryValue(ASName.k_DR)));
            }
            if (srcAcroForm.dictionaryContains(ASName.k_DA)) {
                acroForm.setDictionaryValue(ASName.k_DA, cloneHandler.clone(srcAcroForm.getDictionaryCosObjectValue(ASName.k_DA)));
            }
        }
        return acroForm;
    }

    ArrayList getTerminalFields(PDFFieldNode nextNode, ArrayList terminalFieldList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (PDFFieldNode nextSubField : nextNode.getChildren()) {
            if (!nextSubField.isTerminalField()) {
                this.getTerminalFields(nextSubField, terminalFieldList);
                continue;
            }
            terminalFieldList.add(nextSubField);
        }
        return terminalFieldList;
    }

    Map<PDFFieldNode, PDFFieldNode> createNewFieldHierarchyForTemplate(PDFDocument srcDoc, Map<PDFPage, PDFPage> clonedPages, Map<PDFAnnotation, PDFAnnotation> clonedAnnots, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions, String cesPrefix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException {
        PDFInteractiveForm acroForm = srcDoc.getInteractiveForm();
        ExtractAcroForm extractAction = new ExtractAcroForm(srcDoc, clonedPages, clonedAnnots, curDests, allDests, allActions, allAdditionalActions);
        if (acroForm == null) {
            return null;
        }
        PDFFieldList kids = acroForm.getChildren();
        if (kids != null) {
            for (PDFFieldNode kid : kids) {
                PDFAnnotationIterator widgetsIterator;
                String name = kid.getQualifiedName();
                if (name.contains(cesPrefix)) continue;
                String newName = cesPrefix + "." + name;
                PDFFieldNode newNode = this.inDoc.getInteractiveForm().procureIntermediateFieldNodes(newName);
                PDFField field = PDFField.getInstance(kid.getCosObject());
                if (field == null || (widgetsIterator = field.getAnnotationsIterator()) == null) continue;
                while (widgetsIterator.hasNext()) {
                    PDFAnnotation widget = widgetsIterator.next();
                    if (!extractAction.mapAnnots.containsKey(widget)) continue;
                    PDFField widgetField = PDFField.getInstance(widget.getCosObject());
                    PDFAnnotation clonedWidget = (PDFAnnotation)extractAction.mapAnnots.get(widget);
                    if (widgetField == null) {
                        PDFAnnotationList annots = PDFField.getInstance(kid.getCosObject()).getAnnotations();
                        if (annots != null && annots.contains(clonedWidget)) continue;
                        field.addAnnotation(clonedWidget);
                        newNode.addChild(extractAction.cloneField(kid));
                        continue;
                    }
                    PDFFieldNode clonedField = extractAction.cloneField(widgetField);
                    clonedField = this.insertInheritableAttirbutesForSpawning(clonedField);
                    newNode.addChild(clonedField);
                }
            }
        }
        return extractAction.allFields;
    }

    public FieldAndAnnotationImpl getField(String fieldName) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getFieldNode(fieldName);
    }

    FieldAndAnnotationImpl getFieldNode(String fieldNodeName) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        String[] partialNames = fieldNodeName.split("\\.");
        PDFInteractiveForm iform = this.inDoc.getInteractiveForm();
        boolean useAcrobatIsTerminalFieldCheck = true;
        return PDFFieldUtils.findChildFieldNode(partialNames, iform, iform, useAcrobatIsTerminalFieldCheck, 0);
    }

    private PDFFieldNode findFieldByFullName(PDFFieldNode parent, String fullName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fullName == null) {
            return null;
        }
        PDFFieldList parentFields = parent.getChildren();
        if (parentFields == null) {
            return null;
        }
        for (int fieldInd = 0; fieldInd < parentFields.size(); ++fieldInd) {
            String curName;
            PDFFieldNode curField = (PDFFieldNode)parentFields.get(fieldInd);
            if (curField == null || !(curName = curField.getQualifiedName()).equals(fullName)) continue;
            return curField;
        }
        return null;
    }

    private void deleteAcroForm(Set<PDFAnnotation> widgets) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        DeleteAcroForm deleteAction = new DeleteAcroForm(widgets);
        PDFInteractiveForm acroForm = this.inDoc.getInteractiveForm();
        if (acroForm == null) {
            return;
        }
        this.walkAcroForms(null, acroForm, deleteAction);
        PDFFieldList kids = acroForm.getChildren();
        if (kids != null && kids.size() == 0) {
            this.inDoc.setInteractiveForm(null);
        }
        this.remakeCalculationOrder(this.inDoc.getInteractiveForm());
    }

    private Set<PDFAnnotation> populateWidgetsFromPages(PDFFieldList fields, boolean exclidingList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<PDFAnnotation> widgetFields = new HashSet<PDFAnnotation>();
        if (fields == null) {
            return widgetFields;
        }
        if (exclidingList) {
            PDFInteractiveForm acroForm = fields.getPDFDocument().getInteractiveForm();
            if (acroForm == null) {
                return widgetFields;
            }
            widgetFields = this.populateWidgetsFromPages(acroForm.getChildren(), false);
        }
        Iterator<PDFFieldNode> fieldsIter = fields.iterator();
        while (fieldsIter.hasNext()) {
            while (fieldsIter.hasNext()) {
                PDFFieldNode curNode = fieldsIter.next();
                if (curNode == null) continue;
                if (curNode.isTerminalField()) {
                    this.populateWidget(widgetFields, (PDFField)curNode, exclidingList);
                    continue;
                }
                Iterator<PDFField> curIter = curNode.iterator();
                while (curIter.hasNext()) {
                    PDFField curField = curIter.next();
                    if (curField == null) continue;
                    this.populateWidget(widgetFields, curField, exclidingList);
                }
            }
        }
        return widgetFields;
    }

    private void mergeCalculationOrder(PDFInteractiveForm targetForm, PDFInteractiveForm srcForm, Map<PDFFieldNode, PDFFieldNode> clonedFields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcForm == null) {
            return;
        }
        PDFFieldList srcCalc = srcForm.getCalculationOrder();
        if (srcCalc == null) {
            return;
        }
        PDFFieldList targetCalc = targetForm.getCalculationOrder();
        if (targetCalc == null) {
            targetCalc = PDFFieldList.newInstance(targetForm.getPDFDocument());
        }
        for (int calcInd = 0; calcInd < srcCalc.size(); ++calcInd) {
            PDFFieldNode curField = (PDFFieldNode)srcCalc.get(calcInd);
            if (targetCalc.getFieldFullyNamed(curField.getQualifiedName()) != null || !clonedFields.containsKey(curField)) continue;
            targetCalc.add((PDFCosObjectContainer)clonedFields.get(curField));
        }
        if (!targetCalc.isEmpty()) {
            targetForm.setCalculationOrder(targetCalc);
        }
    }

    private void remakeCalculationOrder(PDFInteractiveForm form) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (form == null) {
            return;
        }
        PDFFieldList calcOrder = form.getCalculationOrder();
        if (calcOrder == null) {
            return;
        }
        PDFFieldList newOrder = PDFFieldList.newInstance(form.getPDFDocument());
        int newInd = 0;
        for (int calcInd = 0; calcInd < calcOrder.size(); ++calcInd) {
            PDFFieldNode origField = (PDFFieldNode)calcOrder.get(calcInd);
            if (origField == null || form.getChildren().getFieldFullyNamed(origField.getQualifiedName()) == null) continue;
            newOrder.add(newInd++, origField);
        }
        if (newOrder.isEmpty()) {
            newOrder = null;
        }
        form.setCalculationOrder(newOrder);
    }

    private void populateWidget(Set<PDFAnnotation> widgetFields, PDFField curField, boolean excluding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (curField instanceof PDFFieldSignature) {
            return;
        }
        PDFAnnotationIterator annotsIter = curField.getAnnotationsIterator();
        while (annotsIter.hasNext()) {
            if (excluding) {
                widgetFields.remove(annotsIter.next());
                continue;
            }
            widgetFields.add(annotsIter.next());
        }
    }

    private Set<PDFAnnotation> populateWidgetsFromPages(List<PDFPage> pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<PDFAnnotation> widgetFields = new HashSet<PDFAnnotation>();
        for (int pageInd = 0; pageInd < pages.size(); ++pageInd) {
            PDFPage curPage = pages.get(pageInd);
            PDFAnnotationList annots = curPage.getAnnotationList();
            if (annots == null) continue;
            for (int annotsInd = 0; annotsInd < annots.size(); ++annotsInd) {
                PDFField annotField;
                PDFAnnotation annot = annots.get(annotsInd);
                if (!(annot instanceof PDFAnnotationWidget) || (annotField = ((PDFAnnotationWidget)annot).getField()) instanceof PDFFieldSignature) continue;
                widgetFields.add(annot);
            }
        }
        return widgetFields;
    }

    private PDFFieldNode splitField(PDFInteractiveForm curForm, PDFField curField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (curField.getChildren() != null) {
            return curField;
        }
        if (curField.isAcrobatAnnotation()) {
            return curField;
        }
        PDFFieldNode pureField = PDFFieldNode.newInstance(curField);
        PDFFieldNode curParent = curField.getParent();
        if (curParent == null) {
            curParent = curForm;
        }
        curField.removeFieldEntries();
        curParent.removeChild(curField);
        curParent.addChild(pureField);
        pureField.addChild(curField);
        return PDFFieldNode.getInstance(pureField.getCosObject());
    }

    private void mergeFields(PDFFieldNode srcField, PDFFieldNode curField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList srcKids = srcField.getChildren();
        if (srcKids == null) {
            PDFFieldList curKids = curField.getChildren();
            if (curKids == null || !curKids.contains(srcField)) {
                srcField = this.insertInheritableAttirbutes(srcField);
                srcField = this.removeConflictingAttributes(srcField);
                curField.addChild(srcField);
            }
            return;
        }
        for (PDFFieldNode kid : srcKids) {
            kid = this.insertInheritableAttirbutes(kid);
            kid = this.removeConflictingAttributes(kid);
            curField.addChild(kid);
        }
    }

    private PDFFieldNode insertInheritableAttirbutes(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List options;
        PDFFieldButton fieldButton;
        if (!field.dictionaryContains(ASName.k_Ff)) {
            field.setFlags(field.getFlags());
        }
        if (field.getFieldType() == PDFFieldType.Text) {
            PDFVariableText fieldVariableText;
            int maxLen;
            PDFFieldText fieldTxt = (PDFFieldText)field;
            if (!fieldTxt.dictionaryContains(ASName.k_MaxLen) && (maxLen = fieldTxt.getMaxLen()) != 0) {
                fieldTxt.setDictionaryIntValue(ASName.k_MaxLen, maxLen);
            }
            if ((fieldVariableText = fieldTxt.getVariableText()) != null) {
                if (!fieldVariableText.dictionaryContains(ASName.k_DA)) {
                    PDFDefaultAppearance defaultAppearance = fieldVariableText.getDefaultAppearance();
                    String defaultApperanceString = null;
                    if (defaultAppearance != null) {
                        defaultApperanceString = defaultAppearance.asString();
                    }
                    fieldVariableText.setDefaultAppearance(defaultApperanceString);
                }
                if (!fieldVariableText.dictionaryContains(ASName.k_Q)) {
                    int quadding = fieldVariableText.getQuadding();
                    fieldVariableText.setQuadding(quadding);
                }
            }
        } else if (field.getFieldType() == PDFFieldType.Button && !(fieldButton = (PDFFieldButton)field).dictionaryContains(ASName.k_Opt) && (options = fieldButton.getOptionList()) != null) {
            try {
                fieldButton.setOptionList(options);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid Option List in Button Field", e);
            }
        }
        return field;
    }

    private PDFFieldNode insertInheritableAttirbutesForSpawning(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List options;
        PDFFieldButton fieldButton;
        if (!field.dictionaryContains(ASName.k_Ff)) {
            field.setFlags(field.getFlags());
        }
        if (!field.dictionaryContains(ASName.k_FT)) {
            field.setDictionaryNameValue(ASName.k_FT, field.getFieldType().getValue());
        }
        if (!field.dictionaryContains(ASName.k_T)) {
            field.setPartialName(field.getInheritedPartialName());
        }
        if (field.getFieldType() == PDFFieldType.Text) {
            PDFVariableText fieldVariableText;
            int maxLen;
            PDFFieldText fieldTxt = (PDFFieldText)field;
            if (!fieldTxt.dictionaryContains(ASName.k_MaxLen) && (maxLen = fieldTxt.getMaxLen()) != 0) {
                fieldTxt.setDictionaryIntValue(ASName.k_MaxLen, maxLen);
            }
            if ((fieldVariableText = fieldTxt.getVariableText()) != null) {
                if (!fieldVariableText.dictionaryContains(ASName.k_DA)) {
                    PDFDefaultAppearance defaultAppearance = fieldVariableText.getDefaultAppearance();
                    String defaultApperanceString = null;
                    if (defaultAppearance != null) {
                        defaultApperanceString = defaultAppearance.asString();
                    }
                    fieldVariableText.setDefaultAppearance(defaultApperanceString);
                }
                if (!fieldVariableText.dictionaryContains(ASName.k_Q)) {
                    int quadding = fieldVariableText.getQuadding();
                    fieldVariableText.setQuadding(quadding);
                }
            }
        } else if (field.getFieldType() == PDFFieldType.Button && !(fieldButton = PDFFieldButton.getInstance(field.getCosObject())).dictionaryContains(ASName.k_Opt) && (options = fieldButton.getOptionList()) != null) {
            try {
                fieldButton.setOptionList(options);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid Option List in Button Field", e);
            }
        }
        return field;
    }

    private PDFFieldNode removeConflictingAttributes(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        field.removeValue(ASName.k_T);
        field.removeValue(ASName.k_FT);
        field.removeValue(ASName.k_V);
        field.removeValue(ASName.k_DV);
        field.removeValue(ASName.k_RV);
        return field;
    }

    private class ExtractAcroForm
    implements AcroFormOperation {
        private Map<PDFFieldNode, PDFFieldNode> allFields = new HashMap<PDFFieldNode, PDFFieldNode>();
        private Map<PDFPage, PDFPage> mapPages;
        private Map<PDFAnnotation, PDFAnnotation> mapAnnots;
        private Map<PDFAction, PDFAction> allActions;
        private Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions;
        PMMNamedDestinations curDests;
        private Map<ASString, PDFDestinationNamed> allDests;
        private PDFDocument srcDoc;
        private PDFInteractiveForm targetForm;

        ExtractAcroForm(PDFDocument source, Map<PDFPage, PDFPage> extractedPages, Map<PDFAnnotation, PDFAnnotation> extractedAnnots, PMMNamedDestinations targetDests, Map<ASString, PDFDestinationNamed> allDestsMapping, Map<PDFAction, PDFAction> clonedActions, Map<PDFAdditionalActions, PDFAdditionalActions> clonedAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.mapPages = extractedPages;
            this.mapAnnots = extractedAnnots;
            this.allActions = clonedActions;
            this.allAdditionalActions = clonedAdditionalActions;
            this.curDests = targetDests;
            this.allDests = allDestsMapping;
            this.srcDoc = source;
            this.targetForm = null;
        }

        @Override
        public boolean conditionAction(PDFFieldNode curParent, PDFFieldNode field) {
            return true;
        }

        @Override
        public PDFFieldNode firstAction(PDFFieldNode curParent, PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFAnnotationIterator widgetsIterator;
            PDFAnnotationIterator pDFAnnotationIterator = widgetsIterator = field instanceof PDFField ? ((PDFField)field).getAnnotationsIterator() : null;
            if (widgetsIterator != null) {
                while (widgetsIterator.hasNext()) {
                    PDFAnnotation widget = widgetsIterator.next();
                    if (!this.mapAnnots.containsKey(widget)) continue;
                    PDFField widgetField = PDFField.getInstance(widget.getCosObject());
                    PDFAnnotation clonedWidget = this.mapAnnots.get(widget);
                    if (widgetField == null) {
                        FindWidget findAction = new FindWidget(widget);
                        PMMAcroForms.this.walkAcroForms(null, this.srcDoc.getInteractiveForm(), findAction);
                        PDFFieldNode widgetParent = findAction.getWidgetParent();
                        PDFField clonedParent = (PDFField)this.cloneField(widgetParent);
                        PDFAnnotationList annots = clonedParent.getAnnotations();
                        if (annots != null && annots.contains(clonedWidget)) continue;
                        clonedParent.addAnnotation(clonedWidget);
                        continue;
                    }
                    this.cloneField(widgetField);
                }
            }
            return field;
        }

        public PDFInteractiveForm getTargetForm() {
            return this.targetForm;
        }

        @Override
        public PDFFieldNode lastAction(PDFFieldNode curParent, PDFFieldNode field) {
            return field;
        }

        private PDFFieldNode cloneField(PDFFieldNode srcForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFFieldList clonedParentKids;
            PDFFieldNode clonedParent;
            PDFFieldNode clonedField;
            if (this.allFields.containsKey(srcForm)) {
                return this.allFields.get(srcForm);
            }
            if (srcForm.isTerminalField() && ((PDFField)srcForm).isAnnotation()) {
                clonedField = PDFFieldFactory.getInstance(this.mapAnnots.get(PDFAnnotationFactory.getInstance(srcForm.getCosObject())).getCosObject(), ((PDFField)srcForm).getFieldType().getValue());
            } else {
                CosDictionary cosField = CosUtils.cloneOrdinaryKeys(PMMAcroForms.this.inDoc.getCosDocument(), PMMAcroForms.this.cloneHandler, srcForm.getCosDictionary(), specialFieldKeys);
                if (srcForm.dictionaryContains(ASName.k_Kids)) {
                    CosArray fakeKids = PMMAcroForms.this.inDoc.getCosDocument().createCosArray();
                    fakeKids.add(cosField);
                    cosField.put(ASName.k_Kids, fakeKids);
                }
                clonedField = PDFFieldNode.getInstance(cosField);
                if (srcForm.dictionaryContains(ASName.k_Kids)) {
                    clonedField.removeValue(ASName.k_Kids);
                }
            }
            PMMAcroForms.this.pagesHandler.cloneAdditionalActions(PMMAcroForms.this.inDoc, PMMAcroForms.this.cloneHandler, srcForm.getAdditionalActions(), this.curDests, this.allDests, this.mapPages, this.allActions, this.allAdditionalActions);
            this.allFields.put(srcForm, clonedField);
            PDFFieldNode parentField = srcForm.getParent();
            if (parentField == null) {
                clonedParent = this.targetForm;
                if (clonedParent == null) {
                    this.targetForm = PMMAcroForms.startAcroForm(this.srcDoc, PMMAcroForms.this.inDoc, PMMAcroForms.this.cloneHandler, clonedField);
                    clonedParent = this.targetForm;
                }
            } else {
                clonedParent = this.cloneField(parentField);
            }
            if ((clonedParentKids = clonedParent.getChildren()) == null || !clonedParentKids.contains(clonedField)) {
                clonedParent.addChild(clonedField);
            }
            return clonedField;
        }
    }

    public class DeleteAcroForm
    implements AcroFormOperation {
        private Set<PDFAnnotation> widgetFields;
        private PMMStructure structHandler;

        public DeleteAcroForm(Set<PDFAnnotation> widgets) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.widgetFields = widgets;
            this.structHandler = new PMMStructure(PMMAcroForms.this.inDoc, null);
        }

        @Override
        public boolean conditionAction(PDFFieldNode curParent, PDFFieldNode field) {
            return true;
        }

        @Override
        public PDFFieldNode firstAction(PDFFieldNode curParent, PDFFieldNode field) {
            return field;
        }

        @Override
        public PDFFieldNode lastAction(PDFFieldNode curParent, PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFAnnotationIterator widgetsIterator;
            if (curParent == null || !curParent.getChildren().contains(field)) {
                return field;
            }
            if (curParent == field) {
                this.deleteField(null, field);
                return field;
            }
            PDFAnnotationIterator pDFAnnotationIterator = widgetsIterator = field instanceof PDFField ? ((PDFField)field).getAnnotationsIterator() : null;
            if (widgetsIterator != null && widgetsIterator.hasNext()) {
                boolean allDeleted = true;
                while (widgetsIterator.hasNext()) {
                    PDFAnnotation widget = widgetsIterator.next();
                    if (this.widgetFields.contains(widget)) {
                        PDFAnnotationList pageAnnots;
                        widgetsIterator.remove();
                        PDFPage widgetPage = widget.getPage();
                        if (widgetPage == null || (pageAnnots = widgetPage.getAnnotationList()) == null) continue;
                        pageAnnots.remove(widget);
                        if (!pageAnnots.isEmpty()) continue;
                        widgetPage.removeAnnotationList();
                        continue;
                    }
                    allDeleted = false;
                }
                if (allDeleted) {
                    this.deleteField(curParent, field);
                }
            } else {
                PDFFieldList kids = field.getChildren();
                if (kids != null && kids.size() == 0) {
                    this.deleteField(curParent, field);
                }
            }
            return field;
        }

        private void removeFieldFromStructure(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFStructureElement fieldElement = (PDFStructureElement)this.structHandler.removeParentEntry(this.structHandler.getStructParents(field.getCosDictionary()));
            this.structHandler.deleteElement(fieldElement);
        }

        private void deleteField(PDFFieldNode parent, PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (parent == null) {
                PDFInteractiveForm acroForm = PMMAcroForms.this.inDoc.getInteractiveForm();
                if (acroForm == null) {
                    return;
                }
                PDFFieldList kids = acroForm.getChildren();
                this.removeFieldFromStructure(field);
                kids.remove(field);
                if (kids.size() == 0) {
                    PDFCatalog catalog = PMMAcroForms.this.inDoc.requireCatalog();
                    catalog.removeValue(ASName.k_AcroForm);
                }
            } else {
                PDFFieldList kids = parent.getChildren();
                this.removeFieldFromStructure(field);
                kids.remove(field);
            }
        }
    }

    private static class FindWidget
    implements AcroFormOperation {
        private PDFAnnotation srcWidget;
        private PDFFieldNode widgetParent;

        FindWidget(PDFAnnotation widget) {
            this.srcWidget = widget;
            this.widgetParent = null;
        }

        @Override
        public PDFFieldNode firstAction(PDFFieldNode curParent, PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.widgetParent != null) {
                return null;
            }
            if (curParent != null) {
                PDFAnnotationIterator widgetsIterator;
                PDFAnnotationIterator pDFAnnotationIterator = widgetsIterator = field instanceof PDFField ? ((PDFField)field).getAnnotationsIterator() : null;
                if (widgetsIterator != null) {
                    while (widgetsIterator.hasNext()) {
                        PDFAnnotation widget = widgetsIterator.next();
                        if (widget != this.srcWidget) continue;
                        this.widgetParent = field;
                        return null;
                    }
                }
            }
            return field;
        }

        @Override
        public PDFFieldNode lastAction(PDFFieldNode curParent, PDFFieldNode field) {
            return field;
        }

        @Override
        public boolean conditionAction(PDFFieldNode curParent, PDFFieldNode field) {
            return true;
        }

        public PDFFieldNode getWidgetParent() {
            return this.widgetParent;
        }
    }

    private class MergeAcroForm
    implements AcroFormOperation {
        private PDFInteractiveForm sourceForm;
        private PDFInteractiveForm targetForm;

        MergeAcroForm(PDFInteractiveForm srcForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.sourceForm = srcForm;
            this.targetForm = PMMAcroForms.this.inDoc.getInteractiveForm();
        }

        @Override
        public PDFFieldNode firstAction(PDFFieldNode curParent, PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (curParent == null) {
                curParent = this.targetForm;
                if (curParent == null) {
                    this.targetForm = PMMAcroForms.startAcroForm(this.sourceForm, PMMAcroForms.this.inDoc, PMMAcroForms.this.cloneHandler, null);
                    curParent = this.targetForm;
                }
                return curParent;
            }
            PDFFieldNode mergedField = PMMAcroForms.this.findFieldByFullName(curParent, field.getQualifiedName());
            if (mergedField != null) {
                if (mergedField instanceof PDFFieldSignature) {
                    return field;
                }
                boolean haveTerminalField = false;
                if (mergedField.isTerminalField()) {
                    if ((mergedField = PMMAcroForms.this.splitField(this.targetForm, (PDFField)mergedField)).isTerminalField() && ((PDFField)mergedField).isAcrobatAnnotation() && (mergedField = mergedField.getParent()) == null) {
                        mergedField = this.targetForm;
                    }
                    haveTerminalField = true;
                }
                if (field.isTerminalField()) {
                    haveTerminalField = true;
                }
                if (!haveTerminalField) {
                    return mergedField;
                }
                PMMAcroForms.this.mergeFields(field, mergedField);
                return null;
            }
            curParent.addChild(field);
            if (!(curParent instanceof PDFInteractiveForm)) {
                field.setDictionaryValue(ASName.k_Parent, curParent);
            }
            return field;
        }

        @Override
        public PDFFieldNode lastAction(PDFFieldNode curParent, PDFFieldNode field) {
            return field;
        }

        @Override
        public boolean conditionAction(PDFFieldNode curParent, PDFFieldNode field) {
            return true;
        }

        public PDFInteractiveForm getTargetForm() {
            return this.targetForm;
        }
    }

    private static interface AcroFormOperation {
        public PDFFieldNode firstAction(PDFFieldNode var1, PDFFieldNode var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

        public PDFFieldNode lastAction(PDFFieldNode var1, PDFFieldNode var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

        public boolean conditionAction(PDFFieldNode var1, PDFFieldNode var2);
    }
}

