/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildProp;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.javascript.BuildInfo;
import com.adobe.internal.pdftoolkit.services.javascript.Certificate;
import com.adobe.internal.pdftoolkit.services.javascript.GibsonTopLevelScope;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptSecurityException;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSRevocationInfo;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSSigInfo;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.SigInfoParams;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class SignatureInfo
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("SignatureInfo.class", new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, new HashMap<String, Property>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("dateTrusted", new Property(SignatureInfo.class, "dateTrusted", "getDateTrusted", null, null, false, false));
            this.put("byteRange", new Property(SignatureInfo.class, "byteRange", "getByteRange", null, null, false, false));
            this.put("numFieldsFilledIn", new Property(SignatureInfo.class, "numFieldsFilledIn", "getNumFieldsFilledIn", null, null, false, false));
            this.put("buildInfo", new Property(SignatureInfo.class, "buildInfo", "getBuildInfo", null, null, false, false));
            this.put("reason", new Property(SignatureInfo.class, "reason", "getReason", "setReason", SigInfoParams.reason, false, true));
            this.put("verifyHandlerUIName", new Property(SignatureInfo.class, "verifyHandlerUIName", "getVerifyHandlerUIName", null, null, false, false));
            this.put("appearance", new Property(SignatureInfo.class, "appearance", null, "setAppearance", SigInfoParams.appearance, false, true));
            this.put("contactInfo", new Property(SignatureInfo.class, "contactInfo", "getContactInfo", "setContactInfo", SigInfoParams.contactInfo, false, true));
            this.put("certificates", new Property(SignatureInfo.class, "certificates", "getCertificates", null, null, false, false));
            this.put("date", new Property(SignatureInfo.class, "date", "getDate", null, null, false, false));
            this.put("handlerUserName", new Property(SignatureInfo.class, "handlerUserName", "getHandlerUserName", null, null, false, false));
            this.put("password", new Property(SignatureInfo.class, "password", null, "setPassword", SigInfoParams.password, false, true));
            this.put("objValidity", new Property(SignatureInfo.class, "objValidity", "getObjValidity", null, null, false, false));
            this.put("statusText", new Property(SignatureInfo.class, "statusText", "getStatusText", null, null, false, false));
            this.put("verifyDate", new Property(SignatureInfo.class, "verifyDate", "getVerifyDate", null, null, false, false));
            this.put("digestMethod", new Property(SignatureInfo.class, "digestMethod", "getDigestMethod", "setDigestMethod", SigInfoParams.digestMethod, false, true));
            this.put("subFilter", new Property(SignatureInfo.class, "subFilter", "getSubFilter", "setSubFilter", SigInfoParams.subFilter, false, true));
            this.put("idPrivValidity", new Property(SignatureInfo.class, "idPrivValidity", "getIdPrivValidity", null, null, false, false));
            this.put("mdp", new Property(SignatureInfo.class, "mdp", "getMdp", "setMdp", SigInfoParams.mdp, false, true));
            this.put("docValidity", new Property(SignatureInfo.class, "docValidity", "getDocValidity", null, null, false, false));
            this.put("sigValue", new Property(SignatureInfo.class, "sigValue", "getSigValue", null, null, false, false));
            this.put("timeStamp", new Property(SignatureInfo.class, "timeStamp", null, "setTimeStamp", SigInfoParams.timeStamp, false, true));
            this.put("location", new Property(SignatureInfo.class, "location", "getLocation", "setLocation", SigInfoParams.location, false, true));
            this.put("handlerName", new Property(SignatureInfo.class, "handlerName", "getHandlerName", null, null, false, false));
            this.put("revision", new Property(SignatureInfo.class, "revision", "getRevision", null, null, false, false));
            this.put("numRevisions", new Property(SignatureInfo.class, "numRevisions", "getNumRevisions", null, null, false, false));
            this.put("idValidity", new Property(SignatureInfo.class, "idValidity", "getIdValidity", null, null, false, false));
            this.put("name", new Property(SignatureInfo.class, "name", "getName", null, null, false, false));
            this.put("verifyHandlerName", new Property(SignatureInfo.class, "verifyHandlerName", "getVerifyHandlerName", null, null, false, false));
            this.put("handlerUIName", new Property(SignatureInfo.class, "handlerUIName", "getHandlerUIName", null, null, false, false));
            this.put("revInfo", new Property(SignatureInfo.class, "revInfo", "getRevInfo", null, null, false, false));
            this.put("status", new Property(SignatureInfo.class, "status", "getStatus", null, null, false, false));
            this.put("trustFlags", new Property(SignatureInfo.class, "trustFlags", "getTrustFlags", null, null, false, false));
            this.put("numPagesAltered", new Property(SignatureInfo.class, "numPagesAltered", "getNumPagesAltered", null, null, false, false));
            this.put("numFieldsAltered", new Property(SignatureInfo.class, "numFieldsAltered", "getNumFieldsAltered", null, null, false, false));
        }
    });
    private static final long serialVersionUID = -5741854618259052749L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z");
    private JSSigInfo jsSigInfo = null;
    private SignatureFieldInterface sigField = null;
    static final String className = "SignatureInfo";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    @Override
    public String getClassName() {
        return className;
    }

    void setInitialParams(JSSigInfo sigInfo, SignatureFieldInterface field) {
        if (sigInfo != null) {
            this.jsSigInfo = sigInfo;
        }
        this.sigField = field;
    }

    public Object getBuildInfo() {
        try {
            SignatureFieldPDF pdfField;
            PDFSignature sig;
            PDFBuildProp buildPropDict;
            if (this.sigField.isSigned() && (buildPropDict = (sig = (pdfField = this.sigField.getPDFField()).getPDFFieldSignature().getSignature()).getPDFBuildPropDictionary()) != null) {
                BuildInfo biInfo = (BuildInfo)ESObject.create(this.getParentScope(), true, "BuildInfo", false, null);
                biInfo.setBuildPropDict(buildPropDict);
                return biInfo;
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getDate() {
        Date date;
        if (this.jsSigInfo != null && (date = this.jsSigInfo.getDate()) != null) {
            return this.dateFormat.format(date);
        }
        return Undefined.instance;
    }

    public Object getDateTrusted() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getDateTrusted();
        }
        return Undefined.instance;
    }

    public Object getDigestMethod() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getDigestMethod();
        }
        return Undefined.instance;
    }

    public Object getHandlerName() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getHandlerName();
        }
        return Undefined.instance;
    }

    public Object getHandlerUserName() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getHandlerUserName();
        }
        return Undefined.instance;
    }

    public Object getHandlerUIName() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getHandlerUIName();
        }
        return Undefined.instance;
    }

    public Object getLocation() {
        try {
            if (this.sigField.isSigned()) {
                SignatureFieldPDF pdfField = this.sigField.getPDFField();
                PDFSignature sig = pdfField.getPDFFieldSignature().getSignature();
                return sig.getLocation();
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getMdp() {
        try {
            PDFDocMDPPermissions mdpPerm = SignatureManager.newInstance(this.sigField.getPDFDocument()).getPDFDocMDPPermissions();
            if (mdpPerm != null) {
                switch (mdpPerm.getValue()) {
                    case 1: {
                        return "allowNone";
                    }
                    case 2: {
                        return "default";
                    }
                    case 3: {
                        return "defaultAndComments";
                    }
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getName() {
        String name;
        if (this.jsSigInfo != null && (name = this.jsSigInfo.getName()) != null) {
            return name;
        }
        return Undefined.instance;
    }

    public Object getNumFieldsAltered() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getnumFieldsAltered();
        }
        return Undefined.instance;
    }

    public Object getNumFieldsFilledIn() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getnumFieldsFilledIn();
        }
        return Undefined.instance;
    }

    public Object getNumPagesAltered() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getnumPagesAltered();
        }
        return Undefined.instance;
    }

    public Number getNumRevisions() {
        return this.getRevision(false);
    }

    public Object getReason() {
        PDFSignature sig = null;
        try {
            if (this.sigField.isSigned()) {
                SignatureFieldPDF pdfField = this.sigField.getPDFField();
                sig = pdfField.getPDFFieldSignature().getSignature();
                return sig.getReason();
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getRevision() {
        return this.getRevision(true);
    }

    public Object getSigValue() {
        try {
            SignatureFieldPDF pdfField;
            PDFSignature sig;
            byte[] sigbyte;
            if (this.sigField.isSigned() && (sigbyte = (sig = (pdfField = this.sigField.getPDFField()).getPDFFieldSignature().getSignature()).getContents()) != null) {
                return ByteOps.getHexString(sigbyte);
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getStatus() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getStatus();
        }
        return Undefined.instance;
    }

    public Object getStatusText() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getStatusText();
        }
        return Undefined.instance;
    }

    public Object getSubFilter() {
        try {
            if (this.sigField.isSigned()) {
                SignatureFieldPDF pdfField = this.sigField.getPDFField();
                PDFSignature sig = pdfField.getPDFFieldSignature().getSignature();
                return sig.getSubFilterName();
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getVerifyDate() {
        Date verifyDate;
        if (this.jsSigInfo != null && (verifyDate = this.jsSigInfo.getVerifyDate()) != null) {
            return this.dateFormat.format(verifyDate);
        }
        return Undefined.instance;
    }

    public Object getVerifyHandlerName() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getVerifyHandlerName();
        }
        return Undefined.instance;
    }

    public Object getVerifyHandlerUIName() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getVerifyHandlerUIName();
        }
        return Undefined.instance;
    }

    public Object getCertificates() {
        byte[][] certList;
        if (this.jsSigInfo != null && (certList = this.jsSigInfo.getCertificates()) != null && certList.length > 0) {
            Scriptable scope = this.getParentScope();
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            for (int i = 0; i < certList.length; ++i) {
                Certificate cert = (Certificate)ESObject.create(this.getParentScope(), true, "Certificate", false, null);
                cert.setCertificate(certList[i]);
                certificates.add(cert);
            }
            return Context.getCurrentContext().newArray(scope, certificates.toArray());
        }
        return Undefined.instance;
    }

    public Object getContactInfo() {
        try {
            SignatureFieldPDF pdfField = this.sigField.getPDFField();
            PDFSignature sig = null;
            if (pdfField != null) {
                sig = pdfField.getPDFFieldSignature().getSignature();
            }
            if (sig != null) {
                return sig.getContactInfo();
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getByteRange() {
        try {
            if (this.sigField.isSigned()) {
                SignatureFieldPDF pdfField = this.sigField.getPDFField();
                PDFSignature sig = pdfField.getPDFFieldSignature().getSignature();
                long[] byterange = sig.getByteRanges();
                ArrayList<Long> byteRanges = new ArrayList<Long>();
                if (byterange != null && byterange.length > 0) {
                    Scriptable scope = this.getParentScope();
                    for (int i = 0; i < byterange.length; ++i) {
                        byteRanges.add(byterange[i]);
                    }
                    return Context.getCurrentContext().newArray(scope, byteRanges.toArray());
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public Object getDocValidity() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getDocValidity();
        }
        return Undefined.instance;
    }

    public Object getIdPrivValidity() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getIdPrivValidity();
        }
        return Undefined.instance;
    }

    public Object getIdValidity() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getIdValidity();
        }
        return Undefined.instance;
    }

    public Object getObjValidity() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getObjValidity();
        }
        return Undefined.instance;
    }

    public Object getRevInfo() {
        if (this.jsSigInfo != null) {
            return this.convertToHexEncoded(this.jsSigInfo.getRevInfo());
        }
        return Undefined.instance;
    }

    public Object getTrustFlags() {
        if (this.jsSigInfo != null) {
            return this.jsSigInfo.getTrustFlags();
        }
        return Undefined.instance;
    }

    private int getRevision(boolean isRevision) {
        try {
            PDFDocument pDocument = this.sigField.getPDFDocument();
            if (pDocument != null) {
                SignatureManager signatureManager = SignatureManager.newInstance(pDocument);
                Iterator<SignatureFieldInterface> iterator = signatureManager.getPDFSignatureFieldIterator();
                HashMap<SignatureFieldInterface, Long> signedSignatures = new HashMap<SignatureFieldInterface, Long>();
                while (iterator.hasNext()) {
                    SignatureFieldInterface sigField = iterator.next();
                    if (sigField == null || !sigField.isSigned()) continue;
                    signedSignatures.put(sigField, sigField.getPDFField().getPDFFieldSignature().getSignature().getCosObject().getObjEOF());
                }
                int numRevision = 0;
                int revision = 1;
                if (signedSignatures != null && signedSignatures.containsKey(this.sigField)) {
                    numRevision = signedSignatures.size();
                    if (numRevision > 0) {
                        Long pivot = (Long)signedSignatures.get(this.sigField);
                        boolean coversEntireDocument = false;
                        Set entrySet = signedSignatures.entrySet();
                        for (Map.Entry entry : entrySet) {
                            SignatureFieldInterface sField = (SignatureFieldInterface)entry.getKey();
                            if (sField != this.sigField && ((Long)entry.getValue()).compareTo(pivot) < 0) {
                                ++revision;
                            }
                            if (!sField.isSigned() || !SignatureUtils.coversEntireDocument(sField.getPDFField().getPDFFieldSignature().getSignature())) continue;
                            coversEntireDocument = true;
                        }
                        if (!coversEntireDocument) {
                            ++numRevision;
                        }
                    }
                    if (isRevision) {
                        return revision;
                    }
                    return numRevision;
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private Object convertToHexEncoded(JSRevocationInfo revocationInfo) {
        if (revocationInfo != null) {
            int i;
            byte[][] crlData = revocationInfo.getCRLData();
            byte[][] ocspResponses = revocationInfo.getOCSPResponses();
            RevocationInfo revInfo = (RevocationInfo)ESObject.create(this.getParentScope(), true, "RevocationInfo", false, null);
            if (crlData != null) {
                String[] crls = new String[crlData.length];
                for (i = 0; i < crlData.length; ++i) {
                    crls[i] = ByteOps.getHexString(crlData[i]);
                }
                revInfo.setCRLs(crls);
            }
            if (ocspResponses != null) {
                String[] ocsps = new String[ocspResponses.length];
                for (i = 0; i < ocspResponses.length; ++i) {
                    ocsps[i] = ByteOps.getHexString(ocspResponses[i]);
                }
                revInfo.setOCSPs(ocsps);
            }
            return revInfo;
        }
        return Undefined.instance;
    }

    public static class RevocationInfo
    extends ESObject {
        protected static final ScriptTable scriptTable = new ScriptTable("SignatureInfo.class", new HashMap<String, Function>(0){
            private static final long serialVersionUID = 1L;
        }, new HashMap<String, Property>(2){
            private static final long serialVersionUID = 1L;
            {
                this.put("CRL", new Property(RevocationInfo.class, "CRL", "getCRL", null, null, false, false));
                this.put("OCSP", new Property(RevocationInfo.class, "OCSP", "getOCSP", null, null, false, false));
            }
        });
        private static final long serialVersionUID = -7132585303844486362L;
        private static final String className = "RevocationInfo";
        private String[] crls = null;
        private String[] ocsps = null;

        @Override
        public Object get(String name, Scriptable start) {
            return super.get(name, start);
        }

        @Override
        protected ScriptTable getScriptTable() {
            return scriptTable;
        }

        @Override
        public String getClassName() {
            return className;
        }

        static RevocationInfo init(Context cx, Scriptable scope, boolean sealed) throws JavaScriptException {
            GibsonTopLevelScope topLevel = (GibsonTopLevelScope)scope;
            try {
                ScriptableObject.defineClass(topLevel, RevocationInfo.class);
                Scriptable event = cx.newObject(topLevel, className);
                topLevel.put(className, (Scriptable)topLevel, (Object)event);
                return (RevocationInfo)event;
            }
            catch (IllegalAccessException e) {
                throw new JavaScriptSecurityException(e);
            }
            catch (InstantiationException e) {
                throw new JavaScriptException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavaScriptException(e);
            }
        }

        public Object getCRL() {
            if (this.crls != null) {
                ArrayList<String> crl = new ArrayList<String>();
                crl.addAll(Arrays.asList(this.crls));
                Scriptable scope = this.getParentScope();
                Scriptable array = Context.getCurrentContext().newArray(scope, crl.toArray());
                return new Delegator(array){

                    @Override
                    public Object get(int index, Scriptable start) {
                        String[] crls = crls;
                        if (crls != null && crls.length > index) {
                            return crls[index];
                        }
                        return Undefined.instance;
                    }
                };
            }
            return Undefined.instance;
        }

        public void setCRLs(String[] crls) {
            this.crls = crls;
        }

        public Object getOCSP() {
            if (this.ocsps != null) {
                ArrayList<String> ocsp = new ArrayList<String>();
                ocsp.addAll(Arrays.asList(this.ocsps));
                Scriptable scope = this.getParentScope();
                Scriptable array = Context.getCurrentContext().newArray(scope, ocsp.toArray());
                return new Delegator(array){

                    @Override
                    public Object get(int index, Scriptable start) {
                        String[] ocsps = ocsps;
                        if (ocsps != null && ocsps.length > index) {
                            return ocsps[index];
                        }
                        return Undefined.instance;
                    }
                };
            }
            return Undefined.instance;
        }

        public void setOCSPs(String[] ocsps) {
            this.ocsps = ocsps;
        }
    }
}

