/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.interchange.structure;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCR;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.ArrayList;
import java.util.HashSet;

public class StructureFinder {
    private PDFStructureNode mStartNode;

    private StructureFinder(PDFStructureNode startNode) {
        this.mStartNode = startNode;
    }

    public static StructureFinder newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return StructureFinder.newInstance(pdfDoc.requireCatalog().getStructureRoot());
    }

    public static StructureFinder newInstance(PDFStructureNode structNode) {
        if (structNode == null) {
            return null;
        }
        return new StructureFinder(structNode);
    }

    public FinderIterator getIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new FinderIterator(null, this.mStartNode.getContent(), null);
    }

    public class FinderIterator {
        private FinderIterator mParentFinder;
        private FinderIterator mCurFinder;
        private PDFStructureContentIterator mCurIter;
        private PDFStructureElement mCurElement;
        private PDFStructureContentInterface mNextContent;
        private PDFPage mCurPage;
        private Entry mCurEntry = null;
        private Entry mEntry;
        private HashSet<Integer> visitedNodes;

        private FinderIterator(FinderIterator parentIter, PDFStructureContentInterface content, PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.mParentFinder = parentIter;
            this.mNextContent = null;
            this.mCurFinder = this;
            if (content != null) {
                this.mCurIter = content.contentIterator();
                PDFPage curPage = content.getPage();
                PDFPage pDFPage = this.mCurPage = curPage == null ? page : curPage;
                this.mCurElement = content instanceof PDFStructureElement ? (PDFStructureElement)content : (parentIter != null ? parentIter.mCurFinder.mCurElement : null);
            } else {
                this.mCurFinder = null;
            }
            this.visitedNodes = new HashSet();
        }

        private void setNextContent(PDFStructureContentInterface curContent, boolean isNextElement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (curContent instanceof PDFStructureElement) {
                this.mCurFinder.mCurElement = (PDFStructureElement)curContent;
                PDFPage curPage = ((PDFStructureElement)curContent).getPage();
                if (curPage != null) {
                    this.mCurFinder.mCurPage = curPage;
                }
                if (((PDFStructureElement)curContent).getActualText() != null) {
                    if (this.mCurEntry != null) {
                        this.mEntry = this.mCurEntry;
                        this.mCurFinder.mNextContent = curContent;
                    } else {
                        this.mEntry = new Entry((PDFStructureElement)curContent, this.mCurFinder.mCurPage, null);
                        this.mCurFinder.mNextContent = null;
                    }
                    return;
                }
            }
            if (curContent != null) {
                if (this.mCurEntry != null) {
                    this.mEntry = this.mCurEntry;
                    if (!isNextElement) {
                        this.mCurFinder.mNextContent = curContent;
                    }
                } else {
                    PDFStructureContentInterface content = ((PDFStructureNode)((Object)curContent)).getContent();
                    if (content == null) {
                        if (curContent instanceof PDFStructureElement) {
                            this.mEntry = new Entry((PDFStructureElement)curContent, this.mCurFinder.mCurPage, null);
                            this.mCurFinder.mNextContent = null;
                        } else if (curContent instanceof PDFStructureMCR) {
                            PDFPage contentPage = ((PDFStructureMCR)curContent).getPage();
                            if (contentPage != null) {
                                this.mCurFinder.mCurPage = contentPage;
                            }
                            this.mCurEntry = new Entry(this.mCurFinder.mCurElement, this.mCurFinder.mCurPage, ((PDFStructureMCR)curContent).getContentStream());
                            this.mCurEntry.addMCID(curContent);
                            this.mCurFinder.mNextContent = null;
                        } else {
                            throw new RuntimeException("Unknown content type");
                        }
                        return;
                    }
                    if (isNextElement) {
                        this.mCurFinder.mNextContent = null;
                    }
                    this.mCurFinder = curContent instanceof PDFStructureNode ? new FinderIterator(this.mCurFinder, content, this.mCurFinder.mCurPage) : null;
                }
            }
        }

        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.mCurFinder == null) {
                return false;
            }
            if (this.mEntry != null) {
                this.mCurEntry = null;
                return true;
            }
            if (this.mCurFinder.mNextContent != null) {
                this.setNextContent(this.mCurFinder.mNextContent, true);
            } else if (this.mCurFinder.mCurIter.hasNext()) {
                PDFStructureContentInterface curContent = this.mCurFinder.mCurIter.next();
                int objectID = curContent.getCosObject().getObjNum();
                if (curContent instanceof PDFStructureElement) {
                    if (!this.visitedNodes.contains(objectID)) {
                        this.visitedNodes.add(objectID);
                        this.setNextContent(curContent, false);
                    }
                } else {
                    if (this.mCurEntry == null) {
                        this.mCurEntry = new Entry(this.mCurFinder.mCurElement, this.mCurFinder.mCurPage, null);
                    }
                    if (!this.mCurEntry.addMCID(curContent)) {
                        this.mCurFinder.mNextContent = curContent;
                        this.mEntry = this.mCurEntry;
                    }
                }
            } else if (this.mCurEntry != null) {
                this.mEntry = this.mCurEntry;
            } else {
                this.mCurFinder = this.mCurFinder.mParentFinder;
                if (this.mCurFinder != null) {
                    this.visitedNodes.remove(this.mCurFinder.mCurElement.getCosObject().getObjNum());
                }
            }
            return this.hasNext();
        }

        public Entry next() {
            if (this.mEntry != null) {
                Entry nextEntry = this.mEntry;
                this.mEntry = null;
                return nextEntry;
            }
            throw new RuntimeException("next() is called without hasNext() returning true");
        }
    }

    public class Entry {
        private PDFPage mPage;
        private PDFContents mContents;
        private ArrayList mcids;
        private PDFStructureElement mElement;

        private Entry(PDFStructureElement element, PDFPage page, PDFContents contents) {
            this.mPage = page;
            this.mContents = contents;
            this.mElement = element;
            this.mcids = new ArrayList();
        }

        private boolean addMCID(PDFStructureContentInterface content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (content.getStructureType().contains(PDFStructureType.MCR)) {
                PDFPage contentPage = ((PDFStructureMCR)content).getPage();
                if (contentPage != null && contentPage != this.mPage) {
                    return false;
                }
                PDFContents streamContent = ((PDFStructureMCR)content).getContentStream();
                if (this.mContents != null && streamContent != null && streamContent != this.getContents()) {
                    return false;
                }
                if (streamContent != null) {
                    this.mContents = streamContent;
                }
                this.mcids.add(((PDFStructureMCR)content).getMCID());
            } else if (content.getStructureType().contains(PDFStructureType.MCID)) {
                this.mcids.add(((PDFStructureMCID)content).getMCID());
            }
            return true;
        }

        public PDFPage getPage() {
            return this.mPage;
        }

        public PDFContents getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.mContents != null) {
                return this.mContents;
            }
            if (this.mPage != null) {
                return this.mPage.getContents();
            }
            return null;
        }

        public PDFStructureElement getElement() {
            return this.mElement;
        }

        public Integer[] getMCIDs() {
            Integer[] mcIDs = new Integer[this.mcids.size()];
            mcIDs = this.mcids.toArray(mcIDs);
            return mcIDs;
        }
    }
}

