/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.Subset;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetterFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

class FontManager {
    private PDFDocument pdfDoc;
    private Map<PDFFont, TreeMap<Integer, Integer>> subsettedType1FontToCharCodesMap = new LinkedHashMap<PDFFont, TreeMap<Integer, Integer>>();
    private Map<PDFFont, TreeMap<Integer, Integer>> subsettedTrueTypeFontToCharCodesMap = new LinkedHashMap<PDFFont, TreeMap<Integer, Integer>>();
    private Map<PDFFont, TreeMap<Integer, Integer>> subsettedType0FontToCharCodesMap = new LinkedHashMap<PDFFont, TreeMap<Integer, Integer>>();
    private Map<Font, NonEmbeddedFontInfo> nonEmbeddedFontMap = new LinkedHashMap<Font, NonEmbeddedFontInfo>();
    private Map<Integer, Font> mFontDescObjNumToFontMap = new WeakHashMap<Integer, Font>();

    FontManager(PDFDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    void addMapping(Font afeFont, Subset subset, PDFFontType0 pdfFont) {
        this.nonEmbeddedFontMap.put(afeFont, new NonEmbeddedFontInfo(pdfFont, subset));
    }

    void addMapping(Font afeFont, TreeMap<Integer, byte[]> toUnicodeMappings) {
        if (this.hasMapping(afeFont) && toUnicodeMappings != null && !toUnicodeMappings.isEmpty()) {
            this.nonEmbeddedFontMap.get(afeFont).addToUnicodeMappings(toUnicodeMappings);
        }
    }

    boolean hasMapping(Font afeFont) {
        return this.nonEmbeddedFontMap.containsKey(afeFont);
    }

    Subset getSubsetFromCache(Font afeFont) {
        Subset subset = null;
        NonEmbeddedFontInfo element = this.nonEmbeddedFontMap.get(afeFont);
        if (element != null) {
            subset = element.getSubset();
        }
        return subset;
    }

    PDFFontType0 getPDFFontFromCache(Font afeFont) {
        PDFFontType0 pdfFont = null;
        NonEmbeddedFontInfo element = this.nonEmbeddedFontMap.get(afeFont);
        if (element != null) {
            pdfFont = element.getPDFFont();
        }
        return pdfFont;
    }

    void addMapping(PDFFont subsetFont, int charCode, int charCodeLength) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        Map<PDFFont, TreeMap<Integer, Integer>> fontMap = this.getMapForSubsettedFont(subsetFont);
        TreeMap<Integer, Integer> charCodes = fontMap.get(subsetFont);
        if (charCodes == null) {
            charCodes = new TreeMap();
            fontMap.put(subsetFont, charCodes);
        }
        charCodes.put(charCode, charCodeLength);
    }

    void finishFonts() throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        for (Font afeFont : this.nonEmbeddedFontMap.keySet()) {
            NonEmbeddedFontInfo element = this.nonEmbeddedFontMap.get(afeFont);
            Subset subset = element.getSubset();
            PDFFontType0 pdfFont = element.getPDFFont();
            try {
                FontResources.embedFont(pdfFont, afeFont, subset, element.getFontUnicodeMapping());
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
        this.nonEmbeddedFontMap.clear();
        FontSubsetter type1Subsetter = FontSubsetterFactory.getInstance(FontSubsetterFactory.FontType.TYPE1, this.pdfDoc, this.subsettedType1FontToCharCodesMap);
        type1Subsetter.createSubsets();
        this.subsettedType1FontToCharCodesMap.clear();
        FontSubsetter trueTypeSubsetter = FontSubsetterFactory.getInstance(FontSubsetterFactory.FontType.TRUETYPE, this.pdfDoc, this.subsettedTrueTypeFontToCharCodesMap);
        trueTypeSubsetter.createSubsets();
        this.subsettedTrueTypeFontToCharCodesMap.clear();
        FontSubsetter type0Subsetter = FontSubsetterFactory.getInstance(FontSubsetterFactory.FontType.TYPE0, this.pdfDoc, this.subsettedType0FontToCharCodesMap);
        type0Subsetter.createSubsets();
        this.subsettedType0FontToCharCodesMap.clear();
        this.mFontDescObjNumToFontMap.clear();
    }

    private Map<PDFFont, TreeMap<Integer, Integer>> getMapForSubsettedFont(PDFFont embeddedFont) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        Map<PDFFont, TreeMap<Integer, Integer>> fontMap = null;
        ASName fontSubType = embeddedFont.getSubtype();
        if (fontSubType == ASName.k_TrueType) {
            fontMap = this.subsettedTrueTypeFontToCharCodesMap;
        } else if (fontSubType == ASName.k_Type1) {
            fontMap = this.subsettedType1FontToCharCodesMap;
        } else if (fontSubType == ASName.k_Type0) {
            fontMap = this.subsettedType0FontToCharCodesMap;
        } else {
            throw new PDFInvalidParameterException("Invalid Font Type encountered : " + fontSubType);
        }
        return fontMap;
    }

    Font getAFEFontForFontDescriptor(int objNum) {
        return this.mFontDescObjNumToFontMap.get(objNum);
    }

    void putAFEFontForFontDescriptor(int objNum, Font afeFont) {
        this.mFontDescObjNumToFontMap.put(objNum, afeFont);
    }

    private static class NonEmbeddedFontInfo {
        private Subset mSubset;
        private PDFFontType0 mPdfFont;
        private TreeMap<Integer, byte[]> mToUnicodeMapping;

        NonEmbeddedFontInfo(PDFFontType0 pdfFont, Subset subset) {
            this.mSubset = subset;
            this.mPdfFont = pdfFont;
        }

        void addToUnicodeMappings(TreeMap<Integer, byte[]> toUnicodeMap) {
            if (this.mToUnicodeMapping == null) {
                this.mToUnicodeMapping = new TreeMap();
            }
            this.mToUnicodeMapping.putAll(toUnicodeMap);
        }

        TreeMap<Integer, byte[]> getFontUnicodeMapping() {
            return this.mToUnicodeMapping;
        }

        Subset getSubset() {
            return this.mSubset;
        }

        PDFFontType0 getPDFFont() {
            return this.mPdfFont;
        }
    }
}

