/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS1PacketBuilder;
import java.io.InputStream;

public class PKCS1Signer
extends Signer {
    RSAPKCS1PacketBuilder pkcs1PacketBuilder;
    AbstractDigester digester;

    public PKCS1Signer(CryptoContext ctx, AbstractDigester digester, RSAPKCS1PacketBuilder pkcs1PacketBuilder) {
        super(null, ctx);
        this.digester = digester;
        this.pkcs1PacketBuilder = pkcs1PacketBuilder;
    }

    @Override
    public int getSignatureSize() throws PDFSignatureException {
        int size = this.digester.getSize();
        byte[] dummyDigest = new byte[size];
        byte[] dummyPKCS7Bytes = this.pkcs1PacketBuilder.buildPacket(dummyDigest, this.cryptoContext, true);
        return dummyPKCS7Bytes.length + (this.cryptoContext.getSignatureAlgorithm().equalsIgnoreCase("DSA") ? 6 : 0);
    }

    @Override
    public byte[] sign(InputStream contents) throws PDFSignatureException {
        byte[] signatureBytes = null;
        try {
            this.digester.feedDataToDigester(contents);
            signatureBytes = this.digester.calculateDigest();
        }
        catch (PDFSignatureException e) {
            throw new PDFSignatureException("Error when creating message digest", e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("Error when copying inputByteStream to message digest", e);
        }
        return this.pkcs1PacketBuilder.buildPacket(signatureBytes, this.cryptoContext, false);
    }
}

