/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.HSMCredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class JSAFESignatureDigester
extends AbstractDigester {
    private JSAFE_Signature jsafeSignature;
    private JSAFE_PrivateKey privateKey;
    private String signatureAlgorithm;
    private RSACredentials credentials;

    public JSAFESignatureDigester(RSACredentials credentials, String digestAlgorithm, String signatureAlgorithm) throws PDFSignatureException {
        this.digestMethod = digestAlgorithm;
        this.credentials = credentials;
        this.signatureAlgorithm = signatureAlgorithm;
        this.initDigester();
    }

    @Override
    protected void initDigester() throws PDFSignatureException {
        try {
            if (this.credentials instanceof HSMCredentials) {
                this.jsafeSignature = this.createJSAFESignature(this.digestMethod, this.signatureAlgorithm, this.credentials);
                this.jsafeSignature.signInit(this.credentials.getJSAFEPrivateKey(), null, null, ((HSMCredentials)this.credentials).getSession());
                this.privateKey = this.credentials.getJSAFEPrivateKey();
            } else {
                this.privateKey = this.credentials.getJSAFEPrivateKey();
                this.jsafeSignature = this.createJSAFESignature(this.digestMethod, this.signatureAlgorithm, this.credentials);
                this.initJSAFESignature();
            }
        }
        catch (JSAFE_Exception e) {
            throw new PDFSignatureException("Could not initialize the JSAFE Signer.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFSignatureException("The algorithm supplied is unsupported", e);
        }
    }

    private JSAFE_Signature createJSAFESignature(String digestToApply, String signatureAlgorithm, Credentials credentials) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        String provider;
        String string = credentials instanceof RSACredentials ? "Java" : (provider = credentials instanceof HSMCredentials ? "PKCS11" : null);
        if (provider == null) {
            return null;
        }
        if (signatureAlgorithm.equalsIgnoreCase("RSA")) {
            return JSAFE_Signature.getInstance((String)(digestToApply + "/RSA/PKCS1Block01Pad"), (String)provider);
        }
        if (signatureAlgorithm.equalsIgnoreCase("DSA")) {
            return JSAFE_Signature.getInstance((String)"SHA1/DSA", (String)provider);
        }
        return null;
    }

    private void initJSAFESignature() throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, NoSuchAlgorithmException {
        if (this.signatureAlgorithm.equalsIgnoreCase("DSA")) {
            JSAFE_SecureRandom random = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
            random.seed(SecureRandom.getSeed(20));
            this.jsafeSignature.signInit(this.privateKey, (SecureRandom)random);
        } else {
            this.jsafeSignature.signInit(this.privateKey, null);
        }
    }

    public void reset() {
        try {
            this.jsafeSignature.signReInit();
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            // empty catch block
        }
    }

    @Override
    public byte[] calculateDigest() throws PDFSignatureException {
        try {
            return this.jsafeSignature.signFinal();
        }
        catch (JSAFE_Exception e) {
            throw new PDFSignatureException("There was an error computing the signature.", e);
        }
    }

    @Override
    public int getSize() throws PDFSignatureException {
        if (this.jsafeSignature != null) {
            return this.jsafeSignature.getSignatureSize();
        }
        return 0;
    }

    @Override
    public void feedDataToDigester(InputStream is) throws PDFIOException {
        byte[] chunk = new byte[8192];
        try {
            while (is.available() > 0) {
                int numBytesRead = is.read(chunk);
                this.jsafeSignature.signUpdate(chunk, 0, numBytesRead);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFIOException(e);
        }
        catch (JSAFE_InputException e) {
            throw new PDFIOException(e);
        }
    }
}

