/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.traverser.Traverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFLegalAttestation;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalAttestationDispatch;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseWarning;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalWarning;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalWarningDispatch;
import java.util.Map;
import java.util.TreeMap;

public class LegalScrubber {
    private PDFDocument pdfDoc;

    private LegalScrubber(PDFDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    public static LegalScrubber newInstance(PDFDocument pdfDoc) {
        return new LegalScrubber(pdfDoc);
    }

    public final PDFLegalAttestation generateLegalAttestation() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        Map legalWarnings = this.generatePDF16Warnings();
        return this.convertWarningsToDict(legalWarnings);
    }

    private PDFLegalAttestation convertWarningsToDict(Map legalWarnings) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFLegalAttestation attest = PDFLegalAttestation.newInstance(this.pdfDoc);
        for (Map.Entry entry : legalWarnings.entrySet()) {
            LegalBaseWarning category = (LegalBaseWarning)entry.getKey();
            ASName counterName = category.getValue();
            int counterValue = (Integer)entry.getValue();
            attest.setDictionaryIntValue(counterName, counterValue);
        }
        return attest;
    }

    private final Map generatePDF16Warnings() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        this.flushFontCache();
        TreeMap<LegalBaseWarning, Integer> legalWarnings = new TreeMap<LegalBaseWarning, Integer>();
        LegalAttestationDispatch legalPDF16Dispatch = new LegalAttestationDispatch(legalWarnings);
        Traverser legalPDF16Traverser = new Traverser(legalPDF16Dispatch);
        legalPDF16Traverser.traverseCosGraph(this.pdfDoc.getCosDocument().getRoot());
        return legalWarnings;
    }

    public final Map generateWarnings() throws PDFSecurityException, PDFIOException, PDFInvalidParameterException, PDFFontException {
        this.flushFontCache();
        TreeMap<LegalBaseWarning, Integer> legalWarnings = new TreeMap<LegalBaseWarning, Integer>();
        LegalWarningDispatch legalPDF17Dispatch = new LegalWarningDispatch(legalWarnings, true, true);
        Traverser legalPDF17Traverser = new Traverser(legalPDF17Dispatch);
        try {
            legalPDF17Traverser.traverseCosGraph(this.pdfDoc.getCosDocument().getRoot());
        }
        catch (PDFInvalidDocumentException e) {
            legalPDF17Dispatch.incrementCounter(LegalWarning.k_UnknownPDFContent);
        }
        return legalWarnings;
    }

    private void flushFontCache() {
        try {
            ((DocumentListenerRegistryBase)this.pdfDoc.getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, this.pdfDoc), true);
        }
        catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {
            // empty catch block
        }
    }
}

