/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneWithFunction;

public class PDFHalftoneType6
extends PDFHalftoneWithFunction {
    private PDFHalftoneType6(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFHalftoneType6 newInstance(PDFDocument pdfDocument, int key_Width, int key_Height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFHalftoneType6 pdfObject = new PDFHalftoneType6(cosObject);
        pdfObject.setHalftoneType(PDFHalfToneType.HALFTONE_TYPE6);
        pdfObject.setWidth(key_Width);
        pdfObject.setHeight(key_Height);
        return pdfObject;
    }

    public static PDFHalftoneType6 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFHalftoneType6 pdfObject = (PDFHalftoneType6)PDFCosObject.getCachedInstance(cosObject, PDFHalftoneType6.class);
        if (pdfObject == null) {
            pdfObject = new PDFHalftoneType6(cosObject);
        }
        return pdfObject;
    }

    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    public void setWidth(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, value);
    }

    public int requireWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Width);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Width.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width);
    }

    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    public void setHeight(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, value);
    }

    public int requireHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Height);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Height.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height);
    }
}

