/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaParams;

public class PDFRichMediaInstance
extends PDFCosDictionary {
    private PDFRichMediaInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaInstance newInstance(PDFDocument pdfDocument, ASName subtype, PDFFileSpecification asset) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (subtype == null || asset == null) {
            throw new PDFInvalidParameterException("Subtype and Asset are required.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaInstance pdfObject = new PDFRichMediaInstance(cosObject);
        pdfObject.setSubtype(subtype);
        pdfObject.setAsset(asset);
        return pdfObject;
    }

    public static PDFRichMediaInstance getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaInstance pdfObject = (PDFRichMediaInstance)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaInstance.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaInstance(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_RichMediaInstance)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + ASName.k_RichMediaInstance + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!(value.equals(ASName.k_3D) || value.equals(ASName.k_Flash) || value.equals(ASName.k_Sound) || value.equals(ASName.k_Video))) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_Subtype, value);
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public PDFRichMediaParams getParams() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_Params));
    }

    public void setParams(PDFRichMediaParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Params);
        } else {
            if (!this.getSubtype().equals(ASName.k_Flash)) {
                throw new PDFInvalidParameterException("Params is only valid for Subtype Flash.");
            }
            this.setDictionaryValue(ASName.k_Params, value);
        }
    }

    public boolean hasParams() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Params);
    }

    public PDFFileSpecification getAsset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_Asset));
    }

    public void setAsset(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Asset is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Asset, value);
    }

    public boolean hasAsset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Asset);
    }
}

