/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFRichMediaDeactivation
extends PDFCosDictionary {
    public static final ASName k_Condition = ASName.create("Condition");
    public static final ASName k_RichMediaDeactivation = ASName.create("RichMediaDeactivation");
    public static final ASName k_XD = ASName.create("XD");
    public static final ASName k_PC = ASName.create("PC");
    public static final ASName k_PI = ASName.create("PI");

    PDFRichMediaDeactivation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaDeactivation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaDeactivation pdfObject = new PDFRichMediaDeactivation(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaDeactivation getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaDeactivation pdfObject = (PDFRichMediaDeactivation)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaDeactivation.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaDeactivation(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaDeactivation)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + k_RichMediaDeactivation + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(k_Condition);
    }

    public void setCondition(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_Condition);
        } else if (value.equals(k_XD) || value.equals(k_PC) || value.equals(k_PI)) {
            this.setDictionaryNameValue(k_Condition, value);
        } else {
            throw new PDFInvalidParameterException("Condition value is out of bound.");
        }
    }

    public boolean hasCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Condition);
    }
}

