/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFBestEffortMCD;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClip;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaPermissions;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaPlayers;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMustHonorMCD;

public class PDFMediaClipData
extends PDFMediaClip {
    private PDFMediaClipData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaClipData newInstance(PDFDocument pdfDocument, ASName key_Subtype, PDFFileSpecification key_Data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Subtype == null) {
            throw new PDFInvalidParameterException("Subtype is required when creating newInstance of PDFMediaClipData.");
        }
        if (key_Data == null) {
            throw new PDFInvalidParameterException("Data is required when creating newInstance of PDFMediaClipData.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaClipData pdfObject = new PDFMediaClipData(cosObject);
        pdfObject.setSubtype(key_Subtype);
        pdfObject.setData(key_Data);
        return pdfObject;
    }

    public static PDFMediaClipData getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaClipData pdfObject = (PDFMediaClipData)PDFCosObject.getCachedInstance(cosObject, PDFMediaClipData.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaClipData(cosObject);
        }
        return pdfObject;
    }

    public PDFMediaPlayers getMediaPlayer() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayers.getInstance(this.getDictionaryCosObjectValue(ASName.k_PL));
    }

    public void setMediaPlayer(PDFMediaPlayers value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_PL, value);
    }

    public boolean hasMediaPlayer() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PL);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Type is a required key therefore cannot be removed.");
        }
        if (!value.equals(ASName.k_MediaClip)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
        this.setDictionaryNameValue(ASName.k_Type, value);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASString getContentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_CT);
    }

    public void setContentType(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_CT, value);
    }

    public void setContentType(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_CT, value);
    }

    public boolean hasContentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CT);
    }

    public PDFFileSpecification getDataAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_D));
    }

    public void setData(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_D, value);
    }

    public ASString getDataAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_D);
    }

    public void setData(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_D, value);
    }

    public void setData(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_D, value);
    }

    public CosStream getDataAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_D);
        if (cosObject instanceof CosStream) {
            return (CosStream)cosObject;
        }
        return null;
    }

    public void setData(CosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_D, value);
    }

    public boolean hasData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!value.equals(ASName.k_MCD)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFBestEffortMCD getBestEffortMCD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBestEffortMCD.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    public void setBestEffortMCD(PDFBestEffortMCD value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_BE, value);
    }

    public boolean hasBestEffortMCD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BE);
    }

    public CosArray getAlt() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Alt);
    }

    public void setAlt(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Alt, value);
    }

    public boolean hasAlt() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Alt);
    }

    public PDFMediaPermissions getMediaPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPermissions.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
    }

    public void setMediaPermissions(PDFMediaPermissions value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_P, value);
    }

    public boolean hasMediaPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_P);
    }

    public ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_N);
    }

    public void setName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_N, value);
    }

    public void setName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_N, value);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_N);
    }

    public PDFMustHonorMCD getMustHonorMCD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMustHonorMCD.getInstance(this.getDictionaryCosObjectValue(ASName.k_MH));
    }

    public void setMustHonorMCD(PDFMustHonorMCD value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_MH, value);
    }

    public boolean hasMustHonorMCD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MH);
    }
}

