/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.LinkedHashSet;

public class PDFStructureClassMap
extends PDFCosDictionary {
    private PDFStructureClassMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFStructureClassMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureClassMap pdfObject = (PDFStructureClassMap)PDFCosObject.getCachedInstance(cosObject, PDFStructureClassMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureClassMap(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureClassMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFStructureClassMap(cosObject);
    }

    public void addAttrClass(ASName attrClass, CosObject type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(attrClass, type);
    }

    public ASName getAttrClass(ASName attrClass) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(attrClass);
    }

    public LinkedHashSet collectAttributeClasses() {
        LinkedHashSet<ASName> attrClasses = new LinkedHashSet<ASName>(this.getCosDictionary().keySet());
        if (attrClasses.isEmpty()) {
            attrClasses = null;
        }
        return attrClasses;
    }
}

