/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFMetaDataInfo;

public class PDFThreadInfo
extends PDFMetaDataInfo {
    private PDFThreadInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFThreadInfo newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFThreadInfo(cosObject);
    }

    public static PDFThreadInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFThreadInfo pdfObject = (PDFThreadInfo)PDFCosObject.getCachedInstance(cosObject, PDFThreadInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFThreadInfo(cosObject);
        }
        return pdfObject;
    }

    public ASString get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return ((CosString)super.getDictionaryValue(name)).stringValue();
        }
        return null;
    }

    public void set(ASName name, ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(name, value);
    }
}

