/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithFringe;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;

public class PDFAnnotationSquare
extends PDFAnnotationMarkup
implements PDFAnnotationWithFringe,
PDFAnnotationWithBorderEffects {
    private PDFAnnotationSquare(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationSquare getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationSquare pdfObject = (PDFAnnotationSquare)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationSquare.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationSquare(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationSquare(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Square);
    }

    public static PDFAnnotationSquare newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationSquare(pdfDocument);
    }

    public boolean hasBorderEffect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BE);
    }

    public void setInteriorColor(double red, double green, double blue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationUtils.setInteriorColor(new double[]{red, green, blue}, this);
    }

    public double[] getInteriorColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationUtils.getInteriorColor(this);
    }

    @Override
    public double[] getFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationWithFringe.FringeGetterSetter.getFringe(this);
    }

    @Override
    public void setFringe(String fringe, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe, separator);
    }

    @Override
    public void setFringe(double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe);
    }

    @Override
    public boolean hasFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RD);
    }

    @Override
    public void transformFringe(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFringe(PDFAnnotationUtils.transformFringe(this, matrix, rotationAngle, this.getFringe()));
    }

    @Override
    public PDFBorderEffects getBorderEffects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBorderEffects.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    @Override
    public PDFBorderEffects procureBorderEffects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderEffects borderEffects = this.getBorderEffects();
        if (borderEffects == null) {
            borderEffects = PDFBorderEffects.newInstance(this.getPDFDocument());
        }
        return borderEffects;
    }

    @Override
    public void setBorderEffects(PDFBorderEffects borderEffects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_BE, borderEffects);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformFringe(matrix, rotationAngle);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedPopupRect = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

