/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;

public class PDFAnnotationProjection
extends PDFAnnotationMarkup {
    private PDFAnnotationProjection(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationProjection getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationProjection pdfObject = (PDFAnnotationProjection)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationProjection.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationProjection(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationProjection newInstance(PDFDocument pdfDocument, PDFRectangle location) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFAnnotationProjection pdfObject = PDFAnnotationProjection.newInstance(pdfDocument);
        pdfObject.setRect(location);
        return pdfObject;
    }

    private PDFAnnotationProjection(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Projection);
    }

    public static PDFAnnotationProjection newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFAnnotationProjection(pdfDocument);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

