/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithFringe;

public class PDFAnnotationCaret
extends PDFAnnotationMarkup
implements PDFAnnotationWithFringe {
    private PDFAnnotationCaret(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationCaret newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationCaret(pdfDoc);
    }

    private PDFAnnotationCaret(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Caret);
    }

    public static PDFAnnotationCaret getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationCaret pdfObject = (PDFAnnotationCaret)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationCaret.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationCaret(cosObject);
        }
        return pdfObject;
    }

    public boolean hasSymbol() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Sy);
    }

    public ASName getSymbol() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName result = ASName.k_None;
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Sy);
        if (obj instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setSymbol(ASName symbol) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Sy, symbol);
    }

    public String getDefaultAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_DA);
    }

    public void setDefaultAppearance(String appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, appearance);
    }

    public void setDefaultAppearance(String appearance, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, appearance, unicode);
    }

    @Override
    public double[] getFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationWithFringe.FringeGetterSetter.getFringe(this);
    }

    @Override
    public void setFringe(String fringe, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe, separator);
    }

    @Override
    public void setFringe(double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe);
    }

    @Override
    public boolean hasFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RD);
    }

    @Override
    public void transformFringe(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFringe(PDFAnnotationUtils.transformFringe(this, matrix, rotationAngle, this.getFringe()));
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformFringe(matrix, rotationAngle);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

