/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;

public class PDFActionOCG
extends PDFAction {
    private PDFActionOCG(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionOCG(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_OCG);
    }

    public static PDFActionOCG getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionOCG pdfObject = (PDFActionOCG)PDFCosObject.getCachedInstance(cosObject, PDFActionOCG.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionOCG(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionOCG newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFActionOCG(pdfDocument);
    }
}

