/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFJSDebuggerConsoleState;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFPredominantReadingOrder;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFPrintScaling;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFPrintingPaperHandling;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageBoundary;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageMode;

public class PDFViewerPreferences
extends PDFCosDictionary {
    public static final ASName k_PrintScaling = ASName.create("PrintScaling");
    protected static final ASName k_Duplex = ASName.create("Duplex");
    protected static final ASName k_PickTrayByPDFSize = ASName.create("PickTrayByPDFSize");
    protected static final ASName k_PrintPageRange = ASName.create("PrintPageRange");
    protected static final ASName k_NumCopies = ASName.create("NumCopies");
    protected static final ASName k_Rights = ASName.create("Rights");
    protected static final ASName k_Enforce = ASName.create("Enforce");
    protected static final ASName k_ADBE_JSDebugger = ASName.create("ADBE_JSDebugger");
    protected static final ASName k_ADBE_JSConsole = ASName.create("ADBE_JSConsole");
    public static final ASName k_Enable = ASName.create("Enable");
    public static final ASName k_Disable = ASName.create("Disable");
    public static final ASName k_Delegate = ASName.create("Delegate");

    private PDFViewerPreferences(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFViewerPreferences getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFViewerPreferences pdfObject = (PDFViewerPreferences)PDFCosObject.getCachedInstance(cosObject, PDFViewerPreferences.class);
        if (pdfObject == null) {
            pdfObject = new PDFViewerPreferences(cosObject);
        }
        return pdfObject;
    }

    public static PDFViewerPreferences newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFViewerPreferences(cosObject);
    }

    public void setHideToolbar(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_HideToolbar, on);
    }

    public boolean getHideToolbar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_HideToolbar)) {
            return this.getDictionaryBooleanValue(ASName.k_HideToolbar);
        }
        return false;
    }

    public void setHideMenubar(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_HideMenubar, on);
    }

    public boolean getHideMenubar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_HideMenubar)) {
            return this.getDictionaryBooleanValue(ASName.k_HideMenubar);
        }
        return false;
    }

    public void setHideWindowUI(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_HideWindowUI, on);
    }

    public boolean getHideWindowUI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_HideWindowUI)) {
            return this.getDictionaryBooleanValue(ASName.k_HideWindowUI);
        }
        return false;
    }

    public void setFitWindow(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_FitWindow, on);
    }

    public boolean getFitWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_FitWindow)) {
            return this.getDictionaryBooleanValue(ASName.k_FitWindow);
        }
        return false;
    }

    public void setCenterWindow(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_CenterWindow, on);
    }

    public boolean getCenterWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_CenterWindow)) {
            return this.getDictionaryBooleanValue(ASName.k_CenterWindow);
        }
        return false;
    }

    public void setDisplayDocTitle(boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_DisplayDocTitle, on);
    }

    public boolean getDisplayDocTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_DisplayDocTitle)) {
            return this.getDictionaryBooleanValue(ASName.k_DisplayDocTitle);
        }
        return false;
    }

    public void setPageMode(PDFPageMode pageMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_NonFullScreenPageMode, pageMode);
    }

    public PDFPageMode getPageMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageMode mode = PDFPageMode.getInstance(this.getDictionaryNameValue(ASName.k_NonFullScreenPageMode));
        if (mode == null) {
            return PDFPageMode.PagesOnly;
        }
        return mode;
    }

    public void setDirection(PDFPredominantReadingOrder direction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Direction, direction);
    }

    public PDFPredominantReadingOrder getDirection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPredominantReadingOrder order = PDFPredominantReadingOrder.getInstance(this.getDictionaryNameValue(ASName.k_Direction));
        if (order == null) {
            return PDFPredominantReadingOrder.LeftToRight;
        }
        return order;
    }

    public void setViewArea(PDFPageBoundary viewArea) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_ViewArea, viewArea);
    }

    public PDFPageBoundary getViewArea() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageBoundary boundary = PDFPageBoundary.getInstance(this.getDictionaryNameValue(ASName.k_ViewArea));
        if (boundary == null) {
            return PDFPageBoundary.CropBox;
        }
        return boundary;
    }

    public void setViewClip(PDFPageBoundary viewClip) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_ViewClip, viewClip);
    }

    public PDFPageBoundary getViewClip() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageBoundary boundary = PDFPageBoundary.getInstance(this.getDictionaryNameValue(ASName.k_ViewClip));
        if (boundary == null) {
            return PDFPageBoundary.CropBox;
        }
        return boundary;
    }

    public void setPrintArea(PDFPageBoundary printArea) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_PrintArea, printArea);
    }

    public PDFPageBoundary getPrintArea() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageBoundary boundary = PDFPageBoundary.getInstance(this.getDictionaryNameValue(ASName.k_PrintArea));
        if (boundary == null) {
            return PDFPageBoundary.CropBox;
        }
        return boundary;
    }

    public void setPrintClip(PDFPageBoundary printClip) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_PrintClip, printClip);
    }

    public PDFPageBoundary getPrintClip() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageBoundary boundary = PDFPageBoundary.getInstance(this.getDictionaryNameValue(ASName.k_PrintClip));
        if (boundary == null) {
            return PDFPageBoundary.CropBox;
        }
        return boundary;
    }

    public void setPrintScaling(PDFPrintScaling printScaling) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_PrintScaling, printScaling);
    }

    public PDFPrintScaling getPrintScaling() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPrintScaling scaling = PDFPrintScaling.getInstance(this.getDictionaryNameValue(k_PrintScaling));
        if (scaling == null) {
            return PDFPrintScaling.AppDefault;
        }
        return scaling;
    }

    public void setEnforce(ASName[] entries) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (entries == null || entries.length == 0) {
            if (this.dictionaryContains(k_Enforce)) {
                this.removeValue(k_Enforce);
            }
            return;
        }
        CosArray cosEntries = PDFCosObject.newCosArray(this.getPDFDocument());
        for (int i = 0; i < entries.length; ++i) {
            ASName printScaling;
            if (entries[i] != k_PrintScaling || !this.dictionaryContains(k_PrintScaling) || (printScaling = this.getDictionaryNameValue(k_PrintScaling)) == PDFPrintScaling.AppDefault.getName()) continue;
            CosName cosName = PDFCosObject.newCosName(this.getPDFDocument(), k_PrintScaling);
            cosEntries.add(cosName);
        }
        this.setDictionaryArrayValue(k_Enforce, cosEntries);
    }

    public ASName[] getEnforce() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosEnforce = this.getDictionaryArrayValue(k_Enforce);
        ASName[] namesEnforced = null;
        if (cosEnforce != null && cosEnforce.size() > 0) {
            namesEnforced = new ASName[cosEnforce.size()];
            for (int i = 0; i < cosEnforce.size(); ++i) {
                namesEnforced[i] = cosEnforce.getName(i);
            }
        }
        return namesEnforced;
    }

    public void setDuplex(PDFPrintingPaperHandling paperHandling) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_Duplex, paperHandling);
    }

    public PDFPrintingPaperHandling getDuplex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPrintingPaperHandling.getInstance(this.getDictionaryNameValue(k_Duplex));
    }

    public void setPickTrayByPDFSize(Boolean on) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_PickTrayByPDFSize, on);
    }

    public boolean getPickTrayByPDFSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_PickTrayByPDFSize)) {
            return this.getDictionaryBooleanValue(k_PickTrayByPDFSize);
        }
        return false;
    }

    public void setPrintPageRange(int[] pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pages != null) {
            if (pages.length % 2 != 0) {
                throw new PDFInvalidParameterException("Array of page numbers must contain an even number");
            }
            for (int i = 0; i < pages.length; ++i) {
                if (pages[i] >= 0) continue;
                throw new PDFInvalidParameterException("A negative page number in the array.");
            }
        }
        this.setDictionaryArrayValue(k_PrintPageRange, pages);
    }

    public int[] getPrintPageRange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_PrintPageRange)) {
            CosArray pages = this.getDictionaryArrayValue(k_PrintPageRange);
            return pages.getArrayInt();
        }
        return null;
    }

    public void setNumCopies(Long copies) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (copies == null) {
            this.removeValue(k_NumCopies);
        } else {
            this.setDictionaryIntValue(k_NumCopies, copies);
        }
    }

    public int getNumCopies() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_NumCopies)) {
            return this.getDictionaryIntValue(k_NumCopies);
        }
        return 1;
    }

    public PDFJSDebuggerConsoleState getPDFJSDebuggerState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_ADBE_JSDebugger)) {
            ASName stateName = this.getDictionaryNameValue(k_ADBE_JSDebugger);
            PDFJSDebuggerConsoleState state = PDFJSDebuggerConsoleState.getInstance(stateName);
            if (state == null) {
                throw new PDFInvalidDocumentException("Invalid Value of JS Debugger present in Viewer Preferences Dictionary, invalid Value :" + stateName);
            }
            return state;
        }
        return PDFJSDebuggerConsoleState.Delegate;
    }

    public void setPDFJSDebuggerState(PDFJSDebuggerConsoleState state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName stateName = state == null ? null : state.getName();
        this.setDictionaryNameValue(k_ADBE_JSDebugger, stateName);
    }

    public PDFJSDebuggerConsoleState getPDFJSConsoleState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_ADBE_JSConsole)) {
            ASName stateName = this.getDictionaryNameValue(k_ADBE_JSConsole);
            PDFJSDebuggerConsoleState state = PDFJSDebuggerConsoleState.getInstance(stateName);
            if (state == null) {
                throw new PDFInvalidDocumentException("Invalid Value of JS Console present in Viewer Preferences Dictionary, invalid Value :" + stateName);
            }
            return state;
        }
        return PDFJSDebuggerConsoleState.Delegate;
    }

    public void setPDFJSConsoleState(PDFJSDebuggerConsoleState state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName stateName = state == null ? null : state.getName();
        this.setDictionaryNameValue(k_ADBE_JSConsole, stateName);
    }

    public CosDictionary getRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(k_Rights);
    }

    public void removeRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(k_Rights);
    }
}

