/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;

public class PDFOCProperties
extends PDFCosDictionary {
    protected PDFOCProperties(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCProperties getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCProperties pdfObject = (PDFOCProperties)PDFCosObject.getCachedInstance(cosObject, PDFOCProperties.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCProperties(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCProperties newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCProperties propDict = new PDFOCProperties(PDFCosObject.newCosDictionary(pdfDocument));
        propDict.setDictionaryArrayValue(ASName.k_OCGs, PDFCosObject.newCosArray(pdfDocument));
        PDFOCConfig defaultConfigDict = PDFOCConfig.defaultInstance(pdfDocument);
        propDict.setDictionaryValue(ASName.k_D, defaultConfigDict);
        return propDict;
    }

    public PDFOCGroupArray getOCGs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject ocgsObj = this.getDictionaryCosObjectValue(ASName.k_OCGs);
        return PDFOCGroupArray.getInstance(ocgsObj);
    }

    private void setOCGs(PDFOCGroupArray ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OCGs, ocgs);
    }

    public void addOCG(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray ocgList = this.getOCGs();
        if (ocgList == null) {
            ocgList = PDFOCGroupArray.newInstance(this.getPDFDocument());
            this.setOCGs(ocgList);
        }
        if (!ocgList.contains(ocg)) {
            ocgList.add(ocg);
        }
    }

    public boolean containsOCG(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray ocgList = this.getOCGs();
        if (ocgList == null) {
            return false;
        }
        return ocgList.getOCGByName(name) != null;
    }

    public void setDefaultOCConfigDict(PDFOCConfig configDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, configDict);
    }

    public PDFOCConfig getDefaultOCConfigDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dict = this.getDictionaryDictionaryValue(ASName.k_D);
        return PDFOCConfig.getInstance(dict);
    }

    public void setOCConfigsArray(PDFOCConfigList dictList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dictList == null) {
            this.removeValue(ASName.k_Configs);
        } else {
            this.setDictionaryArrayValue(ASName.k_Configs, dictList.getCosArray());
        }
    }

    public PDFOCConfigList getOCConfigsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray configs = this.getDictionaryArrayValue(ASName.k_Configs);
        return PDFOCConfigList.getInstance(configs);
    }

    public void addConfigDictToList(PDFOCConfig configDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (configDict == null) {
            return;
        }
        PDFOCConfigList cdList = this.getOCConfigsArray();
        if (cdList == null) {
            cdList = PDFOCConfigList.newInstance(this.getPDFDocument());
            this.setOCConfigsArray(cdList);
        }
        if (!cdList.contains(configDict)) {
            cdList.add(configDict);
        }
    }
}

