/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.Iterator;

public class PDFOCIntentList
extends PDFCosObject {
    private PDFOCIntentList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCIntentList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCIntentList pdfObject = (PDFOCIntentList)PDFCosObject.getCachedInstance(cosObject, PDFOCIntentList.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCIntentList(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCIntentList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCIntentList(cosObject);
    }

    public static PDFOCIntentList newInstance(PDFDocument pdfDocument, ASName intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFOCIntentList pdfObject = new PDFOCIntentList(cosObject);
        pdfObject.add(intent);
        return pdfObject;
    }

    private void add(ASName intent) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException {
        CosObject currentCosObj = this.getCosObject();
        if (!(currentCosObj instanceof CosArray)) {
            throw new PDFInvalidParameterException("Illegal attempt to add an intent name to a single Intent name rather than an Intent array.");
        }
        ((CosArray)currentCosObj).addName(intent);
    }

    public Iterator iterator() {
        return new IntentIterator(this.getCosObject());
    }

    public boolean contains(ASName intent) {
        boolean result = false;
        CosObject myObj = this.getCosObject();
        if (myObj instanceof CosName) {
            result = ((CosName)myObj).nameValue().equals(intent);
        } else if (myObj instanceof CosArray) {
            Iterator iter = this.iterator();
            boolean iterResult = false;
            while (iter.hasNext()) {
                ASName objName = (ASName)iter.next();
                if (objName == null || !objName.equals(intent)) continue;
                iterResult = true;
                break;
            }
            result = iterResult;
        }
        return result;
    }

    static class IntentIterator
    implements Iterator {
        private CosObject mNextObj = null;
        private int mType;
        private Iterator mIterator = null;
        private static final int ARRAY = 1;
        private static final int NAME = 2;

        IntentIterator(CosObject cosObject) {
            if (cosObject instanceof CosArray) {
                this.mIterator = ((CosArray)cosObject).iterator();
                this.mType = 1;
            } else if (cosObject instanceof CosName) {
                this.mNextObj = cosObject;
                this.mType = 2;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (this.mType == 1) {
                result = this.mIterator.hasNext();
            } else if (this.mType == 2) {
                result = this.mNextObj != null;
            }
            return result;
        }

        public Object next() {
            ASName result = null;
            if (this.mType == 1) {
                CosName resultObj = (CosName)this.mIterator.next();
                result = resultObj.nameValue();
            } else if (this.mType == 2) {
                CosName obj = (CosName)this.mNextObj;
                this.mNextObj = null;
                result = obj.nameValue();
            }
            return result;
        }
    }
}

