/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ExtendedPostScriptToken;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ExtendedPostScriptTokenManager;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ParseException;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptCalculatorConstants;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptCalculatorTokenManager;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptStack;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.SimpleCharStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class PostScriptCalculator
implements PostScriptCalculatorConstants {
    private PostScriptStack<Double> stack;
    private PostScriptStack<Boolean> flags = new PostScriptStack();
    private PostScriptStack<Integer> expressionCheck = new PostScriptStack();
    private Boolean isEvaluate = true;
    public PostScriptCalculatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public PostScriptStack<Double> evaluate(PostScriptStack<Double> inputData) throws PDFInvalidDocumentException {
        this.stack = inputData;
        this.isEvaluate = true;
        try {
            this.parse();
            if (!this.expressionCheck.isEmpty()) {
                throw new PDFInvalidDocumentException("Equation of function type 4 is incorrect");
            }
        }
        catch (Exception e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.jj_nt = ((ExtendedPostScriptTokenManager)this.token_source).getFirstToken();
        return this.stack;
    }

    public final void parse() throws ParseException {
        double value = 0.0;
        this.expr();
        while (!this.expressionCheck.isEmpty()) {
            this.term();
        }
    }

    public final void expr() throws ParseException {
        double x = 0.0;
        double y = 0.0;
        this.term();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(54);
        }
        this.term();
    }

    public final void term() throws ParseException {
        block41: {
            double x = 0.0;
            double y = 0.0;
            this.value();
            block26: while (true) {
                switch (this.jj_nt.kind) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 24: 
                    case 25: 
                    case 28: 
                    case 29: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block41;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 9: {
                        this.jj_consume_token(9);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(x + y);
                        continue block26;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(y - x);
                        continue block26;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(x * y);
                        continue block26;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        if (x == 0.0) {
                            throw new ParseException("Attempt to divide by zero");
                        }
                        this.stack.push(y / x);
                        continue block26;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        int a = (int)x;
                        int b = (int)y;
                        if (a == 0) {
                            throw new ParseException("Attempt to Divide by zero");
                        }
                        this.stack.push(new Double(b / a));
                        continue block26;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        if (x == 0.0) {
                            throw new ParseException("Attempt to Divide by zero");
                        }
                        this.stack.push(y % x);
                        continue block26;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(Math.atan(y / x));
                        continue block26;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(Math.pow(y, x));
                        continue block26;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        this.flags.push(true);
                        continue block26;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        this.flags.push(false);
                        continue block26;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        this.expressionCheck.push(1);
                        if (this.flags.isEmpty()) continue block26;
                        this.isEvaluate = this.flags.pop();
                        continue block26;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        this.expressionCheck.pop();
                        if (this.isEvaluate.booleanValue()) {
                            this.isEvaluate = false;
                            continue block26;
                        }
                        this.isEvaluate = true;
                        continue block26;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        x = this.stack.pop();
                        y = this.stack.pop();
                        this.stack.push(x);
                        this.stack.push(y);
                        continue block26;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        this.isEvaluate = true;
                        continue block26;
                    }
                    case 44: {
                        this.jj_consume_token(44);
                        this.isEvaluate = true;
                        continue block26;
                    }
                    case 50: {
                        int i;
                        this.jj_consume_token(50);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        double value = this.stack.pop();
                        double elements = this.stack.pop();
                        int j = (int)value;
                        int n = (int)elements;
                        int k = 0;
                        if ((j %= n) < 0) {
                            j -= 2 * j;
                            k = j;
                        } else {
                            k = n - j;
                        }
                        double[] copyArray = new double[n];
                        if (j == 0) continue block26;
                        for (i = 1; i <= n; ++i) {
                            copyArray[n - i] = this.stack.pop();
                        }
                        i = 0;
                        while (true) {
                            if (i >= n) continue block26;
                            if (k == n) {
                                k = 0;
                            }
                            this.stack.push(copyArray[k]);
                            ++i;
                            ++k;
                        }
                    }
                    case 49: {
                        int i;
                        this.jj_consume_token(49);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        double value = this.stack.pop();
                        int element = (int)value + 1;
                        double[] copyArray = new double[element];
                        for (i = 1; i <= element; ++i) {
                            copyArray[element - i] = this.stack.pop();
                        }
                        for (i = 0; i < element; ++i) {
                            this.stack.push(copyArray[i]);
                        }
                        this.stack.push(copyArray[0]);
                        continue block26;
                    }
                    case 48: {
                        int i;
                        this.jj_consume_token(48);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        double value = this.stack.pop();
                        int element = GraphicsUtils.rint(value);
                        double[] copyArray = new double[element];
                        for (i = 1; i <= element; ++i) {
                            copyArray[element - i] = this.stack.pop();
                        }
                        int k = 0;
                        int i2 = 0;
                        while (true) {
                            if (i2 >= element * 2) continue block26;
                            if (i2 == element) {
                                k = 0;
                            }
                            this.stack.push(copyArray[k]);
                            ++i2;
                            ++k;
                        }
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        double value = this.stack.pop();
                        this.stack.push(Double.valueOf((int)value));
                        continue block26;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        continue block26;
                    }
                    case 45: {
                        this.jj_consume_token(45);
                        if (!this.isEvaluate.booleanValue()) continue block26;
                        this.stack.pop();
                        continue block26;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.value();
    }

    public final void value() throws ParseException {
        double value = 0.0;
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                if (!this.isEvaluate.booleanValue()) break;
                value = this.stack.pop();
                this.stack.push(-value);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.sin(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.cos(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.abs(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.ceil(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.floor(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.round(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                if (!this.isEvaluate.booleanValue()) break;
                value = this.stack.pop();
                this.stack.push(Double.valueOf((int)value));
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.sqrt(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.log(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                if (!this.isEvaluate.booleanValue()) break;
                value = Math.log10(this.stack.pop());
                this.stack.push(value);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                if (!this.isEvaluate.booleanValue()) break;
                value = this.stack.pop();
                this.stack.push(value);
                this.stack.push(value);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                if (!this.isEvaluate.booleanValue()) break;
                Double x = new Double(this.stack.pop());
                Double y = new Double(this.stack.pop());
                this.flags.push(x.equals(y));
                break;
            }
            case 31: {
                Double y;
                this.jj_consume_token(31);
                if (!this.isEvaluate.booleanValue()) break;
                Double x = new Double(this.stack.pop());
                this.flags.push(!x.equals(y = new Double(this.stack.pop())));
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                if (!this.isEvaluate.booleanValue()) break;
                Double y = new Double(this.stack.pop());
                Double x = new Double(this.stack.pop());
                this.flags.push(x > y);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                if (!this.isEvaluate.booleanValue()) break;
                Double y = new Double(this.stack.pop());
                Double x = new Double(this.stack.pop());
                this.flags.push(x >= y);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                if (!this.isEvaluate.booleanValue()) break;
                Double y = new Double(this.stack.pop());
                Double x = new Double(this.stack.pop());
                this.flags.push(x < y);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                if (!this.isEvaluate.booleanValue()) break;
                Double y = new Double(this.stack.pop());
                Double x = new Double(this.stack.pop());
                this.flags.push(x <= y);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                if (!this.isEvaluate.booleanValue()) break;
                if (this.flags.isEmpty()) {
                    double x = this.stack.pop();
                    double y = this.stack.pop();
                    int a = (int)x;
                    int b = (int)y;
                    int c = a | b;
                    this.stack.push(new Double(c));
                    break;
                }
                boolean flag1 = this.flags.pop();
                boolean flag2 = this.flags.pop();
                this.flags.push(flag1 | flag2);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                if (!this.isEvaluate.booleanValue()) break;
                if (this.flags.isEmpty()) {
                    double x = this.stack.pop();
                    double y = this.stack.pop();
                    int a = (int)x;
                    int b = (int)y;
                    int c = a & b;
                    this.stack.push(new Double(c));
                    break;
                }
                boolean flag1 = this.flags.pop();
                boolean flag2 = this.flags.pop();
                this.flags.push(flag1 & flag2);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                if (!this.isEvaluate.booleanValue()) break;
                if (this.flags.isEmpty()) {
                    double x = this.stack.pop();
                    double y = this.stack.pop();
                    int a = (int)x;
                    int b = (int)y;
                    int c = a ^ b;
                    this.stack.push(new Double(c));
                    break;
                }
                boolean flag1 = this.flags.pop();
                boolean flag2 = this.flags.pop();
                this.flags.push(flag1 ^ flag2);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                if (!this.isEvaluate.booleanValue()) break;
                if (this.flags.isEmpty()) {
                    double x = this.stack.pop();
                    int a = (int)x;
                    int b = ~a;
                    this.stack.push(new Double(b));
                    break;
                }
                boolean flag = this.flags.pop();
                this.flags.push(!flag);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                if (!this.isEvaluate.booleanValue()) break;
                value = this.stack.pop();
                int shift = (int)value;
                double temp = this.stack.pop();
                int op = (int)temp;
                int result = 0;
                if (shift < 0) {
                    shift = -shift;
                    result = op >> shift;
                } else {
                    result = op << shift;
                }
                this.stack.push(new Double(result));
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.number();
            }
        }
    }

    public final void number() throws ParseException {
        switch (this.jj_nt.kind) {
            case 53: {
                Token t = this.jj_consume_token(53);
                Double value = ((ExtendedPostScriptToken)t).getDoubleValue();
                if (!this.isEvaluate.booleanValue()) break;
                this.stack.push(value);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 855670272, 855670272, -855670784, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x400000, 2063872, 2063872, 33279, 0x200000};
    }

    public PostScriptCalculator(InputStream stream) {
        this(stream, null);
    }

    public PostScriptCalculator(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PostScriptCalculatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PostScriptCalculator(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PostScriptCalculatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PostScriptCalculator(PostScriptCalculatorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(PostScriptCalculatorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[55];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 5; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 55; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        PostScriptCalculator.jj_la1_init_0();
        PostScriptCalculator.jj_la1_init_1();
    }
}

