/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType2;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType4;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionTypeUnknown;

public class PDFFunctionFactory {
    public static PDFFunction getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("cosObject is not an itnstance of CosDictionary which was expected. Object Number =" + cosObject.getObjNum());
        }
        CosDictionary cosDict = (CosDictionary)cosObject;
        if (cosDict.containsKey(ASName.k_FunctionType)) {
            int functionType = cosDict.getInt(ASName.k_FunctionType);
            switch (functionType) {
                case 0: {
                    return PDFFunctionType0.getInstance(cosObject);
                }
                case 2: {
                    return PDFFunctionType2.getInstance(cosObject);
                }
                case 3: {
                    return PDFFunctionType3.getInstance(cosObject);
                }
                case 4: {
                    return PDFFunctionType4.getInstance(cosObject);
                }
            }
            return PDFFunctionTypeUnknown.getInstance(cosObject);
        }
        return PDFFunctionTypeUnknown.getInstance(cosObject);
    }
}

