/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class PDFContents
extends PDFCosObject {
    private PDFContents(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFContents getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFContents pdfObject = (PDFContents)PDFCosObject.getCachedInstance(cosObject, PDFContents.class);
        if (pdfObject == null) {
            pdfObject = new PDFContents(cosObject);
        }
        return pdfObject;
    }

    public static PDFContents newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        return new PDFContents(cosObject);
    }

    public static PDFContents newInstanceArray(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFContents(cosObject);
    }

    public InputByteStream getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.getCosObject() instanceof CosStream) {
                return this.getCosStream().getStreamDecoded();
            }
            if (this.getCosObject() instanceof CosArray) {
                InputByteStream[] ibsArray = this.getStreamsFromCosArray(this.getCosArray());
                return this.getStreamManager().getInputByteStream(ibsArray);
            }
            throw new PDFInvalidContentException("PDFContents should either be a content stream or an array of content streams.");
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean hasContents() {
        return this.getCosObject() instanceof CosStream || this.getCosObject() instanceof CosArray;
    }

    private InputByteStream[] getStreamsFromCosArray(CosArray cosArray) throws PDFIOException {
        try {
            if (cosArray == null) {
                return null;
            }
            ArrayList<InputByteStream> tempByteStreamList = new ArrayList<InputByteStream>();
            for (int i = 0; i < cosArray.size(); ++i) {
                try {
                    if (i > 0) {
                        InputByteStream lastStream = (InputByteStream)tempByteStreamList.get(tempByteStreamList.size() - 1);
                        lastStream.seek(lastStream.length() - 1L);
                        int c = lastStream.read();
                        if (c != 48 && c != 10) {
                            byte[] endArr = new byte[]{10};
                            InputByteStream endstream = this.getStreamManager().getInputByteStream(endArr);
                            tempByteStreamList.add(endstream);
                        }
                    }
                    tempByteStreamList.add(cosArray.getStream(i));
                    continue;
                }
                catch (PDFException e) {
                    throw new PDFIOException("Error with Cos Array (" + e.getMessage() + ").", e);
                }
            }
            InputByteStream[] finalByteStreams = new InputByteStream[tempByteStreamList.size()];
            for (int k = 0; k < finalByteStreams.length; ++k) {
                if (tempByteStreamList.get(k) == null) continue;
                finalByteStreams[k] = (InputByteStream)tempByteStreamList.get(k);
            }
            return finalByteStreams;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void appendStream(InputByteStream contents, CosStream cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        InputByteStream istream = cosStream.getStreamDecoded();
        if (istream == null || istream.length() == 0L) {
            if (istream != null) {
                istream.close();
            }
            cosStream.newDataDecoded(contents);
            return;
        }
        OutputByteStream outputStream = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, istream.length());
        IO.copy(istream, outputStream);
        outputStream.write(13);
        IO.copy(contents, outputStream);
        InputByteStream newStream = outputStream.closeAndConvert();
        outputStream = null;
        cosStream.newDataDecoded(newStream);
        newStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prependStream(InputByteStream contents, CosStream cosStream) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        InputByteStream istream = null;
        try {
            istream = cosStream.getStreamDecoded();
        }
        catch (Exception e) {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new PDFIOException(e);
        }
        if (istream == null || istream.length() == 0L) {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException e) {
                try {
                    if (contents != null) {
                        contents.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            cosStream.newDataDecoded(contents);
            return;
        }
        OutputByteStream outputStream = null;
        try {
            outputStream = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            IO.copy(contents, outputStream);
            IO.copy(istream, outputStream);
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            finally {
                if (istream != null) {
                    istream.close();
                }
            }
        }
        istream = null;
        InputByteStream newStream = outputStream.closeAndConvert();
        outputStream = null;
        cosStream.newDataDecoded(newStream);
        newStream = null;
    }

    public void addContents(InputByteStream contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (contents.length() > 0L) {
                if (this.getCosObject() instanceof CosStream) {
                    this.appendStream(contents, this.getCosStream());
                } else if (this.getCosObject() instanceof CosArray) {
                    CosArray cosArray = this.getCosArray();
                    CosStream newStream = PDFCosObject.newCosStream(this.getPDFDocument());
                    newStream.newDataDecoded(contents);
                    cosArray.add(newStream);
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setContents(InputByteStream contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosStream) {
            this.getCosStream().newDataDecoded(contents);
        } else if (this.getCosObject() instanceof CosArray) {
            CosArray cosArray = this.getCosArray();
            Iterator<CosObject> itr = cosArray.iterator();
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
            CosStream stream = cosArray.getDocument().createCosStream();
            stream.newDataDecoded(contents);
            try {
                if (contents.length() > 15L) {
                    PDFStream pdfStream = PDFStream.getInstance(stream);
                    pdfStream.setOutputFilter(ASName.k_FlateDecode);
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            cosArray.add(stream);
        }
    }

    public void prependContents(InputByteStream contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block18: {
            try {
                if (this.getCosObject() instanceof CosStream) {
                    this.prependStream(contents, this.getCosStream());
                    break block18;
                }
                if (!(this.getCosObject() instanceof CosArray)) break block18;
                CosStream newStream = null;
                CosArray cosArray = null;
                try {
                    cosArray = this.getCosArray();
                    newStream = PDFCosObject.newCosStream(this.getPDFDocument());
                }
                catch (PDFInvalidDocumentException e) {
                    try {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (PDFIOException e) {
                    try {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (PDFSecurityException e) {
                    try {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw e;
                }
                newStream.newDataDecoded(contents);
                int arraySize = cosArray.size();
                if (0 < arraySize) {
                    CosStream lastStream = cosArray.getCosStream(arraySize - 1);
                    cosArray.add(arraySize, lastStream);
                    for (int i = arraySize - 1; 0 < i; --i) {
                        cosArray.set(i, cosArray.get(i - 1));
                    }
                }
                cosArray.set(0, newStream);
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public PDFContentStreamsIterator listIterator() {
        return new PDFContentStreamsIterator();
    }

    public void setOutputFiltersList(CosArray filters) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        CosObject obj = this.getCosObject();
        if (obj instanceof CosStream) {
            CosStream str = (CosStream)obj;
            str.setOutputFiltersList(filters);
        }
        if (obj instanceof CosArray) {
            CosArray arr = (CosArray)obj;
            Iterator<CosObject> iter = arr.iterator();
            while (iter.hasNext()) {
                CosStream str = (CosStream)iter.next();
                str.setOutputFiltersList(filters);
            }
        }
    }

    public class PDFContentStreamsIterator
    implements ListIterator<InputByteStream> {
        private boolean isArray;
        private int arraySize;
        private int nextIndex;
        public ListIterator arrayIter;

        PDFContentStreamsIterator() {
            if (PDFContents.this.getCosObject() instanceof CosArray) {
                this.isArray = true;
                this.arraySize = PDFContents.this.getCosArray().size();
                this.arrayIter = PDFContents.this.getCosArray().listIterator();
            } else if (PDFContents.this.getCosObject() instanceof CosStream) {
                this.isArray = false;
                this.arraySize = 1;
                this.arrayIter = null;
            } else {
                this.isArray = false;
                this.arraySize = 0;
                this.arrayIter = null;
            }
            this.nextIndex = 0;
        }

        @Override
        public int previousIndex() {
            if (this.isArray) {
                return this.arrayIter.previousIndex();
            }
            return this.nextIndex > 0 ? 0 : -1;
        }

        @Override
        public int nextIndex() {
            if (this.isArray) {
                return this.arrayIter.nextIndex();
            }
            return this.nextIndex < this.arraySize ? this.nextIndex : this.arraySize;
        }

        @Override
        public boolean hasNext() {
            if (this.isArray) {
                return this.arrayIter.hasNext();
            }
            return this.nextIndex < this.arraySize;
        }

        @Override
        public InputByteStream next() {
            try {
                if (this.isArray) {
                    return ((CosStream)this.arrayIter.next()).getStreamDecoded();
                }
                if (this.hasNext()) {
                    ++this.nextIndex;
                    return PDFContents.this.getCosStream().getStreamDecoded();
                }
                throw new NoSuchElementException();
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error occured while getting next element.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public boolean hasPrevious() {
            if (this.isArray) {
                return this.arrayIter.hasPrevious();
            }
            return this.nextIndex > 0;
        }

        @Override
        public InputByteStream previous() {
            try {
                if (this.isArray) {
                    return ((CosStream)this.arrayIter.previous()).getStreamDecoded();
                }
                if (this.hasPrevious()) {
                    --this.nextIndex;
                    return PDFContents.this.getCosStream().getStreamDecoded();
                }
                throw new NoSuchElementException();
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error occured while getting next element.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(InputByteStream o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(InputByteStream o) {
            throw new UnsupportedOperationException();
        }
    }
}

