/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFFilterBuildData
extends PDFBuildData {
    private PDFFilterBuildData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFilterBuildData getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFilterBuildData pdfObject = (PDFFilterBuildData)PDFCosObject.getCachedInstance(cosObject, PDFFilterBuildData.class);
        if (pdfObject == null) {
            pdfObject = new PDFFilterBuildData(cosObject);
        }
        return pdfObject;
    }

    public static PDFFilterBuildData newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFFilterBuildData pdfObject = new PDFFilterBuildData(cosObject);
        return pdfObject;
    }
}

