/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFAppBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFilterBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFPubSecBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSigQBuildData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFBuildProp
extends PDFCosDictionary {
    private PDFBuildProp(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFBuildProp getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBuildProp pdfObject = (PDFBuildProp)PDFCosObject.getCachedInstance(cosObject, PDFBuildProp.class);
        if (pdfObject == null) {
            pdfObject = new PDFBuildProp(cosObject);
        }
        return pdfObject;
    }

    public static PDFBuildProp newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFBuildProp pdfObject = new PDFBuildProp(cosObject);
        return pdfObject;
    }

    public PDFFilterBuildData getFilterDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFilterBuildData.getInstance(this.getDictionaryDictionaryValue(ASName.k_Filter));
    }

    public void setFilterDict(PDFFilterBuildData filterDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Filter, filterDict);
    }

    public PDFPubSecBuildData getPubSecDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPubSecBuildData.getInstance(this.getDictionaryDictionaryValue(ASName.k_PubSec));
    }

    public void setPubSecDict(PDFPubSecBuildData pubSecDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PubSec, pubSecDict);
    }

    public PDFAppBuildData getAppDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAppBuildData.getInstance(this.getDictionaryDictionaryValue(ASName.k_App));
    }

    public void setAppDict(PDFAppBuildData appDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_App, appDict);
    }

    public PDFSigQBuildData getSigQDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSigQBuildData.getInstance(this.getDictionaryDictionaryValue(ASName.k_SigQ));
    }

    public void setSigQDict(PDFSigQBuildData sigQDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_SigQ, sigQDict);
    }
}

