/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class TextShowingOperator
extends ContentOperator {
    static final int Tj = 1;
    static final int TJ = 2;
    static final int SingleQuote = 3;
    static final int DoubleQuote = 4;

    TextShowingOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                ASString string = opStack.popString();
                opHandlers.Tj(string, instruction);
                break;
            }
            case 2: {
                ASArray array = opStack.popArray();
                opHandlers.TJ(array, instruction);
                break;
            }
            case 3: {
                ASString string = opStack.popString();
                opHandlers.SingleQuote(string, instruction);
                break;
            }
            case 4: {
                ASString string = opStack.popString();
                double ac = opStack.popNumber().doubleValue();
                double aw = opStack.popNumber().doubleValue();
                opHandlers.DoubleQuote(aw, ac, string, instruction);
                break;
            }
        }
    }
}

