/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class ColorOperator
extends ContentOperator {
    static final int CS = 1;
    static final int cs = 2;
    static final int SC = 3;
    static final int SCN = 4;
    static final int sc = 5;
    static final int scn = 6;
    static final int G = 7;
    static final int g = 8;
    static final int RG = 9;
    static final int rg = 10;
    static final int K = 11;
    static final int k = 12;

    ColorOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                ASName name = opStack.popName();
                opHandlers.CS(name, instruction);
                break;
            }
            case 2: {
                ASName name = opStack.popName();
                opHandlers.cs(name, instruction);
                break;
            }
            case 3: {
                int i = 0;
                float[] colors = new float[opStack.getSize()];
                while (!opStack.isEmpty()) {
                    colors[i++] = opStack.popNumber().floatValue();
                }
                opHandlers.SC(colors, instruction);
                break;
            }
            case 5: {
                int i = 0;
                float[] colors = new float[opStack.getSize()];
                while (!opStack.isEmpty()) {
                    colors[i++] = opStack.popNumber().floatValue();
                }
                opHandlers.sc(colors, instruction);
                break;
            }
            case 4: {
                ASName name = null;
                if (opStack.peekTypeIsName()) {
                    name = opStack.popName();
                }
                int i = 0;
                float[] colors = new float[opStack.getSize()];
                while (!opStack.isEmpty()) {
                    colors[i++] = opStack.popNumber().floatValue();
                }
                if (name == null) {
                    opHandlers.SCN(colors, instruction);
                    break;
                }
                opHandlers.SCN(colors, name, instruction);
                break;
            }
            case 6: {
                ASName name = null;
                if (opStack.peekTypeIsName()) {
                    name = opStack.popName();
                }
                int i = 0;
                float[] colors = new float[opStack.getSize()];
                while (!opStack.isEmpty()) {
                    colors[i++] = opStack.popNumber().floatValue();
                }
                if (name == null) {
                    opHandlers.scn(colors, instruction);
                    break;
                }
                opHandlers.scn(colors, name, instruction);
                break;
            }
            case 7: {
                opHandlers.G(this.getElement(opStack.pop(), 0), instruction);
                break;
            }
            case 8: {
                opHandlers.g(this.getElement(opStack.pop(), 0), instruction);
                break;
            }
            case 9: {
                Object object = opStack.pop();
                float b = this.getElement(object, 2);
                if (object instanceof ASArray) {
                    opHandlers.RG(this.getElement(object, 0), this.getElement(object, 1), b, instruction);
                    break;
                }
                float g = opStack.popNumber().floatValue();
                float r = opStack.popNumber().floatValue();
                opHandlers.RG(r, g, b, instruction);
                break;
            }
            case 10: {
                Object object = opStack.pop();
                float b = this.getElement(object, 2);
                if (object instanceof ASArray) {
                    opHandlers.RG(this.getElement(object, 0), this.getElement(object, 1), b, instruction);
                    break;
                }
                float g = opStack.popNumber().floatValue();
                float r = opStack.popNumber().floatValue();
                opHandlers.rg(r, g, b, instruction);
                break;
            }
            case 11: {
                Object object = opStack.pop();
                float k = this.getElement(object, 3);
                if (object instanceof ASArray) {
                    opHandlers.K(this.getElement(object, 0), this.getElement(object, 1), this.getElement(object, 2), k, instruction);
                    break;
                }
                float y = opStack.popNumber().floatValue();
                float m = opStack.popNumber().floatValue();
                float c = opStack.popNumber().floatValue();
                opHandlers.K(c, m, y, k, instruction);
                break;
            }
            case 12: {
                Object object = opStack.pop();
                float k = this.getElement(object, 3);
                if (object instanceof ASArray) {
                    opHandlers.k(this.getElement(object, 0), this.getElement(object, 1), this.getElement(object, 2), k, instruction);
                    break;
                }
                float y = opStack.popNumber().floatValue();
                float m = opStack.popNumber().floatValue();
                float c = opStack.popNumber().floatValue();
                opHandlers.k(c, m, y, k, instruction);
                break;
            }
        }
    }

    private float getElement(Object element, int index) {
        if (element instanceof ASArray) {
            element = ((ASArray)element).get(index);
        }
        return ((ASNumber)element).floatValue();
    }
}

