/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.pdftoolkit.core.types.NonConformingDateParser;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DateParserNoTimeZone
implements NonConformingDateParser {
    private static final String datePatternStringNoTimeZone = "^(D:)?(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(?:([\\+-Z])')\\z";
    private static final Pattern datePatternCompiled = Pattern.compile("^(D:)?(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(?:([\\+-Z])')\\z");
    private static DateParserNoTimeZone _instance = new DateParserNoTimeZone();
    private static TimeZone tz = new SimpleTimeZone(0, "");

    private DateParserNoTimeZone() {
    }

    static DateParserNoTimeZone getInstance() {
        return _instance;
    }

    @Override
    public GregorianCalendar parse(GregorianCalendar calendar, String s) {
        Matcher matcher = datePatternCompiled.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        int year = Integer.parseInt(matcher.group(2));
        int month = matcher.group(3) == null ? 1 : Integer.parseInt(matcher.group(3));
        int date = matcher.group(4) == null ? 1 : Integer.parseInt(matcher.group(4));
        int hour = matcher.group(5) == null ? 0 : Integer.parseInt(matcher.group(5));
        int minute = matcher.group(6) == null ? 0 : Integer.parseInt(matcher.group(6));
        int second = matcher.group(7) == null ? 0 : Integer.parseInt(matcher.group(7));
        calendar.clear();
        calendar.set(year, month - 1, date, hour, minute, second);
        calendar.setTimeZone(tz);
        return calendar;
    }

    @Override
    public boolean hasTimeZone(GregorianCalendar calendar, String date) {
        return false;
    }
}

