/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import java.io.IOException;

public class ASCoordinate
extends ASObject {
    private double x;
    private double y;
    private static final double PI_BY_2 = 1.5707963267948966;
    private static final double NEG_PI_BY_2 = -1.5707963267948966;

    public ASCoordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public ASCoordinate(ASCoordinate coordinate) {
        this.x = coordinate.x();
        this.y = coordinate.y();
    }

    public ASCoordinate translate(double dx, double dy) {
        return new ASCoordinate(this.x + dx, this.y + dy);
    }

    public ASCoordinate transform(ASMatrix ctm) {
        ASMatrix m = ctm.preMultiply(this.x, this.y);
        return new ASCoordinate(m.getx(), m.gety());
    }

    public double distanceTo(ASCoordinate coord) {
        double a = coord.x - this.x;
        double b = coord.y - this.y;
        return Math.sqrt(a * a + b * b);
    }

    public double distanceToSquare(ASCoordinate coord) {
        double a = coord.x - this.x;
        double b = coord.y - this.y;
        return a * a + b * b;
    }

    public double angleTo(ASCoordinate coord) {
        double x = coord.x - this.x;
        double y = coord.y - this.y;
        if (y == 0.0) {
            return x >= 0.0 ? 0.0 : Math.PI;
        }
        if (x == 0.0) {
            return y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return Math.atan2(y, x);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }
}

