/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.provider.path.PKIXCertPath;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Vector;

public class PKCS7Utils {
    private static final byte[] OID_DH_SINGLE_PASS_STDDH_SHA224_KDF = new byte[]{43, -127, 4, 1, 11, 0};
    private static final byte[] OID_DH_SINGLE_PASS_STDDH_SHA256_KDF = new byte[]{43, -127, 4, 1, 11, 1};
    private static final byte[] OID_DH_SINGLE_PASS_STDDH_SHA384_KDF = new byte[]{43, -127, 4, 1, 11, 2};
    private static final byte[] OID_DH_SINGLE_PASS_STDDH_SHA512_KDF = new byte[]{43, -127, 4, 1, 11, 3};
    private static final byte[] OID_AES128_WRAP = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 5};
    private static final byte[] OID_AES192_WRAP = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 25};
    private static final byte[] OID_AES256_WRAP = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 45};
    private static final byte[] OID_AES128_CBC = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 2};
    private static final byte[] OID_AES192_CBC = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 22};
    private static final byte[] OID_AES256_CBC = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 42};
    private static final byte[] OID_3DES_EDE_CBC = new byte[]{42, -122, 72, -122, -9, 13, 3, 7};
    private static final byte[] OID_RC4_CBC = new byte[]{42, -122, 72, -122, -9, 13, 3, 4};
    private static final byte[] OID_RSA_Encryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] OID_EC_PUBLICKEY = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] OID_EC_PUBLICKEY_PRIME192 = new byte[]{42, -122, 72, -50, 61, 3, 1, 1};
    private static final byte[] OID_EC_PUBLICKEY_PRIME224 = new byte[]{43, -127, 4, 0, 33};
    private static final byte[] OID_EC_PUBLICKEY_PRIME256 = new byte[]{42, -122, 72, -50, 61, 3, 1, 7};
    private static final byte[] OID_EC_PUBLICKEY_PRIME384 = new byte[]{43, -127, 4, 0, 34};
    private static final byte[] OID_EC_PUBLICKEY_PRIME521 = new byte[]{43, -127, 4, 0, 35};
    private static final byte[] OID_PKCS7_DATA = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    private static final byte[] OID_ENVELOPEDDATA = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 3};

    static JSAFE_SymmetricCipher getSymmetricCipher(byte[] dataEncryptionAlgorithm) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (Arrays.equals(dataEncryptionAlgorithm, OID_AES128_CBC)) {
            return JSAFE_SymmetricCipher.getInstance((String)"AES128/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(dataEncryptionAlgorithm, OID_AES192_CBC)) {
            return JSAFE_SymmetricCipher.getInstance((String)"AES192/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(dataEncryptionAlgorithm, OID_AES256_CBC)) {
            return JSAFE_SymmetricCipher.getInstance((String)"AES256/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(dataEncryptionAlgorithm, OID_3DES_EDE_CBC)) {
            return JSAFE_SymmetricCipher.getInstance((String)"3DES_EDE/CBC/NoPad", (String)"Native/Java");
        }
        if (Arrays.equals(dataEncryptionAlgorithm, OID_RC4_CBC)) {
            return JSAFE_SymmetricCipher.getInstance((String)"RC4/CBC/PKCS5Padding", (String)"Native/Java");
        }
        throw new JSAFE_UnimplementedException("data encryption algorithm OID is not supported.");
    }

    static JSAFE_SecretKey getJSAFE_SecretKey(byte[] keyEncryptionOID) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (Arrays.equals(keyEncryptionOID, OID_3DES_EDE_CBC)) {
            return JSAFE_SecretKey.getInstance((String)"3DES_EDE", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES128_WRAP)) {
            return JSAFE_SecretKey.getInstance((String)"AES128", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES192_WRAP)) {
            return JSAFE_SecretKey.getInstance((String)"AES192", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES256_WRAP)) {
            return JSAFE_SecretKey.getInstance((String)"AES256", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_RC4_CBC)) {
            return JSAFE_SecretKey.getInstance((String)"RC4", (String)"Native/Java");
        }
        throw new JSAFE_UnimplementedException("Key encryption OID is not supported.");
    }

    static JSAFE_MessageDigest getKDFHash(byte[] messageDigestOID) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (Arrays.equals(messageDigestOID, OID_DH_SINGLE_PASS_STDDH_SHA224_KDF)) {
            return JSAFE_MessageDigest.getInstance((String)"SHA224", (String)"Java");
        }
        if (Arrays.equals(messageDigestOID, OID_DH_SINGLE_PASS_STDDH_SHA256_KDF)) {
            return JSAFE_MessageDigest.getInstance((String)"SHA256", (String)"Java");
        }
        if (Arrays.equals(messageDigestOID, OID_DH_SINGLE_PASS_STDDH_SHA384_KDF)) {
            return JSAFE_MessageDigest.getInstance((String)"SHA384", (String)"Java");
        }
        if (Arrays.equals(messageDigestOID, OID_DH_SINGLE_PASS_STDDH_SHA512_KDF)) {
            return JSAFE_MessageDigest.getInstance((String)"SHA512", (String)"Java");
        }
        throw new JSAFE_UnimplementedException("KDF SHA is not supported.");
    }

    static String getCurveStrength(byte[] keyEncryptionOID) throws JSAFE_UnimplementedException {
        if (Arrays.equals(keyEncryptionOID, OID_AES128_WRAP) || Arrays.equals(keyEncryptionOID, OID_AES256_WRAP)) {
            return "FIPS186Random";
        }
        throw new JSAFE_UnimplementedException("Elliptic curve strength is not defined.");
    }

    static JSAFE_AsymmetricCipher getAsymmetricCipher(byte[] keyEncryptionOID) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (Arrays.equals(keyEncryptionOID, OID_RSA_Encryption)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"RSA/PKCS1Block02Pad", (String)"Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES128_CBC)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"AES128/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES192_CBC)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"AES192/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_AES256_CBC)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"AES256/CBC/PKCS5Padding", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_3DES_EDE_CBC)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"3DES_EDE/CBC/NoPad", (String)"Native/Java");
        }
        if (Arrays.equals(keyEncryptionOID, OID_RC4_CBC)) {
            return JSAFE_AsymmetricCipher.getInstance((String)"RC4/CBC/PKCS5Padding", (String)"Native/Java");
        }
        throw new JSAFE_UnimplementedException("data encryption algorithm OID is not supported.");
    }

    public static CertJ createCertJContext(RSACredentials[] rsaCredentials, CryptoMode mode) throws CertificateEncodingException, CertificateException, JSAFE_UnimplementedException, InvalidParameterException, ProviderManagementException, InvalidUseException, PKCS7Exception, JSAFE_InvalidUseException {
        Vector<X509Certificate> certificates = new Vector<X509Certificate>();
        Vector crls = new Vector();
        Vector<JSAFE_PrivateKey> privateKeys = new Vector<JSAFE_PrivateKey>();
        Vector<JSAFE_PublicKey> publicKeys = new Vector<JSAFE_PublicKey>();
        for (int credInd = 0; credInd < rsaCredentials.length; ++credInd) {
            X509Certificate rsaX059Cert = rsaCredentials[credInd].getRSAX509Cert();
            certificates.add(rsaX059Cert);
            privateKeys.add(rsaCredentials[credInd].getJSAFEPrivateKey());
            publicKeys.add(rsaX059Cert.getSubjectPublicKey("Java"));
        }
        MemoryDB memoryDB = new MemoryDB("Gibson DB", certificates, crls, privateKeys, publicKeys);
        PKIXCertPath pkixCertPathProvider = new PKIXCertPath("PKIX Cert Path Verifier");
        Provider[] providers = new Provider[]{memoryDB, pkixCertPathProvider};
        CertJ certj = new CertJ(providers);
        if (CertJ.isFIPS140Compliant()) {
            if (mode == CryptoMode.NON_FIPS_MODE) {
                CertJ.setRole((int)10);
                CertJ.setMode((int)1);
                CertJ.setRole((int)11);
            } else if (mode == CryptoMode.FIPS_MODE) {
                CertJ.setRole((int)10);
                CertJ.setMode((int)0);
                CertJ.setRole((int)11);
            }
        }
        return certj;
    }

    static OIDContainer getECDHOIDContainer(String shaValue) throws ASN_Exception, JSAFE_UnimplementedException {
        if (shaValue.equalsIgnoreCase("SHA224")) {
            return new OIDContainer(0, true, 0, OID_DH_SINGLE_PASS_STDDH_SHA224_KDF, 0, OID_DH_SINGLE_PASS_STDDH_SHA224_KDF.length);
        }
        if (shaValue.equalsIgnoreCase("SHA256")) {
            return new OIDContainer(0, true, 0, OID_DH_SINGLE_PASS_STDDH_SHA256_KDF, 0, OID_DH_SINGLE_PASS_STDDH_SHA256_KDF.length);
        }
        if (shaValue.equalsIgnoreCase("SHA384")) {
            return new OIDContainer(0, true, 0, OID_DH_SINGLE_PASS_STDDH_SHA384_KDF, 0, OID_DH_SINGLE_PASS_STDDH_SHA384_KDF.length);
        }
        if (shaValue.equalsIgnoreCase("SHA512")) {
            return new OIDContainer(0, true, 0, OID_DH_SINGLE_PASS_STDDH_SHA512_KDF, 0, OID_DH_SINGLE_PASS_STDDH_SHA512_KDF.length);
        }
        throw new JSAFE_UnimplementedException("ECDH algorithm OID is not supported.");
    }

    static OIDContainer getKeyEncryptionAlgorithmContainer(String algorithm) throws ASN_Exception, JSAFE_UnimplementedException {
        if (algorithm.equalsIgnoreCase("AES128")) {
            return new OIDContainer(0, true, 0, OID_AES128_WRAP, 0, OID_AES128_WRAP.length);
        }
        if (algorithm.equalsIgnoreCase("AES192")) {
            return new OIDContainer(0, true, 0, OID_AES192_WRAP, 0, OID_AES192_WRAP.length);
        }
        if (algorithm.equalsIgnoreCase("AES256")) {
            return new OIDContainer(0, true, 0, OID_AES256_WRAP, 0, OID_AES256_WRAP.length);
        }
        throw new JSAFE_UnimplementedException("Key Encryption algorithm OID is not supported.");
    }

    static OIDContainer getPKCS7DataOID() throws ASN_Exception {
        return new OIDContainer(0x1000000, true, 0, OID_PKCS7_DATA, 0, OID_PKCS7_DATA.length);
    }

    static OIDContainer getEnvelopedDataOID() throws ASN_Exception {
        return new OIDContainer(0x1000000, true, 0, OID_ENVELOPEDDATA, 0, OID_ENVELOPEDDATA.length);
    }

    static OIDContainer getECPublicKeyOID() throws ASN_Exception {
        return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY, 0, OID_EC_PUBLICKEY.length);
    }

    static OIDContainer getECPublicKeyPrimeOID(String strength) throws ASN_Exception, JSAFE_UnimplementedException {
        if (strength.equalsIgnoreCase("SHA192")) {
            return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY_PRIME192, 0, OID_EC_PUBLICKEY_PRIME192.length);
        }
        if (strength.equalsIgnoreCase("SHA224")) {
            return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY_PRIME224, 0, OID_EC_PUBLICKEY_PRIME224.length);
        }
        if (strength.equalsIgnoreCase("SHA256")) {
            return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY_PRIME256, 0, OID_EC_PUBLICKEY_PRIME256.length);
        }
        if (strength.equalsIgnoreCase("SHA384")) {
            return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY_PRIME384, 0, OID_EC_PUBLICKEY_PRIME384.length);
        }
        if (strength.equalsIgnoreCase("SHA512")) {
            return new OIDContainer(0, true, 0, OID_EC_PUBLICKEY_PRIME521, 0, OID_EC_PUBLICKEY_PRIME521.length);
        }
        throw new JSAFE_UnimplementedException("EC Public Key Prime algorithm OID is not supported.");
    }

    static byte[] getECDHOID(Integer strength) throws ASN_Exception, JSAFE_UnimplementedException {
        if (strength == 128) {
            return OID_DH_SINGLE_PASS_STDDH_SHA256_KDF;
        }
        if (strength == -128) {
            return OID_DH_SINGLE_PASS_STDDH_SHA384_KDF;
        }
        if (strength == 256) {
            return OID_DH_SINGLE_PASS_STDDH_SHA512_KDF;
        }
        throw new JSAFE_UnimplementedException("ECDH SHA algorithm OID is not supported.");
    }

    static byte[] getKeyEncryptionAlgorithmOid(String keyEncryptionAlgorithm) throws JSAFE_UnimplementedException, ASN_Exception {
        if (keyEncryptionAlgorithm.equalsIgnoreCase("V2")) {
            return OID_AES128_WRAP;
        }
        if (keyEncryptionAlgorithm.equalsIgnoreCase("AESV2")) {
            return OID_AES192_WRAP;
        }
        if (keyEncryptionAlgorithm.equalsIgnoreCase("AESV3")) {
            return OID_AES256_WRAP;
        }
        throw new JSAFE_UnimplementedException("key Encryption algorithm OID is not supported.");
    }

    static byte[] getDataEncryptionAlgorithmOid(String keyEncryptionAlgorithm) throws JSAFE_UnimplementedException, ASN_Exception {
        if (keyEncryptionAlgorithm.equalsIgnoreCase("V2")) {
            return OID_AES128_CBC;
        }
        if (keyEncryptionAlgorithm.equalsIgnoreCase("AESV2")) {
            return OID_AES192_CBC;
        }
        if (keyEncryptionAlgorithm.equalsIgnoreCase("AESV3")) {
            return OID_AES256_CBC;
        }
        throw new JSAFE_UnimplementedException("Data Encryption algorithm OID is not supported.");
    }

    static SecureRandom getSecureRandom(int keyStrength) throws NoSuchAlgorithmException, JSAFE_UnimplementedException {
        if (keyStrength != 0) {
            return JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
        }
        throw new JSAFE_UnimplementedException("Secure random FIPS186Random is not supported.");
    }
}

