/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosParseBuf;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class CosContainer
extends CosObject {
    protected CosContainer mParentObj;
    private static final ASName k_endobj = ASName.create("endobj");

    CosContainer(CosDocument doc, CosObjectInfo info) {
        super(doc, info);
    }

    abstract void setParentObj(CosContainer var1);

    CosContainer getParentObj() {
        return this.mParentObj;
    }

    @Override
    public boolean markNotDirty() {
        if (this.isIndirect()) {
            return super.markNotDirty();
        }
        if (this.mParentObj != null) {
            return this.mParentObj.markNotDirty();
        }
        return false;
    }

    public Map findObjPos(Map keys) throws PDFIOException {
        try {
            HashMap<ASName, Long[]> retVal = new HashMap<ASName, Long[]>();
            keys.put(k_endobj, 1);
            long curPos = this.getObjPos();
            InputByteStream fileStream = this.getDocument().getStreamRaw();
            long endPos = fileStream.length();
            fileStream.seek(curPos);
            CosParseBuf pBuf = new CosParseBuf(fileStream, 4096);
            int[] indexes = new int[keys.size()];
            byte[][] byteKeys = new byte[keys.size()][];
            ASName[] names = new ASName[keys.size()];
            int[] locIndex = new int[keys.size()];
            int k = 0;
            Iterator it = keys.keySet().iterator();
            while (it.hasNext()) {
                names[k] = (ASName)it.next();
                byteKeys[k] = names[k].getBytes();
                indexes[k] = (Integer)keys.get(names[k]);
                Long[] location = new Long[((Integer)keys.get(names[k])).intValue()];
                for (int i = 0; i < location.length; ++i) {
                    location[i] = 0L;
                }
                retVal.put(names[k], location);
                ++k;
            }
            while (curPos < endPos) {
                int c = pBuf.read();
                ++curPos;
                boolean done = true;
                for (k = 0; k < byteKeys.length; ++k) {
                    if (indexes[k] <= 0) continue;
                    done = false;
                    if ((byte)c == byteKeys[k][locIndex[k]]) {
                        int n = k;
                        locIndex[n] = locIndex[n] + 1;
                    } else {
                        locIndex[k] = 0;
                    }
                    if (locIndex[k] != byteKeys[k].length) continue;
                    Long[] location = (Long[])retVal.get(names[k]);
                    location[((Integer)keys.get((Object)names[k])).intValue() - indexes[k]] = curPos;
                    int n = k;
                    indexes[n] = indexes[n] - 1;
                    locIndex[k] = 0;
                    if (names[k] != k_endobj) continue;
                    return retVal;
                }
                if (!done) continue;
                break;
            }
            return retVal;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    protected int cosObjectPairAlreadyInList(Integer[] objectNums, HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList) {
        HashSet<Integer> matchedCosObjectsSet;
        if (objectNums[0] > objectNums[1]) {
            int temp = objectNums[0];
            objectNums[0] = objectNums[1];
            objectNums[1] = temp;
        }
        if ((matchedCosObjectsSet = alreadyComparedCosObjectPairsList.get(objectNums[0])) != null) {
            if (matchedCosObjectsSet.contains(objectNums[1])) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected boolean addCosObjectPair(int objNum, HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList) {
        Integer[] objectNums = new Integer[]{this.getObjNum(), objNum};
        if (objectNums[0] <= 0 || objectNums[1] <= 0) {
            return true;
        }
        int pairExistenceStatus = this.cosObjectPairAlreadyInList(objectNums, alreadyComparedCosObjectPairsList);
        switch (pairExistenceStatus) {
            case 0: {
                return false;
            }
            case 1: {
                alreadyComparedCosObjectPairsList.get(objectNums[0]).add(objectNums[1]);
                break;
            }
            case 2: {
                HashSet<Integer> matchedCosObjectsSet = new HashSet<Integer>();
                matchedCosObjectsSet.add(objectNums[1]);
                alreadyComparedCosObjectPairsList.put(objectNums[0], matchedCosObjectsSet);
            }
        }
        return true;
    }

    public abstract CosContainerValuesIterator getValuesIterator();

    abstract boolean safeEquals(CosObject var1, HashMap<Integer, HashSet<Integer>> var2);
}

