/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArrayValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CosArray
extends CosContainer {
    protected ArrayList<CosObject> mData;

    protected CosArray(CosDocument doc, ArrayList data, CosObjectInfo info) {
        super(doc, info);
        this.mData = data;
        if (!this.mData.isEmpty() && this.isIndirect()) {
            for (CosObject obj : this.mData) {
                if (obj.isIndirect()) continue;
                if (obj instanceof CosString) {
                    ((CosString)obj).setParentObj(this);
                    continue;
                }
                if (!(obj instanceof CosContainer)) continue;
                ((CosContainer)obj).setParentObj(this);
            }
        }
    }

    CosArray copy() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.isIndirect()) {
            return this;
        }
        CosArray copy = this.getDocument().createCosArray(0);
        Iterator<CosObject> iter = this.iterator();
        while (iter.hasNext()) {
            CosObject obj = iter.next();
            if (!obj.isIndirect()) {
                if (obj instanceof CosArray) {
                    obj = ((CosArray)obj).copy();
                } else if (obj instanceof CosDictionary) {
                    obj = ((CosDictionary)obj).copy();
                } else if (obj instanceof CosString) {
                    obj = ((CosString)obj).copy();
                }
            }
            copy.add(obj);
        }
        return copy;
    }

    @Override
    public int getType() {
        return 5;
    }

    public int size() {
        return this.mData.size();
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public Iterator<CosObject> iterator() {
        return new CosArrayListIterator();
    }

    public ListIterator<CosObject> listIterator() {
        return new CosArrayListIterator();
    }

    @Override
    public CosContainerValuesIterator getValuesIterator() {
        CosObject[] values = new CosObject[this.size()];
        return new CosArrayValuesIterator(this.mData.toArray(values));
    }

    @Override
    public ArrayList<Object> getValue() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.mData != null) {
            for (CosObject obj : this.mData) {
                result.add(obj.getValue());
            }
        }
        result.trimToSize();
        return result;
    }

    public boolean contains(CosObject obj) {
        return this.mData.contains(obj);
    }

    public int findName(ASName name) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int arrayInd = -1;
        for (int iter = 0; iter < this.size(); ++iter) {
            CosObject curElem = this.get(iter);
            if (!(curElem instanceof CosName) || !((CosName)curElem).nameValue().equals(name)) continue;
            arrayInd = iter;
            break;
        }
        return arrayInd;
    }

    public int findString(ASString name) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int arrayInd = -1;
        for (int iter = 0; iter < this.size(); ++iter) {
            CosObject curElem = this.get(iter);
            if (!(curElem instanceof CosString) || !((CosString)curElem).stringValue().equals(name)) continue;
            arrayInd = iter;
            break;
        }
        return arrayInd;
    }

    @Override
    void setParentObj(CosContainer parent) {
        if (this.isIndirect()) {
            return;
        }
        this.mParentObj = parent;
        for (CosObject obj : this.mData) {
            if (obj.isIndirect()) continue;
            if (obj instanceof CosString) {
                ((CosString)obj).setParentObj(parent);
                continue;
            }
            if (!(obj instanceof CosContainer)) continue;
            ((CosContainer)obj).setParentObj(parent);
        }
    }

    public CosObject get(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject result = this.mData.get(pos);
            if (result instanceof CosObjectRef) {
                result = this.getDocument().resolveReference((CosObjectRef)result);
            }
            return result;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    CosObjectRef getRef(int pos) {
        CosObject result = this.mData.get(pos);
        if (result instanceof CosObjectRef) {
            return (CosObjectRef)result;
        }
        return null;
    }

    public int getType(int pos) {
        CosObject val = this.mData.get(pos);
        if (val == null) {
            return 0;
        }
        return val.getType();
    }

    public ASName getName(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.nameValue();
    }

    public boolean getBoolean(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.booleanValue();
    }

    public double getDouble(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.doubleValue();
    }

    public double[] getArrayDouble() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        double[] values = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = this.getDouble(i);
        }
        return values;
    }

    public double[] getArrayDouble(int start, int length) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.getDouble(i + 1);
        }
        return values;
    }

    public long getLong(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.longValue();
    }

    public int getInt(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.intValue();
    }

    public long[] getArrayLong() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        long[] values = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = this.getLong(i);
        }
        return values;
    }

    public int[] getArrayInt() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int[] values = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = this.getInt(i);
        }
        return values;
    }

    public byte[][] getArrayBytes() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int size = this.size();
        byte[][] certs = new byte[size][];
        for (int i = 0; i < size; ++i) {
            certs[i] = this.getString(i).getBytes();
        }
        return certs;
    }

    public ASString getString(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.stringValue();
    }

    public ASHexString getHexString(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.hexStringValue();
    }

    public String getText(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return val.textValue();
    }

    public CosString getCosString(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (CosString)this.get(pos);
    }

    public CosArray getCosArray(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (CosArray)this.get(pos);
    }

    public CosDictionary getCosDictionary(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (CosDictionary)this.get(pos);
    }

    public CosStream getCosStream(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (CosStream)this.get(pos);
    }

    public InputByteStream getStream(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(pos);
        return ((CosStream)val).getStreamDecoded();
    }

    public void clear() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            if (this.mData.isEmpty()) {
                return;
            }
            this.mData.clear();
            if (this.isIndirect()) {
                this.getInfo().markDirty();
            } else if (this.mParentObj != null) {
                this.mParentObj.getInfo().markDirty();
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObject remove(int index) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject removed = this.mData.remove(index);
            if (removed instanceof CosObjectRef) {
                removed = this.getDocument().resolveReference((CosObjectRef)removed);
            }
            if (this.isIndirect()) {
                this.getInfo().markDirty();
            } else if (this.mParentObj != null) {
                this.mParentObj.getInfo().markDirty();
            }
            return removed;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean remove(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            boolean removed = false;
            for (int i = 0; i < this.size(); ++i) {
                CosObject element = this.get(i);
                if (element instanceof CosObjectRef) {
                    element = this.getDocument().resolveReference((CosObjectRef)element);
                }
                if (cosObject != element) continue;
                this.remove(i);
                removed = true;
            }
            return removed;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean add(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.add(this.size(), cosObject, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return true;
    }

    public boolean addName(ASName value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.add(this.getDocument().createCosName(value));
    }

    public boolean addBoolean(boolean value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.add(this.getDocument().createCosBoolean(value));
    }

    public boolean addDouble(double value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.add(this.getDocument().createCosNumeric(value));
    }

    public boolean addLong(long value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.add(this.getDocument().createCosNumeric(value));
    }

    public boolean addInt(int value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.add(this.getDocument().createCosNumeric(value));
    }

    public boolean addText(String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        return this.add(newString);
    }

    public boolean addString(ASString value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        return this.add(newString);
    }

    public void add(int pos, CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.add(pos, cosObject, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void add(int pos, CosObject cosObject, boolean overWrite) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.getDocument() != cosObject.getDocument()) {
            throw new PDFCosParseException("Object and container must be in same document");
        }
        if (cosObject.isIndirect()) {
            if (!(cosObject instanceof CosObjectRef)) {
                cosObject = this.getDocument().getObjectRef(cosObject.getInfo());
            }
            if (overWrite) {
                this.mData.set(pos, cosObject);
            } else {
                this.mData.add(pos, cosObject);
            }
        } else {
            CosContainer parentObj;
            CosContainer cosContainer = parentObj = this.isIndirect() ? this : this.mParentObj;
            if (cosObject instanceof CosContainer) {
                CosContainer oldParentObj = ((CosContainer)cosObject).getParentObj();
                if (oldParentObj != null) {
                    cosObject = cosObject instanceof CosArray ? ((CosArray)cosObject).copy() : ((CosDictionary)cosObject).copy();
                }
                ((CosContainer)cosObject).setParentObj(parentObj);
            } else if (cosObject instanceof CosString) {
                CosContainer oldParentObj = ((CosString)cosObject).getParentObj();
                if (oldParentObj != null) {
                    cosObject = ((CosString)cosObject).copy();
                }
                ((CosString)cosObject).setParentObj(parentObj);
            }
            if (overWrite) {
                this.mData.set(pos, cosObject);
            } else {
                this.mData.add(pos, cosObject);
            }
            if (this.isIndirect()) {
                this.getInfo().markDirty();
            } else if (this.mParentObj != null) {
                this.mParentObj.getInfo().markDirty();
            }
        }
        if (this.isIndirect()) {
            this.getInfo().markDirty();
        } else if (this.mParentObj != null) {
            this.mParentObj.getInfo().markDirty();
        }
    }

    public void addName(int pos, ASName value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.add(pos, this.getDocument().createCosName(value));
    }

    public void addBoolean(int pos, boolean value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.add(pos, this.getDocument().createCosBoolean(value));
    }

    public void addDouble(int pos, double value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.add(pos, this.getDocument().createCosNumeric(value));
    }

    public void addLong(int pos, long value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.add(pos, this.getDocument().createCosNumeric(value));
    }

    public void addInt(int pos, int value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.add(pos, this.getDocument().createCosNumeric(value));
    }

    public void addText(int pos, String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        this.add(pos, newString);
    }

    public void addString(int pos, ASString value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        this.add(pos, newString);
    }

    public boolean set(int pos, CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.add(pos, cosObject, true);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return true;
    }

    public void extendIfNecessaryAndSet(int pos, CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        while (this.mData.size() <= pos) {
            this.mData.add(null);
        }
        this.set(pos, cosObject);
    }

    public boolean setName(int pos, ASName value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosName(value));
    }

    public boolean setName(int pos, String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosName(ASName.create(value)));
    }

    public boolean setBoolean(int pos, boolean value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosBoolean(value));
    }

    public boolean setDouble(int pos, double value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosNumeric(value));
    }

    public boolean setInt(int pos, int value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosNumeric(value));
    }

    public boolean setLong(int pos, long value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.set(pos, this.getDocument().createCosNumeric(value));
    }

    public boolean setString(int pos, ASString value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        return this.set(pos, newString);
    }

    public boolean setText(int pos, String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString newString = this.getDocument().createCosString(value);
        newString.setParentObj(this.isIndirect() ? this : this.mParentObj);
        return this.set(pos, newString);
    }

    @Override
    public boolean equals(CosObject value) {
        HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList = new HashMap<Integer, HashSet<Integer>>();
        return this.safeEquals(value, alreadyComparedCosObjectPairsList);
    }

    @Override
    boolean safeEquals(CosObject value, HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList) {
        if (!(value instanceof CosArray) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        if (!this.addCosObjectPair(value.getObjNum(), alreadyComparedCosObjectPairsList)) {
            return true;
        }
        CosArray valueCosArray = (CosArray)value;
        if (valueCosArray.size() != this.size()) {
            return false;
        }
        ArrayList<Integer> compoundEntriesIndexList = new ArrayList<Integer>();
        try {
            int i;
            CosObject valueAtIndex = null;
            for (i = 0; i < valueCosArray.size(); ++i) {
                valueAtIndex = this.get(i);
                if (valueAtIndex instanceof CosScalar) {
                    if (valueAtIndex.equals(valueCosArray.get(i))) continue;
                    return false;
                }
                compoundEntriesIndexList.add(i);
            }
            for (i = 0; i < compoundEntriesIndexList.size(); ++i) {
                if (((CosContainer)this.get((Integer)compoundEntriesIndexList.get(i))).safeEquals(valueCosArray.get((Integer)compoundEntriesIndexList.get(i)), alreadyComparedCosObjectPairsList)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem occured while equating " + value.getObjNum() + " with " + this.getObjNum(), e);
        }
        return true;
    }

    public void setEncryptionState(boolean state) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            Iterator<CosObject> iter = this.iterator();
            while (iter.hasNext()) {
                CosObject value = iter.next();
                if (value.getType() == 4) {
                    ((CosString)value).setIsEncrypted(state);
                    ((CosString)value).setToEncrypt(state);
                    continue;
                }
                if (value.getType() == 7) {
                    ((CosStream)value).setIsEncrypted(state);
                    ((CosStream)value).setToEncrypt(state);
                    continue;
                }
                if (value.getType() == 6) {
                    ((CosDictionary)value).setEncryptionState(state);
                    continue;
                }
                if (value.getType() != 5) continue;
                ((CosArray)value).setEncryptionState(state);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosArray splitBefore(int pos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int i;
        CosArray newArray = null;
        if (this.isIndirect()) {
            newArray = this.getDocument().createCosArray(1);
        } else {
            newArray = this.getDocument().createCosArray(0);
            newArray.setParentObj(this.mParentObj);
        }
        int siz = this.size();
        for (i = pos; i < siz; ++i) {
            newArray.add(this.get(i));
        }
        for (i = pos; i < siz; ++i) {
            this.remove(pos);
        }
        return newArray;
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        outStream.write(91);
        Iterator<CosObject> iter = this.mData.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            CosObject item = iter.next();
            if (!first && (item.isIndirect() || item instanceof CosBoolean || item instanceof CosNumeric || item instanceof CosNull)) {
                outStream.write(32);
            }
            item.writeOut(outStream, inString, inDebugMode);
            first = false;
        }
        outStream.write(93);
    }

    public ASName[] getArrayName() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName[] values = new ASName[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = this.getName(i);
        }
        return values;
    }

    public class CosArrayListIterator
    implements ListIterator<CosObject> {
        private int nextIndx = 0;
        private boolean nextCalled = false;
        private boolean previousCalled = false;

        CosArrayListIterator() {
        }

        @Override
        public int nextIndex() {
            return this.nextIndx;
        }

        @Override
        public int previousIndex() {
            return this.nextIndx - 1;
        }

        @Override
        public void remove() {
            if (!this.nextCalled && !this.previousCalled) {
                throw new IllegalStateException("neither next nor previous have been called, or remove or add have been called after the last call to * next or previous.");
            }
            try {
                if (this.nextCalled) {
                    CosArray.this.remove(--this.nextIndx);
                } else {
                    CosArray.this.remove(this.nextIndx);
                }
                this.nextCalled = false;
                this.previousCalled = false;
            }
            catch (PDFException e) {
                IllegalArgumentException newException = new IllegalArgumentException();
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndx < CosArray.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndx > 0;
        }

        @Override
        public CosObject next() {
            if (this.nextIndx >= CosArray.this.size()) {
                throw new NoSuchElementException();
            }
            try {
                this.nextCalled = true;
                this.previousCalled = false;
                return CosArray.this.get(this.nextIndx++);
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException();
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public CosObject previous() {
            try {
                this.previousCalled = true;
                this.nextCalled = false;
                return CosArray.this.get(--this.nextIndx);
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException();
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void add(CosObject o) {
            try {
                CosArray.this.add(this.nextIndx++, o);
                this.nextCalled = false;
                this.previousCalled = false;
            }
            catch (PDFException e) {
                IllegalArgumentException newException = new IllegalArgumentException();
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void set(CosObject o) {
            if (!this.nextCalled && !this.previousCalled) {
                throw new IllegalStateException("neither next nor previous have been called, or remove or add have been called after the last call to next or previous");
            }
            try {
                if (this.nextCalled) {
                    CosArray.this.set(this.nextIndx - 1, o);
                } else {
                    CosArray.this.set(this.nextIndx, o);
                }
            }
            catch (PDFException e) {
                IllegalArgumentException newException = new IllegalArgumentException();
                newException.initCause(e);
                throw newException;
            }
        }
    }
}

