/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public final class F26Dot6 {
    public static final int ZERO = 0;
    public static final int ONE = 64;
    public static final int ONE_HALF = 32;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    private static final DecimalFormat df = new DecimalFormat("0.##");

    public static int truncate(int v) {
        return v & 0xFFFFFFC0;
    }

    public static int ceiling(int v) {
        return F26Dot6.truncate(v + 64 - 1);
    }

    public static int floor(int v) {
        return F26Dot6.truncate(v);
    }

    public static int round(int v) {
        return F26Dot6.truncate(v + 32);
    }

    public static int roundHalfUp(int v) {
        return F26Dot6.truncate(v + 32);
    }

    public static int roundHalfDown(int v) {
        return F26Dot6.truncate(v + 32 - 1);
    }

    public static int negate(int v) {
        return -v;
    }

    public static int abs(int v) {
        return v < 0 ? -v : v;
    }

    public static int add(int v1, int v2) {
        return v1 + v2;
    }

    public static int subtract(int v1, int v2) {
        return v1 - v2;
    }

    private static int clamp(long x) {
        if (x > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static int multiply(int v1, int v2) {
        return F26Dot6.clamp((long)v1 * (long)v2 >> 6);
    }

    public static int divide(int v1, int v2) {
        return (int)((long)v1 << 6) / v2;
    }

    public static int multiplyByF2Dot14(int v1, int v2) {
        return F26Dot6.clamp(((long)v1 * (long)((short)v2) >> 13) + 1L >> 1);
    }

    public static int divideByF2Dot14(int v1, int v2) {
        return (int)((long)v1 << 14) / v2;
    }

    public static int multiplyByF16Dot16(int v1, int v2) {
        return F26Dot6.clamp(((long)v1 * (long)v2 >> 15) + 1L >> 1);
    }

    public static int divideByF16Dot16(int v1, int v2) {
        return (int)(((long)v1 << 16) / (long)v2);
    }

    public static int multiplyDivide(int v1, int v2, int v3) {
        long numerator = (long)v1 * (long)v2;
        long denominator = v3;
        boolean negate = false;
        if (numerator < 0L) {
            numerator = -numerator;
            boolean bl = negate = !negate;
        }
        if (denominator < 0L) {
            denominator = -denominator;
            negate = !negate;
        }
        long v = (numerator + denominator / 2L) / denominator;
        if (negate) {
            return F26Dot6.clamp(-v);
        }
        return F26Dot6.clamp(v);
    }

    public static int multiplyByF2Dot14DivideByF2Dot14(int v1, int v2, int v3) {
        return F26Dot6.multiplyDivide(v1, v2, v3);
    }

    public static boolean isEven(int v1) {
        return (v1 & 0x40) == 0;
    }

    public static boolean sameSign(int v1, int v2) {
        return (v1 & Integer.MIN_VALUE) == (v2 & Integer.MIN_VALUE);
    }

    public static int min(int v1, int v2) {
        return Math.min(v1, v2);
    }

    public static int max(int v1, int v2) {
        return Math.max(v1, v2);
    }

    public static double toDouble(int v) {
        return (double)v / 64.0;
    }

    public static int fromDouble(double v) {
        return (int)Math.round(v * 64.0);
    }

    public static int toInt(int v) {
        return v >> 6;
    }

    public static int fromInt(int v) {
        return v << 6;
    }

    public static String toString(int v) {
        return df.format(F26Dot6.toDouble(v));
    }
}

