/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public class F16Dot16 {
    public static final int ZERO = 0;
    public static final int ONE = 65536;
    public static final int ONE_HALF = 32768;
    private static final DecimalFormat df = new DecimalFormat("0.###");

    private static int clamp(long x) {
        if (x > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static int truncate(int v) {
        return v & 0xFFFF0000;
    }

    public static int multiply(int v1, int v2) {
        return F16Dot16.clamp((long)v1 * (long)v2 >> 16);
    }

    public static int square(int v) {
        return F16Dot16.multiply(v, v);
    }

    public static int multiplyByF2Dot14(int v1, int v2) {
        return F16Dot16.clamp(((long)v1 * (long)v2 >> 13) + 1L >> 1);
    }

    public static int multiplyDivide(int v1, int v2, int v3) {
        long numerator = (long)v1 * (long)v2;
        long denominator = v3;
        boolean negate = false;
        if (numerator < 0L) {
            numerator = -numerator;
            boolean bl = negate = !negate;
        }
        if (denominator < 0L) {
            denominator = -denominator;
            negate = !negate;
        }
        long v = (numerator + denominator / 2L) / denominator;
        if (negate) {
            return F16Dot16.clamp(-v);
        }
        return F16Dot16.clamp(v);
    }

    public static int divide(int v1, int v2) {
        return F16Dot16.clamp(((long)v1 << 16) / (long)v2);
    }

    public static int round(int v) {
        return F16Dot16.truncate(v + 32768);
    }

    public static double toDouble(int v) {
        return (double)v / 65536.0;
    }

    public static int fromDouble(double v) {
        return (int)(v * 65536.0);
    }

    public static int fromInt(int v) {
        return v << 16;
    }

    public static String toString(int v) {
        return df.format(F16Dot16.toDouble(v));
    }
}

