/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDatabase;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSelector;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ZapfDingbatsEncoding;
import java.util.List;

public final class PDF16RichTextFormatter {
    private final CSS20FontSelector cssFontSelector;

    private PDF16RichTextFormatter(CSS20FontSet fontSet) {
        this.cssFontSelector = new CSS20FontSelector(fontSet);
    }

    public static PDF16RichTextFormatter getFormatterInstance(CSS20FontSet fontSet) {
        if (fontSet == null) {
            return null;
        }
        return new PDF16RichTextFormatter(fontSet);
    }

    public static CSS20FontSet getFontSetInstance() {
        return new CSS20FontDatabase(true);
    }

    public static CSS20FontSet getFontSetInstance(FamilyNameNormalizer normalizer) {
        return new CSS20FontDatabase(normalizer, true);
    }

    public static CSS20FontSet getFontSetInstance(CSS20FontSet original) {
        if (original instanceof CSS20FontDatabase) {
            return new CSS20FontDatabase((CSS20FontDatabase)original);
        }
        return null;
    }

    public int preFormat(AttributedRun run, int start, int limit) throws FontException, FormattingException {
        limit = InFontFormatter.preFormat(run, start, limit);
        return limit;
    }

    public int format(AttributedRun run, int start, int limit) throws FontException, FormattingException {
        return this.format(run, start, limit, true);
    }

    public int format(AttributedRun run, int start, int limit, boolean shouldKern) throws FontException, FormattingException {
        int i = start;
        while (i < limit) {
            int attLimit = run.getSubrunLimit(i, limit, ElementAttribute.CSS20Attribute);
            List familyNames = ((CSS20Attribute)run.getElementStyle(start, ElementAttribute.CSS20Attribute)).getFamilyNamesList();
            if (familyNames.size() > 0 && "Adobe Pi Std".equals(familyNames.get(0))) {
                ZapfDingbatsEncoding.remap(run, i, attLimit);
            }
            i = attLimit;
        }
        limit = InFontFormatter.firstPass(run, start, limit);
        limit = this.cssFontSelector.format(run, start, limit);
        return InFontFormatter.format(run, start, limit, shouldKern);
    }
}

