/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.type1.AFM;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.PFM;
import com.adobe.fontengine.font.type1.Type1Font;
import java.io.IOException;
import java.net.URL;

public final class FontFactory {
    private static final byte[] kType1PFAStart1 = new byte[]{37, 33, 80, 83, 45, 65, 100, 111, 98, 101, 70, 111, 110, 116};
    private static final byte[] kType1PFAStart2 = new byte[]{37, 33, 70, 111, 110, 116, 84, 121, 112, 101, 49};
    private static final byte[] kType1PFAStart3 = new byte[]{37, 33, 70, 111, 110, 116, 84, 121, 112, 101, 32, 49};
    private static final byte[] kAFMStart = new byte[]{83, 116, 97, 114, 116, 70, 111, 110, 116, 77, 101, 116, 114, 105, 99, 115};
    private static final byte[] kType1PFBStart = new byte[]{-128, 1};
    private static final int maxT1BytesNeeded = 6 + kType1PFAStart1.length;

    public static int getNumBytesNeededToIdentify() {
        return maxT1BytesNeeded;
    }

    private static boolean startsWithType1(byte[] startingBytes, int offset) {
        return SubArrays.arrayCompare(kType1PFAStart1, 0, startingBytes, offset, kType1PFAStart1.length) || SubArrays.arrayCompare(kType1PFAStart2, 0, startingBytes, offset, kType1PFAStart2.length) || SubArrays.arrayCompare(kType1PFAStart3, 0, startingBytes, offset, kType1PFAStart3.length);
    }

    private static boolean isPFA(byte[] startingBytes) {
        return FontFactory.startsWithType1(startingBytes, 0);
    }

    private static boolean isPFB(byte[] startingBytes) {
        if (SubArrays.arrayCompare(kType1PFBStart, 0, startingBytes, 0, kType1PFBStart.length)) {
            return FontFactory.startsWithType1(startingBytes, 6);
        }
        return false;
    }

    public static boolean isType1(byte[] startingBytes) {
        return FontFactory.isPFB(startingBytes) || FontFactory.isPFA(startingBytes);
    }

    public static int getNumBytesNeededToIdentifyAFM() {
        return kAFMStart.length;
    }

    public static boolean isAFM(byte[] startingBytes) {
        if (startingBytes.length < FontFactory.getNumBytesNeededToIdentifyAFM()) {
            return false;
        }
        return SubArrays.arrayCompare(startingBytes, 0, kAFMStart, 0, kAFMStart.length);
    }

    public static int getNumBytesNeededToIdentifyPFM() {
        return 68;
    }

    public static boolean isPFM(byte[] startingBytes) {
        if (startingBytes.length < FontFactory.getNumBytesNeededToIdentifyPFM()) {
            return false;
        }
        return startingBytes[0] == 0 && startingBytes[1] == 1 && (startingBytes[66] & 0xFF) == 129 && startingBytes[67] == 0 && ((startingBytes[3] & 0xFF) << 8 | startingBytes[2] & 0xFF) >= FontFactory.getNumBytesNeededToIdentify();
    }

    public static Type1Font[] load(FontInputStream in, URL url) throws IOException, InvalidFontException, UnsupportedFontException {
        Type1Font font = new Type1Font(in, url);
        Type1Font[] fontArr = new Type1Font[]{font};
        return fontArr;
    }

    public static MetricFile loadAFM(FontInputStream str, URL url) throws IOException, InvalidFontException {
        return AFM.createAFM(str, url);
    }

    public static MetricFile loadPFM(FontInputStream str, URL url) throws IOException, InvalidFontException {
        return PFM.createPFM(str, url);
    }
}

